/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.squirrel_sql.client.gui.session;

import java.awt.Dimension;
import java.awt.FontMetrics;
import java.awt.Insets;
import javax.swing.JLabel;
import javax.swing.border.Border;
import javax.swing.event.CaretEvent;
import javax.swing.event.CaretListener;
import net.sourceforge.squirrel_sql.client.session.ISQLEntryPanel;
import net.sourceforge.squirrel_sql.fw.util.StringManager;
import net.sourceforge.squirrel_sql.fw.util.StringManagerFactory;

class RowColumnLabel
extends JLabel {
    private ISQLEntryPanel _sqlEntryPanel;
    private StringBuffer _msg = new StringBuffer();
    private static final StringManager s_stringMgr = StringManagerFactory.getStringManager(RowColumnLabel.class);
    private Dimension _dim;

    RowColumnLabel(ISQLEntryPanel sqlEntryPanel) {
        super(" ", 0);
        this._sqlEntryPanel = sqlEntryPanel;
        sqlEntryPanel.addCaretListener(new CaretListener(){

            @Override
            public void caretUpdate(CaretEvent e) {
                RowColumnLabel.this.onCaretUpdate(e);
            }
        });
        this.writePosition(0, 0, 0);
        this.setToolTipText(s_stringMgr.getString("RowColumnLabel.tooltip"));
    }

    private void onCaretUpdate(CaretEvent e) {
        int caretLineNumber = this._sqlEntryPanel.getCaretLineNumber();
        int caretLinePosition = this._sqlEntryPanel.getCaretLinePosition();
        int caretPosition = this._sqlEntryPanel.getCaretPosition();
        this.writePosition(caretLineNumber, caretLinePosition, caretPosition);
    }

    private void writePosition(int caretLineNumber, int caretLinePosition, int caretPosition) {
        this._msg.setLength(0);
        this._msg.append(caretLineNumber + 1).append(",").append(caretLinePosition + 1).append(" / ").append(caretPosition + 1);
        this.setText(this._msg.toString());
    }

    @Override
    public Dimension getPreferredSize() {
        if (null == this._dim) {
            this._dim = this.calcPrefSize();
        }
        return this._dim;
    }

    private Dimension calcPrefSize() {
        Insets ins;
        Dimension dim = super.getPreferredSize();
        FontMetrics fm = this.getFontMetrics(this.getFont());
        dim.width = fm.stringWidth("000,000 / 00000000");
        Border border = this.getBorder();
        if (border != null && (ins = border.getBorderInsets(this)) != null) {
            dim.width += ins.left + ins.right;
        }
        if ((ins = this.getInsets()) != null) {
            dim.width += ins.left + ins.right;
        }
        return dim;
    }
}

