/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.squirrel_sql.client.session;

import java.awt.Frame;
import java.io.BufferedInputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import javax.swing.JFileChooser;
import net.sourceforge.squirrel_sql.client.gui.desktopcontainer.SessionTabWidget;
import net.sourceforge.squirrel_sql.client.preferences.SquirrelPreferences;
import net.sourceforge.squirrel_sql.client.session.FileChooserManager;
import net.sourceforge.squirrel_sql.client.session.ISQLPanelAPI;
import net.sourceforge.squirrel_sql.client.session.SessionUtils;
import net.sourceforge.squirrel_sql.fw.gui.ChooserPreviewer;
import net.sourceforge.squirrel_sql.fw.gui.Dialogs;
import net.sourceforge.squirrel_sql.fw.util.IOUtilities;
import net.sourceforge.squirrel_sql.fw.util.IOUtilitiesImpl;
import net.sourceforge.squirrel_sql.fw.util.StringManager;
import net.sourceforge.squirrel_sql.fw.util.StringManagerFactory;
import net.sourceforge.squirrel_sql.fw.util.StringUtilities;

public class FileManager {
    private ISQLPanelAPI _sqlPanelAPI;
    private File _toSaveTo = null;
    private static final StringManager s_stringMgr = StringManagerFactory.getStringManager(FileManager.class);
    private FileChooserManager _fileChooserManager = new FileChooserManager();
    private IOUtilities ioUtil = new IOUtilitiesImpl();

    public void setIOUtilities(IOUtilities ioutilities) {
        this.ioUtil = ioutilities;
    }

    FileManager(ISQLPanelAPI sqlPanelAPI) {
        this._sqlPanelAPI = sqlPanelAPI;
    }

    public boolean save() {
        return this.saveIntern(false);
    }

    public boolean saveAs() {
        return this.saveIntern(true);
    }

    public boolean open(File f) {
        return this.open(f, false);
    }

    public boolean open(File f, boolean appendToExisting) {
        boolean result = false;
        this._sqlPanelAPI.getSession().selectMainTab(1);
        result = true;
        if (!appendToExisting) {
            this._sqlPanelAPI.setEntireSQLScript("");
        }
        this.loadScript(f);
        return result;
    }

    public boolean open(boolean appendToExisting) {
        boolean result = false;
        JFileChooser chooser = this._fileChooserManager.getFileChooser();
        chooser.setAccessory(new ChooserPreviewer());
        SquirrelPreferences prefs = this._sqlPanelAPI.getSession().getApplication().getSquirrelPreferences();
        Frame frame = SessionUtils.getOwningFrame(this._sqlPanelAPI);
        if (prefs.isFileOpenInPreviousDir()) {
            String fileName = prefs.getFilePreviousDir();
            if (fileName != null) {
                chooser.setCurrentDirectory(new File(fileName));
            }
        } else {
            String dirName = prefs.getFileSpecifiedDir();
            if (dirName != null) {
                chooser.setCurrentDirectory(new File(dirName));
            }
        }
        this._sqlPanelAPI.getSession().selectMainTab(1);
        if (chooser.showOpenDialog(frame) == 0) {
            result = true;
            File selectedFile = chooser.getSelectedFile();
            if (!appendToExisting) {
                this._sqlPanelAPI.setEntireSQLScript("");
            }
            this.loadScript(selectedFile);
        }
        return result;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void loadScript(File file) {
        SquirrelPreferences prefs = this._sqlPanelAPI.getSession().getApplication().getSquirrelPreferences();
        FileInputStream fis = null;
        BufferedInputStream bis = null;
        try {
            StringBuffer sb = new StringBuffer();
            fis = new FileInputStream(file);
            bis = new BufferedInputStream(fis);
            byte[] bytes = new byte[2048];
            int iRead = bis.read(bytes);
            while (iRead != -1) {
                sb.append(new String(bytes, 0, iRead));
                iRead = bis.read(bytes);
            }
            this._sqlPanelAPI.appendSQLScript(this.convertPlatformEOLToLineFeed(sb.toString()), true);
            this.setFile(file);
            this.memorizeFile(file, prefs);
            this.ioUtil.closeInputStream(bis);
            this.ioUtil.closeInputStream(fis);
        }
        catch (IOException io) {
            this._sqlPanelAPI.getSession().showErrorMessage(io);
        }
        finally {
            this.ioUtil.closeInputStream(bis);
            this.ioUtil.closeInputStream(fis);
        }
    }

    private void memorizeFile(File file, SquirrelPreferences prefs) {
        prefs.setFilePreviousDir(file.getAbsolutePath());
        this._sqlPanelAPI.getSession().getApplication().getRecentFilesManager().fileTouched(file.getAbsolutePath(), this._sqlPanelAPI.getSession().getAlias());
    }

    private boolean saveIntern(boolean toNewFile) {
        boolean result = false;
        if (toNewFile) {
            this._toSaveTo = null;
        }
        JFileChooser chooser = this._fileChooserManager.getFileChooser();
        SquirrelPreferences prefs = this._sqlPanelAPI.getSession().getApplication().getSquirrelPreferences();
        Frame frame = SessionUtils.getOwningFrame(this._sqlPanelAPI);
        if (null == this._toSaveTo) {
            if (prefs.isFileOpenInPreviousDir()) {
                String dirName = prefs.getFilePreviousDir();
                if (dirName != null) {
                    chooser.setCurrentDirectory(new File(dirName));
                }
            } else {
                String dirName = prefs.getFileSpecifiedDir();
                if (dirName != null) {
                    chooser.setCurrentDirectory(new File(dirName));
                }
            }
        }
        this._sqlPanelAPI.getSession().selectMainTab(1);
        if (null != this._toSaveTo) {
            if (this.saveScript(frame, this._toSaveTo, false)) {
                result = true;
            }
        } else if (chooser.showSaveDialog(frame) == 0) {
            this._fileChooserManager.saveWasApproved();
            this._toSaveTo = chooser.getSelectedFile();
            if (!this._toSaveTo.exists() && null != this._fileChooserManager.getSelectedFileEnding() && !this._toSaveTo.getAbsolutePath().endsWith(this._fileChooserManager.getSelectedFileEnding())) {
                this._toSaveTo = new File(this._toSaveTo.getAbsolutePath() + this._fileChooserManager.getSelectedFileEnding());
            }
            if (this.saveScript(frame, this._toSaveTo, true)) {
                result = true;
            } else {
                this._toSaveTo = null;
                result = false;
            }
        }
        return result;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean saveScript(Frame frame, File file, boolean askReplace) {
        boolean doSave = false;
        if (file.exists() && !file.canWrite()) {
            String msg = s_stringMgr.getString("FileManager.error.cannotwritefile", file.getAbsolutePath());
            Dialogs.showOk(frame, msg);
            return false;
        }
        if (askReplace && file.exists()) {
            String confirmMsg = s_stringMgr.getString("FileManager.confirm.filereplace", file.getAbsolutePath());
            doSave = Dialogs.showYesNo(frame, confirmMsg);
            if (!doSave) {
                return false;
            }
            file.delete();
        } else {
            doSave = true;
        }
        SquirrelPreferences prefs = this._sqlPanelAPI.getSession().getApplication().getSquirrelPreferences();
        if (doSave) {
            this.memorizeFile(file, prefs);
            FileOutputStream fos = null;
            try {
                fos = new FileOutputStream(file);
                String sScript = this.getEntireSQLScriptWithPlatformEolChar();
                fos.write(sScript.getBytes());
                this.setFile(file);
                String msg = s_stringMgr.getString("FileManager.savedfile", file.getAbsolutePath());
                this._sqlPanelAPI.getSession().showMessage(msg);
            }
            catch (IOException ex) {
                this._sqlPanelAPI.getSession().showErrorMessage(ex);
            }
            finally {
                this.ioUtil.closeOutputStream(fos);
            }
        }
        return true;
    }

    private String getEntireSQLScriptWithPlatformEolChar() {
        String result = this._sqlPanelAPI.getEntireSQLScript();
        return this.convertLineFeedToPlatformEOL(result);
    }

    private String convertLineFeedToPlatformEOL(String result) {
        String platformEolStr = StringUtilities.getEolStr();
        if (result != null && !"".equals(result)) {
            result = result.replaceAll("\\r", "");
            if (!platformEolStr.equals("\n")) {
                result = result.replaceAll("\\n", platformEolStr);
            }
        }
        return result;
    }

    private String convertPlatformEOLToLineFeed(String s) {
        String platformEolStr = StringUtilities.getEolStr();
        if (null == s || "".equals(s)) {
            return s;
        }
        if (!platformEolStr.equals("\n")) {
            s = s.replaceAll(platformEolStr, "\n");
        }
        return s.replaceAll("\\r", "");
    }

    private void setFile(File file) {
        this._toSaveTo = file;
        this.getActiveSessionTabWidget().setSqlFile(file);
    }

    private SessionTabWidget getActiveSessionTabWidget() {
        return (SessionTabWidget)this._sqlPanelAPI.getSession().getActiveSessionWindow();
    }

    public File getFile() {
        return this._toSaveTo;
    }

    public void clearCurrentFile() {
        this._toSaveTo = null;
    }
}

