/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.squirrel_sql.client.session.mainpanel.lazyresulttab;

import java.awt.Component;
import javax.swing.JTabbedPane;
import net.sourceforge.squirrel_sql.client.session.ISession;
import net.sourceforge.squirrel_sql.client.session.mainpanel.lazyresulttab.LazyResultTabControllerFactory;
import net.sourceforge.squirrel_sql.client.session.mainpanel.lazyresulttab.LazyResultTabInitializer;
import net.sourceforge.squirrel_sql.client.session.mainpanel.overview.OverviewCtrl;
import net.sourceforge.squirrel_sql.client.session.mainpanel.rotatedtable.RotatedTableCtrl;
import net.sourceforge.squirrel_sql.client.session.mainpanel.textresult.TextResultCtrl;
import net.sourceforge.squirrel_sql.fw.datasetviewer.ResultSetDataSet;

public class AdditionalResultTabsController {
    private final ISession _session;
    private final JTabbedPane _tabResultTabs;
    private boolean _isOutputAsTable;
    private LazyResultTabInitializer<OverviewCtrl> _overviewInitializer;
    private LazyResultTabInitializer<RotatedTableCtrl> _rotatedTableInitializer;
    private LazyResultTabInitializer<TextResultCtrl> _textResultController;

    public AdditionalResultTabsController(ISession session, JTabbedPane tabResultTabs, boolean isOutputAsTable) {
        this._session = session;
        this._tabResultTabs = tabResultTabs;
        this._isOutputAsTable = isOutputAsTable;
        this._overviewInitializer = new LazyResultTabInitializer<OverviewCtrl>(this._session, this._tabResultTabs, new LazyResultTabControllerFactory<OverviewCtrl>(){

            @Override
            public OverviewCtrl create() {
                return new OverviewCtrl(AdditionalResultTabsController.this._session);
            }

            @Override
            public boolean isMatchingPanel(Component comp) {
                return OverviewCtrl.isOverviewPanel(comp);
            }
        });
        this._overviewInitializer.initTab();
        this._rotatedTableInitializer = new LazyResultTabInitializer<RotatedTableCtrl>(this._session, this._tabResultTabs, new LazyResultTabControllerFactory<RotatedTableCtrl>(){

            @Override
            public RotatedTableCtrl create() {
                return new RotatedTableCtrl(AdditionalResultTabsController.this._session);
            }

            @Override
            public boolean isMatchingPanel(Component comp) {
                return RotatedTableCtrl.isRotatedTablePanel(comp);
            }
        });
        this._rotatedTableInitializer.initTab();
        if (this._isOutputAsTable) {
            this._textResultController = new LazyResultTabInitializer<TextResultCtrl>(this._session, this._tabResultTabs, new LazyResultTabControllerFactory<TextResultCtrl>(){

                @Override
                public TextResultCtrl create() {
                    return new TextResultCtrl();
                }

                @Override
                public boolean isMatchingPanel(Component comp) {
                    return TextResultCtrl.isTextResultPanel(comp);
                }
            });
            this._textResultController.initTab();
        }
    }

    public void setCurrentResult(ResultSetDataSet rsds) {
        this._overviewInitializer.setCurrentResult(rsds);
        this._rotatedTableInitializer.setCurrentResult(rsds);
        if (this._isOutputAsTable) {
            this._textResultController.setCurrentResult(rsds);
        }
    }

    public void moreResultsHaveBeenRead() {
        this._overviewInitializer.moreResultsHaveBeenRead();
        this._rotatedTableInitializer.moreResultsHaveBeenRead();
        if (this._isOutputAsTable) {
            this._textResultController.moreResultsHaveBeenRead();
        }
    }
}

