/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.squirrel_sql.client.session.mainpanel.overview;

import java.util.ArrayList;
import net.sourceforge.squirrel_sql.client.session.mainpanel.overview.ChartConfigPanelTabMode;
import net.sourceforge.squirrel_sql.client.session.mainpanel.overview.datascale.DataScale;
import net.sourceforge.squirrel_sql.client.session.mainpanel.overview.datascale.IndexedColumnFactory;
import net.sourceforge.squirrel_sql.fw.datasetviewer.ColumnDisplayDefinition;
import net.sourceforge.squirrel_sql.fw.util.StringManager;

public enum ChartConfigMode {
    COUNT("overview.ChartConfigMode.modusCount", "overview.ChartConfigMode.modusCountAxisLabel", "aggCount"),
    SUM("overview.ChartConfigMode.modusSum", "overview.ChartConfigMode.modusSumAxisLabel", "aggSum"),
    XY_COUNT_DISTINCT("overview.ChartConfigMode.modusCountDistinct", "overview.ChartConfigMode.modusCountDistinctAxisLabel", "aggCount"),
    XY_SUM_COL("overview.ChartConfigMode.modusSum", "overview.ChartConfigMode.modusSumAxisLabelOfColumn", "aggSum");

    private final String _modusI18nKey;
    private String _axisLabelI18nKey;
    private final String _modusIconName;
    private StringManager _s_stringMgr;

    private ChartConfigMode(String modusI18nKey, String axisLabelI18nKey, String modusIconName) {
        this._modusI18nKey = modusI18nKey;
        this._axisLabelI18nKey = axisLabelI18nKey;
        this._modusIconName = modusIconName;
    }

    public static ChartConfigMode[] getAvailableValues(ColumnDisplayDefinition columnDisplayDefinition, ChartConfigPanelTabMode chartConfigPanelTabMode, StringManager s_stringMgr) {
        ArrayList<ChartConfigMode> ret = new ArrayList<ChartConfigMode>();
        for (ChartConfigMode chartConfigMode : ChartConfigMode.values()) {
            chartConfigMode.setStringManager(s_stringMgr);
        }
        if (ChartConfigPanelTabMode.SINGLE_COLUMN == chartConfigPanelTabMode) {
            ret.add(COUNT);
            if (IndexedColumnFactory.isNumber(columnDisplayDefinition)) {
                ret.add(SUM);
            }
        } else if (ChartConfigPanelTabMode.TWO_COLUMN == chartConfigPanelTabMode) {
            ret.add(XY_COUNT_DISTINCT);
            if (IndexedColumnFactory.isNumber(columnDisplayDefinition)) {
                ret.add(XY_SUM_COL);
            }
        }
        return ret.toArray(new ChartConfigMode[ret.size()]);
    }

    private void setStringManager(StringManager s_stringMgr) {
        this._s_stringMgr = s_stringMgr;
    }

    public String toString() {
        return this._s_stringMgr.getString(this._modusI18nKey);
    }

    public String getYAxisLabel(DataScale yAxisDataScale) {
        if (null == yAxisDataScale) {
            return this._s_stringMgr.getString(this._axisLabelI18nKey);
        }
        String col = yAxisDataScale.getColumnDisplayDefinition().getTableName();
        col = null != col && 0 < col.trim().length() ? col + "." + yAxisDataScale.getColumnDisplayDefinition().getColumnName() : yAxisDataScale.getColumnDisplayDefinition().getColumnName();
        return this._s_stringMgr.getString(this._axisLabelI18nKey, col);
    }
}

