/*
 * Decompiled with CFR 0.152.
 */
package org.fife.rtext;

import java.awt.BasicStroke;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.GridLayout;
import java.awt.Stroke;
import java.awt.SystemColor;
import java.awt.Toolkit;
import java.awt.datatransfer.Clipboard;
import java.awt.datatransfer.StringSelection;
import java.awt.dnd.DropTargetListener;
import java.awt.event.ActionEvent;
import java.awt.event.ContainerListener;
import java.awt.event.MouseEvent;
import java.text.MessageFormat;
import java.util.ResourceBundle;
import java.util.TooManyListenersException;
import javax.swing.AbstractAction;
import javax.swing.JComponent;
import javax.swing.JMenuItem;
import javax.swing.JPanel;
import javax.swing.JPopupMenu;
import javax.swing.JTabbedPane;
import javax.swing.SwingUtilities;
import javax.swing.ToolTipManager;
import javax.swing.TransferHandler;
import javax.swing.UIManager;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import javax.swing.event.MouseInputAdapter;
import javax.swing.plaf.TabbedPaneUI;
import org.fife.rtext.AbstractMainView;
import org.fife.rtext.RText;
import org.fife.rtext.RTextEditorPane;
import org.fife.rtext.RTextPrefs;
import org.fife.rtext.TabbedPaneViewTransferHandler;
import org.fife.ui.DrawDnDIndicatorTabbedPane;
import org.fife.ui.rtextarea.RTextScrollPane;

class RTextTabbedPaneView
extends AbstractMainView
implements ChangeListener {
    private TabbedPane tabbedPane;
    private boolean inCloseCurrentDocument;
    private int rightClickIndex;
    private final TabbedPaneViewTransferHandler transferHandler = new TabbedPaneViewTransferHandler(this);
    private static final String POPUP_MSG = "org.fife.rtext.TabbedPaneViewPopupMenu";

    public RTextTabbedPaneView(RText owner, String[] filesToOpen, RTextPrefs properties) {
        this.setLayout(new GridLayout(1, 1));
        this.tabbedPane = new TabbedPane();
        this.tabbedPane.addChangeListener(this);
        this.add(this.tabbedPane);
        this.initialize(owner, filesToOpen, properties);
        this.tabbedPane.setTransferHandler((TransferHandler)((Object)this.transferHandler));
        try {
            this.tabbedPane.getDropTarget().addDropTargetListener((DropTargetListener)((Object)this.transferHandler));
        }
        catch (TooManyListenersException tmle) {
            owner.displayException(tmle);
        }
        TabDragListener tdl = new TabDragListener();
        this.tabbedPane.addMouseListener(tdl);
        this.tabbedPane.addMouseMotionListener(tdl);
        this.rightClickIndex = -1;
    }

    public void addChangeListener(ChangeListener listener) {
        this.tabbedPane.addChangeListener(listener);
    }

    public void addContainerListener(ContainerListener listener) {
        this.tabbedPane.addContainerListener(listener);
    }

    protected void addTextAreaImpl(String title, Component component, String fileFullPath) {
        JPanel temp = new JPanel(new BorderLayout());
        temp.add(component);
        RTextScrollPane sp = (RTextScrollPane)component;
        RTextEditorPane textArea = (RTextEditorPane)sp.getTextArea();
        temp.add((Component)this.createErrorStrip(textArea), "After");
        this.tabbedPane.addTab(title, this.getIconFor(sp), temp);
        int tabCount = this.getNumDocuments();
        for (int i = 0; i < tabCount - 1; ++i) {
            if (!this.getRTextEditorPaneAt(i).getFileFullPath().equals(fileFullPath)) continue;
            int count = 0;
            for (int j = i; j < tabCount; ++j) {
                RTextEditorPane pane = this.getRTextEditorPaneAt(j);
                if (!pane.getFileFullPath().equals(fileFullPath)) continue;
                String newTitle = title + " (" + ++count + ")";
                if (pane.isDirty()) {
                    newTitle = newTitle + "*";
                }
                try {
                    this.setDocumentDisplayNameAt(j, newTitle);
                    continue;
                }
                catch (Exception e) {
                    this.owner.displayException(e);
                }
            }
            break;
        }
        this.setSelectedIndex(tabCount - 1);
        if (this.getCurrentTextArea().isDirty()) {
            this.owner.setMessages(fileFullPath + "*", "Opened document '" + fileFullPath + "'");
        } else {
            this.owner.setMessages(fileFullPath, "Opened document '" + fileFullPath + "'");
        }
    }

    protected synchronized boolean closeCurrentDocumentImpl() {
        ResourceBundle msg = this.owner.getResourceBundle();
        int rc = this.promptToSaveBeforeClosingIfDirty();
        if (rc == 2) {
            return false;
        }
        this.inCloseCurrentDocument = true;
        RTextEditorPane oldTextArea = this.getCurrentTextArea();
        oldTextArea.removeCaretListener(this.owner);
        this.removeComponentAt(this.getSelectedIndex());
        if (this.getNumDocuments() > 0) {
            this.renumberDisplayNames();
        } else {
            this.addNewEmptyUntitledFile();
        }
        oldTextArea = this.getCurrentTextArea();
        this.setCurrentTextArea(this.getRTextEditorPaneAt(this.getSelectedIndex()));
        final RTextEditorPane currentTextArea = this.getCurrentTextArea();
        SwingUtilities.invokeLater(new Runnable(){

            public void run() {
                if (currentTextArea != null) {
                    currentTextArea.requestFocusInWindow();
                }
            }
        });
        currentTextArea.addCaretListener(this.owner);
        this.inCloseCurrentDocument = false;
        this.firePropertyChange("MainView.currentDocument", -1, this.getSelectedIndex());
        this.fireCurrentTextAreaEvent(0, oldTextArea, currentTextArea);
        this.updateStatusBar();
        if (currentTextArea.isDirty()) {
            this.owner.setMessages(currentTextArea.getFileFullPath() + "*", msg.getString("Ready"));
        } else {
            this.owner.setMessages(currentTextArea.getFileFullPath(), msg.getString("Ready"));
        }
        return true;
    }

    public String getDocumentDisplayNameAt(int index) {
        if (index >= 0 && index < this.tabbedPane.getTabCount()) {
            return this.tabbedPane.getTitleAt(index);
        }
        return null;
    }

    public int getDocumentSelectionPlacement() {
        return this.tabbedPane.getTabPlacement();
    }

    public int getNumDocuments() {
        return this.tabbedPane.getTabCount();
    }

    public RTextScrollPane getRTextScrollPaneAt(int index) {
        if (index < 0 || index >= this.getNumDocuments()) {
            return null;
        }
        JPanel temp = (JPanel)this.tabbedPane.getComponentAt(index);
        return (RTextScrollPane)temp.getComponent(0);
    }

    public Component getSelectedComponent() {
        return this.tabbedPane.getComponentAt(this.tabbedPane.getSelectedIndex());
    }

    public int getSelectedIndex() {
        return this.tabbedPane.getSelectedIndex();
    }

    public void refreshDisplayNames() {
        Color defaultForeground = UIManager.getColor("tabbedpane.foreground");
        Color modifiedColor = this.getModifiedDocumentDisplayNamesColor();
        int numDocuments = this.getNumDocuments();
        if (this.highlightModifiedDocumentDisplayNames()) {
            for (int i = 0; i < numDocuments; ++i) {
                if (this.getRTextEditorPaneAt(i).isDirty()) {
                    this.tabbedPane.setForegroundAt(i, modifiedColor);
                    continue;
                }
                this.tabbedPane.setForegroundAt(i, defaultForeground);
            }
        } else {
            for (int i = 0; i < numDocuments; ++i) {
                this.tabbedPane.setForegroundAt(i, defaultForeground);
            }
        }
    }

    public void removeChangeListener(ChangeListener listener) {
        this.tabbedPane.removeChangeListener(listener);
    }

    protected void removeComponentAt(int index) {
        if (index >= 0 && index < this.getNumDocuments()) {
            this.tabbedPane.removeTabAt(index);
        }
    }

    public void removeContainerListener(ContainerListener listener) {
        this.tabbedPane.removeContainerListener(listener);
    }

    public void setDocumentDisplayNameAt(int index, String displayName) {
        if (index >= 0 && index < this.getNumDocuments()) {
            this.tabbedPane.setTitleAt(index, displayName);
            if (displayName.charAt(displayName.length() - 1) == '*') {
                if (this.highlightModifiedDocumentDisplayNames()) {
                    this.tabbedPane.setForegroundAt(index, this.getModifiedDocumentDisplayNamesColor());
                } else {
                    this.tabbedPane.setForegroundAt(index, this.tabbedPane.getForeground());
                }
            } else {
                this.tabbedPane.setForegroundAt(index, this.tabbedPane.getForeground());
            }
        }
        this.tabbedPane.setIconAt(index, this.getIconFor(this.getRTextScrollPaneAt(index)));
    }

    public void setDocumentSelectionPlacement(int location) {
        if (location == 1 || location == 2 || location == 3 || location == 4) {
            this.tabbedPane.setTabPlacement(location);
        }
    }

    public void setSelectedIndex(int index) {
        if (index >= 0 && index < this.getNumDocuments()) {
            this.tabbedPane.setSelectedIndex(index);
            this.setCurrentTextArea(this.getRTextEditorPaneAt(index));
            this.updateStatusBar();
            this.getCurrentTextArea().requestFocusInWindow();
        }
    }

    public void stateChanged(ChangeEvent e) {
        if (this.inCloseCurrentDocument) {
            return;
        }
        RTextEditorPane oldTextArea = this.getCurrentTextArea();
        if (oldTextArea != null) {
            oldTextArea.removeCaretListener(this.owner);
        }
        this.setCurrentTextArea(this.getRTextEditorPaneAt(this.getSelectedIndex()));
        final RTextEditorPane currentTextArea = this.getCurrentTextArea();
        if (currentTextArea != null) {
            if (currentTextArea.isDirty()) {
                this.owner.setMessages(currentTextArea.getFileFullPath() + "*", null);
            } else {
                this.owner.setMessages(currentTextArea.getFileFullPath(), null);
            }
            this.updateStatusBar();
            SwingUtilities.invokeLater(new Runnable(){

                public void run() {
                    currentTextArea.requestFocusInWindow();
                }
            });
            currentTextArea.addCaretListener(this.owner);
            if (this.owner.getMainView() != null) {
                this.owner.caretUpdate(null);
            }
            this.firePropertyChange("MainView.currentDocument", -1, this.getSelectedIndex());
            this.fireCurrentTextAreaEvent(0, null, currentTextArea);
        }
    }

    private class TabDragListener
    extends MouseInputAdapter {
        private int tab;
        private JComponent draggedTab;
        MouseEvent firstMouseEvent;

        private TabDragListener() {
        }

        public void mouseDragged(MouseEvent e) {
            if (this.draggedTab == null) {
                return;
            }
            if (this.firstMouseEvent != null) {
                e.consume();
                int action = 2;
                int dx = Math.abs(e.getX() - this.firstMouseEvent.getX());
                int dy = Math.abs(e.getY() - this.firstMouseEvent.getY());
                if (dx > 5 || dy > 5) {
                    RTextTabbedPaneView.this.transferHandler.exportAsDrag(RTextTabbedPaneView.this.tabbedPane, this.firstMouseEvent, action);
                    this.firstMouseEvent = null;
                }
            }
        }

        public void mousePressed(MouseEvent e) {
            this.tab = RTextTabbedPaneView.this.tabbedPane.indexAtLocation(e.getX(), e.getY());
            if (this.tab > -1) {
                this.draggedTab = (JComponent)RTextTabbedPaneView.this.tabbedPane.getComponentAt(this.tab);
                this.firstMouseEvent = e;
                e.consume();
            }
        }

        public void mouseReleased(MouseEvent e) {
            this.draggedTab = null;
            this.firstMouseEvent = null;
        }
    }

    private class TabbedPaneCopyPathAction
    extends AbstractAction {
        public TabbedPaneCopyPathAction(String text) {
            this.putValue("Name", text);
        }

        public void actionPerformed(ActionEvent e) {
            if (RTextTabbedPaneView.this.rightClickIndex > -1) {
                RTextEditorPane textArea = RTextTabbedPaneView.this.getRTextEditorPaneAt(RTextTabbedPaneView.this.rightClickIndex);
                String path = textArea.getFileFullPath();
                Clipboard c = Toolkit.getDefaultToolkit().getSystemClipboard();
                c.setContents(new StringSelection(path), null);
            }
        }
    }

    private class TabbedPaneCloseOthersAction
    extends AbstractAction {
        public TabbedPaneCloseOthersAction(String text) {
            this.putValue("Name", text);
        }

        public void actionPerformed(ActionEvent e) {
            if (RTextTabbedPaneView.this.rightClickIndex > -1) {
                RTextTabbedPaneView.this.closeAllDocumentsExcept(RTextTabbedPaneView.this.rightClickIndex);
            }
        }
    }

    private class TabbedPaneCloseAction
    extends AbstractAction {
        private String template;

        public TabbedPaneCloseAction(String template) {
            this.template = template;
        }

        public void actionPerformed(ActionEvent e) {
            if (RTextTabbedPaneView.this.rightClickIndex > -1) {
                RTextTabbedPaneView.this.setSelectedIndex(RTextTabbedPaneView.this.rightClickIndex);
                RTextTabbedPaneView.this.closeCurrentDocument();
            }
        }

        public void setDocumentName(String name) {
            String text = MessageFormat.format(this.template, name);
            this.putValue("Name", text);
        }
    }

    class TabbedPane
    extends JTabbedPane
    implements DrawDnDIndicatorTabbedPane {
        private int x = -1;
        private int y = -1;
        private int width;
        private int height;
        private Stroke wideStroke;
        private JPopupMenu popup;
        private TabbedPaneCloseAction closeAction;

        public TabbedPane() {
            this.enableEvents(16L);
            ToolTipManager.sharedInstance().registerComponent(this);
        }

        public void clearDnDIndicatorRect() {
            this.y = -1;
            this.x = -1;
            this.repaint();
        }

        protected JPopupMenu getTabPopupMenu() {
            if (this.popup == null) {
                ResourceBundle msg = ResourceBundle.getBundle(RTextTabbedPaneView.POPUP_MSG);
                this.popup = new JPopupMenu();
                String title = msg.getString("Close");
                this.closeAction = new TabbedPaneCloseAction(title);
                JMenuItem item = new JMenuItem(this.closeAction);
                this.popup.add(item);
                title = msg.getString("CloseOthers");
                item = new JMenuItem(new TabbedPaneCloseOthersAction(title));
                this.popup.add(item);
                item = new JMenuItem(RTextTabbedPaneView.this.owner.getAction("closeAllAction"));
                item.setToolTipText(null);
                this.popup.add(item);
                this.popup.add(new JPopupMenu.Separator());
                title = msg.getString("CopyPathToClipboard");
                item = new JMenuItem(new TabbedPaneCopyPathAction(title));
                this.popup.add(item);
            }
            return this.popup;
        }

        public String getToolTipText(MouseEvent e) {
            int index;
            TabbedPaneUI ui = this.getUI();
            if (ui != null && (index = ui.tabForCoordinate(this, e.getX(), e.getY())) != -1) {
                return RTextTabbedPaneView.this.getRTextEditorPaneAt(index).getFileFullPath();
            }
            return super.getToolTipText(e);
        }

        public void paint(Graphics g) {
            super.paint(g);
            if (this.x != -1) {
                if (this.wideStroke == null) {
                    this.wideStroke = new BasicStroke(2.0f);
                }
                Graphics2D g2d = (Graphics2D)g;
                Stroke temp = g2d.getStroke();
                g2d.setStroke(this.wideStroke);
                g2d.setColor(SystemColor.controlDkShadow);
                g2d.drawRect(this.x, this.y, this.width, this.height);
                g2d.setStroke(temp);
            }
        }

        protected void processMouseEvent(MouseEvent e) {
            if (SwingUtilities.isRightMouseButton(e)) {
                int y;
                int x;
                int index;
                if (e.isPopupTrigger() && (index = this.indexAtLocation(x = e.getX(), y = e.getY())) != -1) {
                    RTextTabbedPaneView.this.rightClickIndex = index;
                    JPopupMenu popup = this.getTabPopupMenu();
                    String name = RTextTabbedPaneView.this.getDocumentDisplayNameAt(index);
                    this.closeAction.setDocumentName(name);
                    popup.show(this, x, y);
                }
            } else if (SwingUtilities.isMiddleMouseButton(e)) {
                int y;
                int x;
                int index;
                if (e.getID() == 500 && e.getClickCount() == 1 && !e.isPopupTrigger() && (index = this.indexAtLocation(x = e.getX(), y = e.getY())) != -1) {
                    RTextTabbedPaneView.this.setSelectedIndex(index);
                    RTextTabbedPaneView.this.closeCurrentDocument();
                }
            } else {
                super.processMouseEvent(e);
            }
        }

        public void setDnDIndicatorRect(int x, int y, int width, int height) {
            this.x = x;
            this.y = y;
            this.width = width;
            this.height = height;
            this.repaint();
        }

        public void updateUI() {
            super.updateUI();
            if (this.popup != null) {
                SwingUtilities.updateComponentTreeUI(this.popup);
            }
        }
    }
}

