/*
 * Decompiled with CFR 0.152.
 */
package org.apache.tomcat.util.buf;

import java.text.DateFormat;
import java.text.FieldPosition;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.Locale;
import java.util.TimeZone;
import org.apache.tomcat.util.buf.MessageBytes;
import org.apache.tomcat.util.res.StringManager;

public class DateTool {
    private static final Locale LOCALE_US = Locale.US;
    public static final TimeZone GMT_ZONE = TimeZone.getTimeZone("GMT");
    public static final String RFC1123_PATTERN = "EEE, dd MMM yyyy HH:mm:ss z";
    public static final String rfc1036Pattern = "EEEEEEEEE, dd-MMM-yy HH:mm:ss z";
    public static final String asctimePattern = "EEE MMM d HH:mm:ss yyyy";
    private static final String OLD_COOKIE_PATTERN = "EEE, dd-MMM-yyyy HH:mm:ss z";
    private static final ThreadLocal rfc1123Format = new ThreadLocal(){

        public Object initialValue() {
            SimpleDateFormat result = new SimpleDateFormat(DateTool.RFC1123_PATTERN, LOCALE_US);
            result.setTimeZone(GMT_ZONE);
            return result;
        }
    };
    private static final ThreadLocal oldCookieFormat = new ThreadLocal(){

        public Object initialValue() {
            SimpleDateFormat result = new SimpleDateFormat(DateTool.OLD_COOKIE_PATTERN, LOCALE_US);
            result.setTimeZone(GMT_ZONE);
            return result;
        }
    };
    private static final ThreadLocal rfc1036Format = new ThreadLocal(){

        public Object initialValue() {
            SimpleDateFormat result = new SimpleDateFormat(DateTool.rfc1036Pattern, LOCALE_US);
            result.setTimeZone(GMT_ZONE);
            return result;
        }
    };
    private static final ThreadLocal asctimeFormat = new ThreadLocal(){

        public Object initialValue() {
            SimpleDateFormat result = new SimpleDateFormat(DateTool.asctimePattern, LOCALE_US);
            result.setTimeZone(GMT_ZONE);
            return result;
        }
    };
    private static String rfc1123DS;
    private static long rfc1123Sec;
    private static StringManager sm;

    static long parseDate(MessageBytes value) {
        return DateTool.parseDate(value.toString());
    }

    public static String format1123(Date d) {
        String dstr = null;
        dstr = DateTool.format1123(d, (DateFormat)rfc1123Format.get());
        return dstr;
    }

    public static String format1123(Date d, DateFormat df) {
        long dt = d.getTime() / 1000L;
        if (rfc1123DS != null && dt == rfc1123Sec) {
            return rfc1123DS;
        }
        rfc1123DS = df.format(d);
        rfc1123Sec = dt;
        return rfc1123DS;
    }

    public static void formatOldCookie(Date d, StringBuffer sb, FieldPosition fp) {
        ((DateFormat)oldCookieFormat.get()).format(d, sb, fp);
    }

    public static String formatOldCookie(Date d) {
        String ocf = null;
        ocf = ((DateFormat)oldCookieFormat.get()).format(d);
        return ocf;
    }

    public static long parseDate(String dateString) {
        DateFormat[] format = new DateFormat[]{(DateFormat)rfc1123Format.get(), (DateFormat)rfc1036Format.get(), (DateFormat)asctimeFormat.get()};
        return DateTool.parseDate(dateString, format);
    }

    public static long parseDate(String dateString, DateFormat[] format) {
        Date date = null;
        for (int i = 0; i < format.length; ++i) {
            try {
                date = format[i].parse(dateString);
                return date.getTime();
            }
            catch (ParseException e) {
                continue;
            }
            catch (StringIndexOutOfBoundsException e) {
                // empty catch block
            }
        }
        String msg = sm.getString("httpDate.pe", dateString);
        throw new IllegalArgumentException(msg);
    }

    static {
        sm = StringManager.getManager("org.apache.tomcat.util.buf.res");
    }
}

