package org.cdavies.itunes.request;

import java.net.*;
import java.io.*;

import itunes.FieldPair;

public class Itunes45HangingUpdateRequest extends Request implements UpdateRequest {
	
	public Itunes45HangingUpdateRequest(String server, int port, int sessionId, int revNum) {
		
		super(server, port, "update?session-id="+sessionId+"&revision-number="+revNum+"&delta="+revNum);
		
	}
	
	public void constructQuery() {
		
		URL _url = null;
		
		try {
			
			_url = new URL("http://"+server+":"+port+"/"+requestString);
			URLConnection _urlc = _url.openConnection();
			
			_urlc.addRequestProperty("Host", server);
            _urlc.addRequestProperty("Client-DAAP-Version", "3.0");
			_urlc.setRequestProperty("User-Agent", "AppleRecords");
			_urlc.addRequestProperty("Client-DAAP-Access-Index", "2");
			_urlc.addRequestProperty("Client-DAAP-Validation", hash.generateHash("/"+requestString, 2, -1));
			_conn = _urlc;
			
		}
		catch (Exception e) {
			
			/* Should never happen */
			_conn = null;
			
		}
		
	}
	
	public void runQuery() throws NoServerPermissionException {
	
	}
	
	public void process() { /* NOOP is this request */ }
	
	public int getRevisionNumber() {
		
		return -1;
        
	}
	
	
	
}
