/*
 * Decompiled with CFR 0.152.
 */
package edu.umd.marbl.mhap.utils;

import edu.umd.marbl.mhap.utils.Pair;
import it.unimi.dsi.fastutil.objects.Object2ObjectOpenHashMap;
import java.io.BufferedInputStream;
import java.io.BufferedReader;
import java.io.FileInputStream;
import java.io.FileReader;
import java.io.IOException;
import java.io.InputStreamReader;
import java.text.DecimalFormat;
import java.text.NumberFormat;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Map;
import java.util.Random;
import org.apache.commons.compress.compressors.bzip2.BZip2CompressorInputStream;
import org.apache.commons.compress.compressors.gzip.GzipCompressorInputStream;

public final class Utils {
    public static final int BUFFER_BYTE_SIZE = 0x800000;
    public static final NumberFormat DECIMAL_FORMAT = new DecimalFormat("############.########");
    public static final int FASTA_LINE_LENGTH = 60;
    public static final int MBYTES = 0x100000;

    public static int checkForEnd(String line, int brackets) {
        if (line.startsWith("{")) {
            ++brackets;
        }
        if (line.startsWith("}")) {
            --brackets;
        }
        if (brackets == 0) {
            return -1;
        }
        return brackets;
    }

    public static final String convertToFasta(String supplied) {
        StringBuffer converted = new StringBuffer();
        int i = 0;
        String[] split = supplied.trim().split("\\s+");
        if (split.length > 1) {
            int size = 0;
            for (i = 0; i < split.length; ++i) {
                converted.append(split[i]);
                size += split[i].length();
                if (i == split.length - 1) continue;
                if (size >= 60) {
                    size = 0;
                    converted.append("\n");
                    continue;
                }
                converted.append(" ");
            }
        } else {
            i = 0;
            while (i + 60 < supplied.length()) {
                converted.append(supplied.substring(i, i + 60));
                converted.append("\n");
                i += 60;
            }
            converted.append(supplied.substring(i, supplied.length()));
        }
        return converted.toString();
    }

    public static final int countLetterInRead(String fasta, String letter) {
        return Utils.countLetterInRead(fasta, letter, false);
    }

    public static final int countLetterInRead(String fasta, String letter, Boolean caseSensitive) {
        String ungapped = Utils.getUngappedRead(fasta);
        int len = ungapped.length();
        if (len == 0) {
            return -1;
        }
        int increment = letter.length();
        int count = 0;
        for (int i = 0; i <= ungapped.length() - increment; i += increment) {
            if (letter.equals(ungapped.substring(i, i + increment)) && caseSensitive.booleanValue()) {
                ++count;
            }
            if (!letter.equalsIgnoreCase(ungapped.substring(i, i + increment)) || caseSensitive.booleanValue()) continue;
            ++count;
        }
        return count;
    }

    public static final int[] errorString(int[] s, double readError) {
        int[] snew = (int[])s.clone();
        Random generator = new Random();
        for (int iter = 0; iter < s.length; ++iter) {
            if (!(generator.nextDouble() < readError)) continue;
            while (snew[iter] == s[iter]) {
                snew[iter] = generator.nextInt(3);
            }
        }
        return snew;
    }

    public static final BufferedReader getFile(String fileName, String[] postfix) throws IOException {
        if (fileName.endsWith("bz2")) {
            BZip2CompressorInputStream bzIn = new BZip2CompressorInputStream(new BufferedInputStream(new FileInputStream(fileName), 0x800000));
            return new BufferedReader(new InputStreamReader(bzIn));
        }
        if (fileName.endsWith("gz")) {
            GzipCompressorInputStream bzIn = new GzipCompressorInputStream(new BufferedInputStream(new FileInputStream(fileName), 0x800000));
            return new BufferedReader(new InputStreamReader(bzIn));
        }
        if (postfix == null) {
            return new BufferedReader(new FileReader(fileName), 0x800000);
        }
        int i = 0;
        for (i = 0; i < postfix.length; ++i) {
            if (!fileName.endsWith(postfix[i])) continue;
            return new BufferedReader(new FileReader(fileName), 0x800000);
        }
        throw new IOException("Unknown file format of file " + fileName + ".");
    }

    public static final String getID(String line) {
        String[] ids = line.split(":");
        int commaPos = ids[1].indexOf(",");
        if (commaPos != -1) {
            return ids[1].substring(1, commaPos).trim();
        }
        return ids[1];
    }

    public static final double getLetterPercentInRead(String fasta, String letter) {
        int ungappedLen = Utils.getUngappedRead(fasta).length();
        int count = Utils.countLetterInRead(fasta, letter);
        return (double)count / (double)ungappedLen;
    }

    public static final int getOvlSize(int readA, int readB, int ahang, int bhang) {
        if (ahang <= 0 && bhang >= 0 || ahang >= 0 && bhang <= 0) {
            return -1;
        }
        if (ahang < 0) {
            return readA - Math.abs(bhang);
        }
        return readA - ahang;
    }

    public static final int getRangeOverlap(int startA, int endA, int startB, int endB) {
        int minA = Math.min(startA, endA);
        int minB = Math.min(startB, endB);
        int maxA = Math.max(startA, endA);
        int maxB = Math.max(startB, endB);
        int start = Math.max(minA, minB);
        int end = Math.min(maxA, maxB);
        return end - start + 1;
    }

    public static final String getUngappedRead(String fasta) {
        fasta = fasta.replaceAll("N", "");
        fasta = fasta.replaceAll("-", "");
        assert (fasta.length() >= 0);
        return fasta;
    }

    public static final String getValue(String line, String key) {
        if (line.startsWith(key)) {
            return line.split(":")[1];
        }
        return null;
    }

    public static final <H> double hashEfficiency(HashMap<Integer, ArrayList<H>> c) {
        double e = Utils.hashEnthropy(c);
        double log2inv = 1.0 / Math.log(2.0);
        double scaling = Math.log(c.size()) * log2inv;
        return e / scaling;
    }

    public static final <H> double hashEnthropy(HashMap<Integer, ArrayList<H>> c) {
        double sum = 0.0;
        double log2inv = 1.0 / Math.log(2.0);
        double[] p = new double[c.size()];
        int size = 0;
        int count = 0;
        for (ArrayList<H> elem : c.values()) {
            size += elem.size();
            p[count++] = elem.size();
        }
        for (int iter = 0; iter < p.length; ++iter) {
            double val = p[iter] / (double)size;
            sum -= val * Math.log(val) * log2inv;
        }
        return sum;
    }

    public static final boolean isAContainedInB(int startA, int endA, int startB, int endB) {
        int minA = Math.min(startA, endA);
        int minB = Math.min(startB, endB);
        int maxA = Math.max(startA, endA);
        int maxB = Math.max(startB, endB);
        return minB < minA && maxB > maxA;
    }

    public static final Pair<Double, Double> linearRegression(int[] a, int[] b, int size) {
        int xy = 0;
        int x = 0;
        int y = 0;
        int x2 = 0;
        for (int iter = 0; iter < size; ++iter) {
            xy += a[iter] * b[iter];
            x += a[iter];
            y += b[iter];
            x2 += a[iter] * a[iter];
        }
        double Ninv = 1.0 / (double)size;
        double beta = ((double)xy - Ninv * (double)(x * y)) / ((double)x2 - Ninv * (double)(x * x));
        double alpha = Ninv * ((double)y - beta * (double)x);
        return new Pair<Double, Double>(alpha, beta);
    }

    public static final double mean(double[] a, int size) {
        double x = 0.0;
        for (int iter = 0; iter < size; ++iter) {
            x += a[iter];
        }
        return x / (double)size;
    }

    public static final double mean(int[] a, int size) {
        int x = 0;
        for (int iter = 0; iter < size; ++iter) {
            x += a[iter];
        }
        return (double)x / (double)size;
    }

    public static final double pearsonCorr(int[] a, int[] b, int size) {
        if (size < 2) {
            return 0.0;
        }
        double meana = Utils.mean(a, size);
        double meanb = Utils.mean(b, size);
        double stda = Utils.std(a, size, meana);
        double stdb = Utils.std(b, size, meanb);
        double r = 0.0;
        for (int iter = 0; iter < size; ++iter) {
            r += ((double)a[iter] - meana) * ((double)b[iter] - meanb) / (stda * stdb);
        }
        return r / (double)(size - 1);
    }

    public static final int quickSelect(int[] array, int k, int length) {
        if (array == null || length <= k) {
            return Integer.MAX_VALUE;
        }
        int from = 0;
        int to = length - 1;
        while (from < to) {
            int r = from;
            int w = to;
            int mid = array[(r + w) / 2];
            while (r < w) {
                if (array[r] >= mid) {
                    int tmp = array[w];
                    array[w] = array[r];
                    array[r] = tmp;
                    --w;
                    continue;
                }
                ++r;
            }
            if (array[r] > mid) {
                --r;
            }
            if (k <= r) {
                to = r;
                continue;
            }
            from = r + 1;
        }
        return array[k];
    }

    public static final String rc(String supplied) {
        StringBuilder st = new StringBuilder();
        for (int i = supplied.length() - 1; i >= 0; --i) {
            char theChar = supplied.charAt(i);
            String c = Translate.getTranslation(Character.toString(theChar).toUpperCase());
            st.append(c);
        }
        return st.toString();
    }

    public static final double std(double[] a, int size, double mean) {
        double x = 0.0;
        for (int iter = 0; iter < size; ++iter) {
            double val = a[iter] - mean;
            x += val * val;
        }
        return Math.sqrt(x / (double)(size - 1));
    }

    public static final double std(int[] a, int size, double mean) {
        double x = 0.0;
        for (int iter = 0; iter < size; ++iter) {
            double val = (double)a[iter] - mean;
            x += val * val;
        }
        return Math.sqrt(x / (double)(size - 1));
    }

    public static final String toProtein(String genome, boolean isReversed, int frame) {
        StringBuilder result = new StringBuilder();
        if (isReversed) {
            genome = Utils.rc(genome);
        }
        genome = genome.replaceAll("-", "");
        for (int i = frame; i < genome.length() - 3; i += 3) {
            String codon = genome.substring(i, i + 3);
            String protein = ToProtein.valueOf(codon).getProtein();
            result.append(protein);
        }
        return result.toString();
    }

    public static String toString(double[][] A) {
        StringBuilder s = new StringBuilder();
        s.append("[");
        for (double[] a : A) {
            if (a != null) {
                for (int iter = 0; iter < a.length - 1; ++iter) {
                    s.append("" + a[iter] + ",");
                }
                if (a.length > 0) {
                    s.append("" + a[a.length - 1]);
                }
            }
            s.append("\n");
        }
        s.append("]");
        return new String(s);
    }

    public static String toString(float[][] A) {
        StringBuilder s = new StringBuilder();
        s.append("[");
        for (float[] a : A) {
            if (a != null) {
                for (int iter = 0; iter < a.length - 1; ++iter) {
                    s.append("" + a[iter] + ",");
                }
                if (a.length > 0) {
                    s.append("" + a[a.length - 1]);
                }
            }
            s.append("\n");
        }
        s.append("]");
        return new String(s);
    }

    public static String toString(long[][] A) {
        StringBuilder s = new StringBuilder();
        s.append("[");
        for (long[] a : A) {
            if (a != null) {
                for (int iter = 0; iter < a.length - 1; ++iter) {
                    s.append("" + a[iter] + ",");
                }
                if (a.length > 0) {
                    s.append("" + a[a.length - 1]);
                }
            }
            s.append("\n");
        }
        s.append("]");
        return new String(s);
    }

    public static class Translate {
        private static Map<String, String> lookup = new Object2ObjectOpenHashMap<String, String>();

        public static String getTranslation(String c) {
            String value = lookup.get(c);
            if (value == null) {
                return c;
            }
            return value;
        }

        static {
            lookup.put("A", "T");
            lookup.put("B", "V");
            lookup.put("C", "G");
            lookup.put("D", "H");
            lookup.put("G", "C");
            lookup.put("H", "D");
            lookup.put("K", "M");
            lookup.put("M", "K");
            lookup.put("N", "N");
            lookup.put("R", "Y");
            lookup.put("S", "S");
            lookup.put("T", "A");
            lookup.put("V", "B");
            lookup.put("W", "W");
            lookup.put("Y", "R");
        }
    }

    public static enum ToProtein {
        AAA("K"),
        AAC("N"),
        AAG("K"),
        AAT("N"),
        ACA("T"),
        ACC("T"),
        ACG("T"),
        ACT("T"),
        AGA("R"),
        AGC("S"),
        AGG("R"),
        AGT("S"),
        ATA("I"),
        ATC("I"),
        ATG("M"),
        ATT("I"),
        CAA("Q"),
        CAC("H"),
        CAG("Q"),
        CAT("H"),
        CCA("P"),
        CCC("P"),
        CCG("P"),
        CCT("P"),
        CGA("R"),
        CGC("R"),
        CGG("R"),
        CGT("R"),
        CTA("L"),
        CTC("L"),
        CTG("L"),
        CTT("L"),
        GAA("E"),
        GAC("D"),
        GAG("E"),
        GAT("D"),
        GCA("A"),
        GCC("A"),
        GCG("A"),
        GCT("A"),
        GGA("G"),
        GGC("G"),
        GGG("G"),
        GGT("G"),
        GTA("V"),
        GTC("V"),
        GTG("V"),
        GTT("V"),
        TAA("X"),
        TAC("Y"),
        TAG("X"),
        TAT("Y"),
        TCA("S"),
        TCC("S"),
        TCG("S"),
        TCT("S"),
        TGA("X"),
        TGC("C"),
        TGG("W"),
        TGT("C"),
        TTA("L"),
        TTC("F"),
        TTG("L"),
        TTT("F");

        private String other;

        private ToProtein(String other) {
            this.other = other;
        }

        public String getProtein() {
            return this.other;
        }
    }
}

