/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.xpack.sql.expression.literal;

import java.io.IOException;
import java.time.Period;
import org.elasticsearch.common.io.stream.StreamInput;
import org.elasticsearch.common.io.stream.StreamOutput;
import org.elasticsearch.xpack.sql.expression.literal.Interval;
import org.elasticsearch.xpack.sql.type.DataType;
import org.elasticsearch.xpack.sql.type.DataTypeConversion;
import org.elasticsearch.xpack.sql.type.DataTypes;

public class IntervalYearMonth
extends Interval<Period> {
    public static final String NAME = "iym";

    private static Period period(StreamInput in) throws IOException {
        return Period.of(in.readVInt(), in.readVInt(), in.readVInt());
    }

    public IntervalYearMonth(Period interval, DataType intervalType) {
        super(interval, intervalType);
    }

    IntervalYearMonth(StreamInput in) throws IOException {
        super(IntervalYearMonth.period(in), (DataType)in.readEnum(DataType.class));
    }

    public void writeTo(StreamOutput out) throws IOException {
        Period p = (Period)this.interval();
        out.writeVInt(p.getYears());
        out.writeVInt(p.getMonths());
        out.writeVInt(p.getDays());
        out.writeEnum((Enum)this.dataType());
    }

    public String getWriteableName() {
        return NAME;
    }

    public IntervalYearMonth add(Interval<Period> interval) {
        return new IntervalYearMonth(((Period)this.interval()).plus(interval.interval()).normalized(), DataTypes.compatibleInterval(this.dataType(), interval.dataType()));
    }

    public IntervalYearMonth sub(Interval<Period> interval) {
        return new IntervalYearMonth(((Period)this.interval()).minus(interval.interval()).normalized(), DataTypes.compatibleInterval(this.dataType(), interval.dataType()));
    }

    @Override
    public Interval<Period> mul(long mul) {
        int i = DataTypeConversion.safeToInt(mul);
        return new IntervalYearMonth(((Period)this.interval()).multipliedBy(i), this.dataType());
    }
}

