/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.action.explain;

import java.io.IOException;
import java.util.Set;
import org.apache.lucene.index.Term;
import org.apache.lucene.search.Explanation;
import org.elasticsearch.ElasticsearchException;
import org.elasticsearch.action.ActionListener;
import org.elasticsearch.action.RoutingMissingException;
import org.elasticsearch.action.explain.ExplainRequest;
import org.elasticsearch.action.explain.ExplainResponse;
import org.elasticsearch.action.support.ActionFilters;
import org.elasticsearch.action.support.single.shard.TransportSingleShardAction;
import org.elasticsearch.cluster.ClusterState;
import org.elasticsearch.cluster.metadata.IndexNameExpressionResolver;
import org.elasticsearch.cluster.routing.ShardIterator;
import org.elasticsearch.cluster.service.ClusterService;
import org.elasticsearch.common.inject.Inject;
import org.elasticsearch.common.lease.Releasables;
import org.elasticsearch.common.settings.Settings;
import org.elasticsearch.index.IndexService;
import org.elasticsearch.index.engine.Engine;
import org.elasticsearch.index.get.GetResult;
import org.elasticsearch.index.shard.ShardId;
import org.elasticsearch.search.DefaultSearchContext;
import org.elasticsearch.search.SearchService;
import org.elasticsearch.search.internal.AliasFilter;
import org.elasticsearch.search.internal.SearchContext;
import org.elasticsearch.search.internal.ShardSearchLocalRequest;
import org.elasticsearch.search.rescore.RescoreContext;
import org.elasticsearch.search.rescore.Rescorer;
import org.elasticsearch.threadpool.ThreadPool;
import org.elasticsearch.transport.TransportService;

public class TransportExplainAction
extends TransportSingleShardAction<ExplainRequest, ExplainResponse> {
    private final SearchService searchService;

    @Inject
    public TransportExplainAction(Settings settings, ThreadPool threadPool, ClusterService clusterService, TransportService transportService, SearchService searchService, ActionFilters actionFilters, IndexNameExpressionResolver indexNameExpressionResolver) {
        super(settings, "indices:data/read/explain", threadPool, clusterService, transportService, actionFilters, indexNameExpressionResolver, ExplainRequest::new, "get");
        this.searchService = searchService;
    }

    @Override
    protected void doExecute(ExplainRequest request, ActionListener<ExplainResponse> listener) {
        request.nowInMillis = System.currentTimeMillis();
        super.doExecute(request, listener);
    }

    @Override
    protected boolean resolveIndex(ExplainRequest request) {
        return true;
    }

    @Override
    protected void resolveRequest(ClusterState state, TransportSingleShardAction.InternalRequest request) {
        Set<String> indicesAndAliases = this.indexNameExpressionResolver.resolveExpressions(state, ((ExplainRequest)request.request()).index());
        AliasFilter aliasFilter = this.searchService.buildAliasFilter(state, request.concreteIndex(), indicesAndAliases);
        ((ExplainRequest)request.request()).filteringAlias(aliasFilter);
        if (((ExplainRequest)request.request()).routing() == null && state.getMetaData().routingRequired(request.concreteIndex(), ((ExplainRequest)request.request()).type())) {
            throw new RoutingMissingException(request.concreteIndex(), ((ExplainRequest)request.request()).type(), ((ExplainRequest)request.request()).id());
        }
    }

    @Override
    protected ExplainResponse shardOperation(ExplainRequest request, ShardId shardId) throws IOException {
        ExplainResponse explainResponse;
        Explanation explanation;
        Engine.GetResult result;
        DefaultSearchContext context;
        block10: {
            block9: {
                Term uidTerm;
                block8: {
                    ShardSearchLocalRequest shardSearchLocalRequest = new ShardSearchLocalRequest(shardId, new String[]{request.type()}, request.nowInMillis, request.filteringAlias());
                    context = this.searchService.createSearchContext(shardSearchLocalRequest, SearchService.NO_TIMEOUT);
                    result = null;
                    uidTerm = ((SearchContext)context).mapperService().createUidTerm(request.type(), request.id());
                    if (uidTerm != null) break block8;
                    ExplainResponse explainResponse2 = new ExplainResponse(shardId.getIndexName(), request.type(), request.id(), false);
                    Releasables.close(result, context);
                    return explainResponse2;
                }
                result = ((SearchContext)context).indexShard().get(new Engine.Get(false, false, request.type(), request.id(), uidTerm));
                if (result.exists()) break block9;
                ExplainResponse explainResponse3 = new ExplainResponse(shardId.getIndexName(), request.type(), request.id(), false);
                Releasables.close(result, context);
                return explainResponse3;
            }
            ((SearchContext)context).parsedQuery(((SearchContext)context).getQueryShardContext().toQuery(request.query()));
            ((SearchContext)context).preProcess(true);
            int topLevelDocId = result.docIdAndVersion().docId + result.docIdAndVersion().docBase;
            explanation = ((SearchContext)context).searcher().explain(((SearchContext)context).query(), topLevelDocId);
            for (RescoreContext ctx : ((SearchContext)context).rescore()) {
                Rescorer rescorer = ctx.rescorer();
                explanation = rescorer.explain(topLevelDocId, ((SearchContext)context).searcher(), ctx, explanation);
            }
            if (request.storedFields() == null && (request.fetchSourceContext() == null || !request.fetchSourceContext().fetchSource())) break block10;
            GetResult getResult = ((SearchContext)context).indexShard().getService().get(result, request.id(), request.type(), request.storedFields(), request.fetchSourceContext());
            ExplainResponse explainResponse4 = new ExplainResponse(shardId.getIndexName(), request.type(), request.id(), true, explanation, getResult);
            Releasables.close(result, context);
            return explainResponse4;
        }
        try {
            explainResponse = new ExplainResponse(shardId.getIndexName(), request.type(), request.id(), true, explanation);
        }
        catch (IOException e) {
            try {
                throw new ElasticsearchException("Could not explain", (Throwable)e, new Object[0]);
            }
            catch (Throwable throwable) {
                Releasables.close(result, context);
                throw throwable;
            }
        }
        Releasables.close(result, context);
        return explainResponse;
    }

    @Override
    protected ExplainResponse newResponse() {
        return new ExplainResponse();
    }

    @Override
    protected ShardIterator shards(ClusterState state, TransportSingleShardAction.InternalRequest request) {
        return this.clusterService.operationRouting().getShards(this.clusterService.state(), request.concreteIndex(), ((ExplainRequest)request.request()).id(), ((ExplainRequest)request.request()).routing(), ((ExplainRequest)request.request()).preference());
    }

    @Override
    protected String getExecutor(ExplainRequest request, ShardId shardId) {
        IndexService indexService = this.searchService.getIndicesService().indexServiceSafe(shardId.getIndex());
        return indexService.getIndexSettings().isSearchThrottled() ? "search_throttled" : super.getExecutor(request, shardId);
    }
}

