/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.xpack.ml.job.process.autodetect;

import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.nio.file.Path;
import java.util.Iterator;
import java.util.List;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.elasticsearch.common.unit.TimeValue;
import org.elasticsearch.xpack.core.ml.calendars.ScheduledEvent;
import org.elasticsearch.xpack.core.ml.job.config.DetectionRule;
import org.elasticsearch.xpack.core.ml.job.config.MlFilter;
import org.elasticsearch.xpack.core.ml.job.config.ModelPlotConfig;
import org.elasticsearch.xpack.core.ml.job.process.autodetect.state.ModelSnapshot;
import org.elasticsearch.xpack.ml.job.persistence.StateStreamer;
import org.elasticsearch.xpack.ml.job.process.autodetect.AutodetectProcess;
import org.elasticsearch.xpack.ml.job.process.autodetect.output.AutodetectResultsParser;
import org.elasticsearch.xpack.ml.job.process.autodetect.params.DataLoadParams;
import org.elasticsearch.xpack.ml.job.process.autodetect.params.FlushJobParams;
import org.elasticsearch.xpack.ml.job.process.autodetect.params.ForecastParams;
import org.elasticsearch.xpack.ml.job.process.autodetect.writer.AutodetectControlMsgWriter;
import org.elasticsearch.xpack.ml.job.results.AutodetectResult;
import org.elasticsearch.xpack.ml.process.AbstractNativeProcess;

class NativeAutodetectProcess
extends AbstractNativeProcess
implements AutodetectProcess {
    private static final Logger LOGGER = LogManager.getLogger(NativeAutodetectProcess.class);
    private static final String NAME = "autodetect";
    private final AutodetectResultsParser resultsParser;

    NativeAutodetectProcess(String jobId, InputStream logStream, OutputStream processInStream, InputStream processOutStream, OutputStream processRestoreStream, int numberOfFields, List<Path> filesToDelete, AutodetectResultsParser resultsParser, Runnable onProcessCrash) {
        super(jobId, logStream, processInStream, processOutStream, processRestoreStream, numberOfFields, filesToDelete, onProcessCrash);
        this.resultsParser = resultsParser;
    }

    @Override
    public String getName() {
        return NAME;
    }

    @Override
    public void restoreState(StateStreamer stateStreamer, ModelSnapshot modelSnapshot) {
        block9: {
            if (modelSnapshot != null) {
                try (OutputStream r = this.processRestoreStream();){
                    stateStreamer.restoreStateToStream(this.jobId(), modelSnapshot, r);
                }
                catch (Exception e) {
                    if (this.isProcessKilled()) break block9;
                    LOGGER.error("Error restoring model state for job " + this.jobId(), (Throwable)e);
                }
            }
        }
        this.setReady();
    }

    @Override
    public void writeResetBucketsControlMessage(DataLoadParams params) throws IOException {
        this.newMessageWriter().writeResetBucketsMessage(params);
    }

    @Override
    public void writeUpdateModelPlotMessage(ModelPlotConfig modelPlotConfig) throws IOException {
        this.newMessageWriter().writeUpdateModelPlotMessage(modelPlotConfig);
    }

    @Override
    public void writeUpdateDetectorRulesMessage(int detectorIndex, List<DetectionRule> rules) throws IOException {
        this.newMessageWriter().writeUpdateDetectorRulesMessage(detectorIndex, rules);
    }

    @Override
    public void writeUpdateFiltersMessage(List<MlFilter> filters) throws IOException {
        this.newMessageWriter().writeUpdateFiltersMessage(filters);
    }

    @Override
    public void writeUpdateScheduledEventsMessage(List<ScheduledEvent> events, TimeValue bucketSpan) throws IOException {
        this.newMessageWriter().writeUpdateScheduledEventsMessage(events, bucketSpan);
    }

    @Override
    public String flushJob(FlushJobParams params) throws IOException {
        AutodetectControlMsgWriter writer = this.newMessageWriter();
        writer.writeFlushControlMessage(params);
        return writer.writeFlushMessage();
    }

    @Override
    public void forecastJob(ForecastParams params) throws IOException {
        this.newMessageWriter().writeForecastMessage(params);
    }

    @Override
    public void persistState() throws IOException {
        this.newMessageWriter().writeStartBackgroundPersistMessage();
    }

    @Override
    public Iterator<AutodetectResult> readAutodetectResults() {
        return this.resultsParser.parseResults(this.processOutStream());
    }

    private AutodetectControlMsgWriter newMessageWriter() {
        return new AutodetectControlMsgWriter(this.recordWriter(), this.numberOfFields());
    }
}

