/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.xpack.rollup.job;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.TreeMap;
import java.util.stream.Collectors;
import org.apache.log4j.Logger;
import org.elasticsearch.ElasticsearchException;
import org.elasticsearch.action.index.IndexRequest;
import org.elasticsearch.search.aggregations.Aggregation;
import org.elasticsearch.search.aggregations.bucket.composite.CompositeAggregation;
import org.elasticsearch.search.aggregations.metrics.InternalNumericMetricsAggregation;
import org.elasticsearch.xpack.core.rollup.RollupField;
import org.elasticsearch.xpack.core.rollup.job.GroupConfig;
import org.elasticsearch.xpack.core.rollup.job.RollupIndexerJobStats;
import org.elasticsearch.xpack.rollup.job.RollupIDGenerator;

class IndexerUtils {
    private static final Logger logger = Logger.getLogger((String)IndexerUtils.class.getName());

    IndexerUtils() {
    }

    static List<IndexRequest> processBuckets(CompositeAggregation agg, String rollupIndex, RollupIndexerJobStats stats, GroupConfig groupConfig, String jobId, boolean isUpgradedDocID) {
        logger.debug((Object)("Buckets: [" + agg.getBuckets().size() + "][" + jobId + "]"));
        return agg.getBuckets().stream().map(b -> {
            stats.incrementNumDocuments(b.getDocCount());
            TreeMap<String, Object> keys = new TreeMap<String, Object>(b.getKey());
            List metrics = b.getAggregations().asList();
            RollupIDGenerator idGenerator = isUpgradedDocID ? new RollupIDGenerator.Murmur3(jobId) : new RollupIDGenerator.CRC();
            HashMap<String, Object> doc = new HashMap<String, Object>(keys.size() + metrics.size());
            IndexerUtils.processKeys(keys, doc, b.getDocCount(), groupConfig, idGenerator);
            idGenerator.add(jobId);
            IndexerUtils.processMetrics(metrics, doc);
            doc.put("_rollup.version", isUpgradedDocID ? 2 : 1);
            doc.put("_rollup." + RollupField.ID.getPreferredName(), jobId);
            IndexRequest request = new IndexRequest(rollupIndex, "_doc", idGenerator.getID());
            request.source(doc);
            return request;
        }).collect(Collectors.toList());
    }

    private static void processKeys(Map<String, Object> keys, Map<String, Object> doc, long count, GroupConfig groupConfig, RollupIDGenerator idGenerator) {
        keys.forEach((k, v) -> {
            doc.put(k + "." + "_count", count);
            if (k.endsWith(".date_histogram")) {
                assert (v != null);
                doc.put(k + "." + "timestamp", v);
                doc.put(k + "." + "interval", groupConfig.getDateHistogram().getInterval());
                doc.put(k + "." + "time_zone", groupConfig.getDateHistogram().getTimeZone());
                idGenerator.add((Long)v);
                return;
            } else if (k.endsWith(".histogram")) {
                doc.put(k + "." + "value", v);
                doc.put(k + "." + "interval", groupConfig.getHistogram().getInterval());
                if (v == null) {
                    idGenerator.addNull();
                    return;
                } else {
                    idGenerator.add((Double)v);
                }
                return;
            } else {
                if (!k.endsWith(".terms")) throw new ElasticsearchException("Could not identify key in agg [" + k + "]", new Object[0]);
                doc.put(k + "." + "value", v);
                if (v == null) {
                    idGenerator.addNull();
                    return;
                } else if (v instanceof String) {
                    idGenerator.add((String)v);
                    return;
                } else if (v instanceof Long) {
                    idGenerator.add((Long)v);
                    return;
                } else {
                    if (!(v instanceof Double)) throw new RuntimeException("Encountered value of type [" + v.getClass() + "], which was unable to be processed.");
                    idGenerator.add((Double)v);
                }
            }
        });
    }

    private static void processMetrics(List<Aggregation> metrics, Map<String, Object> doc) {
        ArrayList emptyCounts = new ArrayList();
        metrics.forEach(m -> {
            if (m instanceof InternalNumericMetricsAggregation.SingleValue) {
                Double value = ((InternalNumericMetricsAggregation.SingleValue)m).value();
                if (!value.isInfinite()) {
                    if (m.getName().endsWith("_count") && value == 0.0) {
                        emptyCounts.add(m.getName());
                    } else {
                        doc.put(m.getName(), value);
                    }
                }
            } else {
                throw new ElasticsearchException("Aggregation [" + m.getName() + "] is of non-supported type [" + m.getType() + "]", new Object[0]);
            }
        });
        emptyCounts.forEach(m -> doc.remove(m.replace("_count", "value")));
    }
}

