/*
 * Decompiled with CFR 0.152.
 */
package org.glassfish.jersey.server.internal.inject;

import javax.inject.Inject;
import javax.inject.Singleton;
import javax.ws.rs.BadRequestException;
import javax.ws.rs.container.ContainerRequestContext;
import javax.ws.rs.core.Request;
import javax.ws.rs.core.Response;
import org.glassfish.hk2.api.Factory;
import org.glassfish.hk2.api.ServiceLocator;
import org.glassfish.jersey.server.ContainerRequest;
import org.glassfish.jersey.server.internal.LocalizationMessages;
import org.glassfish.jersey.server.internal.inject.AbstractContainerRequestValueFactory;
import org.glassfish.jersey.server.internal.inject.AbstractValueFactoryProvider;
import org.glassfish.jersey.server.internal.inject.MultivaluedParameterExtractorProvider;
import org.glassfish.jersey.server.model.Parameter;

@Singleton
class EntityParamValueFactoryProvider
extends AbstractValueFactoryProvider {
    @Inject
    EntityParamValueFactoryProvider(MultivaluedParameterExtractorProvider mpep, ServiceLocator injector) {
        super(mpep, injector, Parameter.Source.ENTITY);
    }

    @Override
    protected Factory<?> createValueFactory(Parameter parameter) {
        return new EntityValueFactory(parameter);
    }

    private static class EntityValueFactory
    extends AbstractContainerRequestValueFactory<Object> {
        private final Parameter parameter;

        public EntityValueFactory(Parameter parameter) {
            this.parameter = parameter;
        }

        public Object provide() {
            ContainerRequest value;
            ContainerRequest requestContext = this.getContainerRequest();
            Class<?> rawType = this.parameter.getRawType();
            if ((Request.class.isAssignableFrom(rawType) || ContainerRequestContext.class.isAssignableFrom(rawType)) && rawType.isInstance((Object)requestContext)) {
                value = requestContext;
            } else {
                value = requestContext.readEntity(rawType, this.parameter.getType(), this.parameter.getAnnotations());
                if (rawType.isPrimitive() && value == null) {
                    throw new BadRequestException(Response.status((Response.Status)Response.Status.BAD_REQUEST).entity((Object)LocalizationMessages.ERROR_PRIMITIVE_TYPE_NULL()).build());
                }
            }
            return value;
        }
    }
}

