/*
 * Decompiled with CFR 0.152.
 */
package org.apache.kafka.streams.kstream;

import java.util.HashMap;
import java.util.Map;
import org.apache.kafka.streams.kstream.Windows;
import org.apache.kafka.streams.kstream.internals.UnlimitedWindow;

public final class UnlimitedWindows
extends Windows<UnlimitedWindow> {
    private static final long DEFAULT_START_TIMESTAMP_MS = 0L;
    public final long startMs;

    private UnlimitedWindows(long startMs) {
        this.startMs = startMs;
    }

    public static UnlimitedWindows of() {
        return new UnlimitedWindows(0L);
    }

    public UnlimitedWindows startOn(long startMs) throws IllegalArgumentException {
        if (startMs < 0L) {
            throw new IllegalArgumentException("Window start time (startMs) cannot be negative.");
        }
        return new UnlimitedWindows(startMs);
    }

    @Override
    public Map<Long, UnlimitedWindow> windowsFor(long timestamp) {
        HashMap<Long, UnlimitedWindow> windows = new HashMap<Long, UnlimitedWindow>();
        if (timestamp >= this.startMs) {
            windows.put(this.startMs, new UnlimitedWindow(this.startMs));
        }
        return windows;
    }

    @Override
    public long size() {
        return Long.MAX_VALUE;
    }

    public UnlimitedWindows until(long durationMs) {
        throw new IllegalArgumentException("Window retention time (durationMs) cannot be set for UnlimitedWindows.");
    }

    @Override
    public long maintainMs() {
        return Long.MAX_VALUE;
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof UnlimitedWindows)) {
            return false;
        }
        UnlimitedWindows other = (UnlimitedWindows)o;
        return this.startMs == other.startMs;
    }

    public int hashCode() {
        return (int)(this.startMs ^ this.startMs >>> 32);
    }
}

