/*
 * Decompiled with CFR 0.152.
 */
package kafka.log;

import com.typesafe.scalalogging.Logger;
import java.io.Serializable;
import kafka.log.Log;
import kafka.log.LogSegment;
import kafka.utils.Logging;
import org.apache.kafka.common.TopicPartition;
import scala.Function0;
import scala.Function1;
import scala.None$;
import scala.Option;
import scala.Option$;
import scala.Predef$;
import scala.StringContext;
import scala.Tuple2;
import scala.collection.Iterable;
import scala.collection.Seq;
import scala.collection.Seq$;
import scala.collection.TraversableOnce;
import scala.collection.immutable.Map;
import scala.math.Ordering;
import scala.math.package$;
import scala.runtime.BoxesRunTime;
import scala.runtime.java8.JFunction0;

public final class LogCleanerManager$
implements Logging {
    public static LogCleanerManager$ MODULE$;
    private Logger logger;
    private String logIdent;
    private volatile boolean bitmap$0;

    static {
        new LogCleanerManager$();
    }

    @Override
    public String loggerName() {
        return Logging.loggerName$(this);
    }

    @Override
    public String msgWithLogIdent(String msg) {
        return Logging.msgWithLogIdent$(this, msg);
    }

    @Override
    public void trace(Function0<String> msg) {
        Logging.trace$(this, msg);
    }

    @Override
    public void trace(Function0<String> msg, Function0<Throwable> e) {
        Logging.trace$(this, msg, e);
    }

    @Override
    public boolean isDebugEnabled() {
        return Logging.isDebugEnabled$(this);
    }

    @Override
    public boolean isTraceEnabled() {
        return Logging.isTraceEnabled$(this);
    }

    @Override
    public void debug(Function0<String> msg) {
        Logging.debug$(this, msg);
    }

    @Override
    public void debug(Function0<String> msg, Function0<Throwable> e) {
        Logging.debug$(this, msg, e);
    }

    @Override
    public void info(Function0<String> msg) {
        Logging.info$(this, msg);
    }

    @Override
    public void info(Function0<String> msg, Function0<Throwable> e) {
        Logging.info$(this, msg, e);
    }

    @Override
    public void warn(Function0<String> msg) {
        Logging.warn$(this, msg);
    }

    @Override
    public void warn(Function0<String> msg, Function0<Throwable> e) {
        Logging.warn$(this, msg, e);
    }

    @Override
    public void error(Function0<String> msg) {
        Logging.error$(this, msg);
    }

    @Override
    public void error(Function0<String> msg, Function0<Throwable> e) {
        Logging.error$(this, msg, e);
    }

    @Override
    public void fatal(Function0<String> msg) {
        Logging.fatal$(this, msg);
    }

    @Override
    public void fatal(Function0<String> msg, Function0<Throwable> e) {
        Logging.fatal$(this, msg, e);
    }

    private Logger logger$lzycompute() {
        LogCleanerManager$ logCleanerManager$ = this;
        synchronized (logCleanerManager$) {
            if (!this.bitmap$0) {
                this.logger = Logging.logger$(this);
                this.bitmap$0 = true;
            }
        }
        return this.logger;
    }

    @Override
    public Logger logger() {
        return !this.bitmap$0 ? this.logger$lzycompute() : this.logger;
    }

    @Override
    public String logIdent() {
        return this.logIdent;
    }

    @Override
    public void logIdent_$eq(String x$1) {
        this.logIdent = x$1;
    }

    public boolean isCompactAndDelete(Log log) {
        return log.config().compact() && log.config().delete();
    }

    public Tuple2<Object, Object> cleanableOffsets(Log log, TopicPartition topicPartition, Map<TopicPartition, Object> lastClean, long now) {
        None$ none$;
        long l;
        long logStartOffset;
        Option lastCleanOffset = lastClean.get((Object)topicPartition);
        long offset = BoxesRunTime.unboxToLong((Object)lastCleanOffset.getOrElse((Function0)((JFunction0.mcJ.sp & Serializable & scala.Serializable)() -> LogCleanerManager$.$anonfun$cleanableOffsets$1(logStartOffset = ((LogSegment)log.logSegments().head()).baseOffset()))));
        if (offset < logStartOffset) {
            if (!this.isCompactAndDelete(log)) {
                this.warn((Function0<String>)(Function0 & Serializable & scala.Serializable)() -> new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"Resetting first dirty offset of ", " to log start offset ", " since the checkpointed offset ", " is invalid."})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{log.name(), BoxesRunTime.boxToLong((long)logStartOffset), BoxesRunTime.boxToLong((long)offset)})));
            }
            l = logStartOffset;
        } else {
            l = offset;
        }
        long firstDirtyOffset = l;
        long compactionLagMs = package$.MODULE$.max(Predef$.MODULE$.Long2long(log.config().compactionLagMs()), 0L);
        Option[] optionArray = new Option[3];
        optionArray[0] = log.firstUnstableOffset().map((Function1 & Serializable & scala.Serializable)x$4 -> BoxesRunTime.boxToLong((long)x$4.messageOffset()));
        optionArray[1] = Option$.MODULE$.apply((Object)BoxesRunTime.boxToLong((long)log.activeSegment().baseOffset()));
        if (compactionLagMs > 0L) {
            Iterable<LogSegment> dirtyNonActiveSegments = log.logSegments(firstDirtyOffset, log.activeSegment().baseOffset());
            none$ = dirtyNonActiveSegments.find((Function1 & Serializable & scala.Serializable)s -> BoxesRunTime.boxToBoolean((boolean)LogCleanerManager$.$anonfun$cleanableOffsets$4(log, now, compactionLagMs, s))).map((Function1 & Serializable & scala.Serializable)x$5 -> BoxesRunTime.boxToLong((long)x$5.baseOffset()));
        } else {
            none$ = None$.MODULE$;
        }
        optionArray[2] = none$;
        long firstUncleanableDirtyOffset = BoxesRunTime.unboxToLong((Object)((TraversableOnce)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])optionArray)).flatten((Function1 & Serializable & scala.Serializable)xo -> Option$.MODULE$.option2Iterable(xo))).min((Ordering)Ordering.Long$.MODULE$));
        this.debug((Function0<String>)(Function0 & Serializable & scala.Serializable)() -> new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"Finding range of cleanable offsets for log=", " topicPartition=", ". Last clean offset=", " now=", " => firstDirtyOffset=", " firstUncleanableOffset=", " activeSegment.baseOffset=", ""})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{log.name(), topicPartition, lastCleanOffset, BoxesRunTime.boxToLong((long)now), BoxesRunTime.boxToLong((long)firstDirtyOffset), BoxesRunTime.boxToLong((long)firstUncleanableDirtyOffset), BoxesRunTime.boxToLong((long)log.activeSegment().baseOffset())})));
        return new Tuple2.mcJJ.sp(firstDirtyOffset, firstUncleanableDirtyOffset);
    }

    public static final /* synthetic */ long $anonfun$cleanableOffsets$1(long logStartOffset$1) {
        return logStartOffset$1;
    }

    public static final /* synthetic */ boolean $anonfun$cleanableOffsets$4(Log log$1, long now$2, long compactionLagMs$1, LogSegment s) {
        boolean isUncleanable = s.largestTimestamp() > now$2 - compactionLagMs$1;
        MODULE$.debug((Function0<String>)(Function0 & Serializable & scala.Serializable)() -> new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"Checking if log segment may be cleaned: log='", "' segment.baseOffset=", " segment.largestTimestamp=", "; now - compactionLag=", "; is uncleanable=", ""})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{log$1.name(), BoxesRunTime.boxToLong((long)s.baseOffset()), BoxesRunTime.boxToLong((long)s.largestTimestamp()), BoxesRunTime.boxToLong((long)(now$2 - compactionLagMs$1)), BoxesRunTime.boxToBoolean((boolean)isUncleanable)})));
        return isUncleanable;
    }

    private LogCleanerManager$() {
        MODULE$ = this;
        Logging.$init$(this);
    }
}

