/*
 * Decompiled with CFR 0.152.
 */
package custom;

import custom.AnimationMessage;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.Vector;
import lts.Relation;

public class ControlActionRegistry {
    Hashtable actionNumber = new Hashtable();
    Hashtable controlNumber = new Hashtable();
    Relation actionsToControls;
    Relation controlsToActions;
    int[][] controlMap;
    int[][] actionMap;
    String[] actionAlphabet;
    String[] controlAlphabet;
    boolean[] controlState;
    AnimationMessage msg;

    public ControlActionRegistry(Relation relation, AnimationMessage animationMessage) {
        this.actionsToControls = relation;
        this.msg = animationMessage;
    }

    void getAnimatorControls() {
        int n = 0;
        Vector<String> vector = new Vector<String>();
        Enumeration enumeration = this.controlsToActions.keys();
        while (enumeration.hasMoreElements()) {
            String string = (String)enumeration.nextElement();
            this.controlNumber.put(string, new Integer(n));
            vector.addElement(string);
            ++n;
        }
        this.controlAlphabet = new String[n];
        vector.copyInto(this.controlAlphabet);
    }

    public Vector getControls() {
        Vector<String> vector = new Vector<String>();
        Enumeration enumeration = this.actionsToControls.keys();
        while (enumeration.hasMoreElements()) {
            String string = (String)enumeration.nextElement();
            vector.addElement(string);
        }
        return vector;
    }

    public int controlled(String string) {
        Integer n = (Integer)this.actionNumber.get(string);
        if (n == null) {
            return -1;
        }
        return n;
    }

    void initMap(String[] stringArray) {
        this.actionAlphabet = stringArray;
        int n = 1;
        while (n < stringArray.length) {
            this.actionNumber.put(stringArray[n], new Integer(n));
            ++n;
        }
        Enumeration<Object> enumeration = this.actionsToControls.keys();
        Vector<String> vector = new Vector<String>();
        while (enumeration.hasMoreElements()) {
            String string = (String)enumeration.nextElement();
            if (this.actionNumber.get(string) != null) continue;
            vector.addElement(string);
        }
        enumeration = vector.elements();
        while (enumeration.hasMoreElements()) {
            this.actionsToControls.remove(enumeration.nextElement());
        }
        this.controlsToActions = this.actionsToControls.inverse();
        this.getAnimatorControls();
        this.controlMap = new int[this.controlAlphabet.length][];
        this.controlState = new boolean[this.controlAlphabet.length];
        int n2 = 0;
        while (n2 < this.controlState.length) {
            this.controlState[n2] = true;
            ++n2;
        }
        this.initControlMap();
        this.initActionMap();
    }

    protected void initControlMap() {
        Enumeration enumeration = this.controlsToActions.keys();
        while (enumeration.hasMoreElements()) {
            int[] nArray;
            String string = (String)enumeration.nextElement();
            int n = (Integer)this.controlNumber.get(string);
            Object v = this.controlsToActions.get(string);
            if (v instanceof String) {
                int n2 = (Integer)this.actionNumber.get((String)v);
                nArray = new int[]{n2};
                this.controlMap[n] = nArray;
                continue;
            }
            Vector vector = (Vector)v;
            nArray = new int[vector.size()];
            Enumeration enumeration2 = vector.elements();
            int n3 = 0;
            while (enumeration2.hasMoreElements()) {
                int n4;
                String string2 = (String)enumeration2.nextElement();
                nArray[n3] = n4 = ((Integer)this.actionNumber.get(string2)).intValue();
                ++n3;
            }
            this.controlMap[n] = nArray;
        }
    }

    protected void initActionMap() {
        this.actionMap = new int[this.actionAlphabet.length][];
        Enumeration enumeration = this.actionsToControls.keys();
        while (enumeration.hasMoreElements()) {
            int[] nArray;
            String string = (String)enumeration.nextElement();
            int n = (Integer)this.actionNumber.get(string);
            Object v = this.actionsToControls.get(string);
            if (v instanceof String) {
                int n2 = (Integer)this.controlNumber.get((String)v);
                nArray = new int[]{n2};
                this.actionMap[n] = nArray;
                continue;
            }
            Vector vector = (Vector)v;
            nArray = new int[vector.size()];
            Enumeration enumeration2 = vector.elements();
            int n3 = 0;
            while (enumeration2.hasMoreElements()) {
                int n4;
                String string2 = (String)enumeration2.nextElement();
                nArray[n3] = n4 = ((Integer)this.controlNumber.get(string2)).intValue();
                ++n3;
            }
            this.actionMap[n] = nArray;
        }
    }

    void print() {
        int n = 0;
        while (n < this.controlMap.length) {
            System.out.println(this.controlAlphabet[n]);
            int n2 = 0;
            while (n2 < this.controlMap[n].length) {
                System.out.print(" " + this.actionAlphabet[this.controlMap[n][n2]]);
                ++n2;
            }
            System.out.println();
            ++n;
        }
    }

    void mapControl(String string, boolean[] blArray, boolean bl) {
        String string2 = bl ? "-enable-" : "-disabl-";
        this.msg.debugMsg("-control" + string2 + string);
        Integer n = (Integer)this.controlNumber.get(string);
        if (n == null) {
            return;
        }
        int n2 = n;
        this.controlState[n2] = bl;
        if (this.controlMap[n2] == null) {
            return;
        }
        int n3 = 0;
        while (n3 < this.controlMap[n2].length) {
            int n4 = this.controlMap[n2][n3];
            if (this.actionMap[n4].length == 1) {
                blArray[n4] = bl;
            } else {
                boolean bl2 = bl;
                int n5 = 0;
                while (n5 < this.actionMap[n4].length) {
                    bl2 = bl2 && this.controlState[this.actionMap[n4][n5]];
                    ++n5;
                }
                blArray[n4] = bl2;
            }
            ++n3;
        }
    }
}

