define("core/mustache",["exports"],(function(_exports){Object.defineProperty(_exports,"__esModule",{value:!0}),_exports.default=void 0;var objectToString=Object.prototype.toString,isArray=Array.isArray||function(object){return"[object Array]"===objectToString.call(object)};function isFunction(object){return"function"==typeof object}function escapeRegExp(string){return string.replace(/[\-\[\]{}()*+?.,\\\^$|#\s]/g,"\\$&")}function hasProperty(obj,propName){return null!=obj&&"object"==typeof obj&&propName in obj}var regExpTest=RegExp.prototype.test;var nonSpaceRe=/\S/;function isWhitespace(string){return!function(re,string){return regExpTest.call(re,string)}(nonSpaceRe,string)}var entityMap={"&":"&amp;","<":"&lt;",">":"&gt;",'"':"&quot;","'":"&#39;","/":"&#x2F;","`":"&#x60;","=":"&#x3D;"};var whiteRe=/\s*/,spaceRe=/\s+/,equalsRe=/\s*=/,curlyRe=/\s*\}/,tagRe=/#|\^|\/|>|\{|&|=|!|\$|</;function Scanner(string){this.string=string,this.tail=string,this.pos=0}function Context(view,parentContext){this.view=view,this.blocks={},this.cache={".":this.view},this.parent=parentContext}function Writer(){this.templateCache={_cache:{},set:function(key,value){this._cache[key]=value},get:function(key){return this._cache[key]},clear:function(){this._cache={}}}}Scanner.prototype.eos=function(){return""===this.tail},Scanner.prototype.scan=function(re){var match=this.tail.match(re);if(!match||0!==match.index)return"";var string=match[0];return this.tail=this.tail.substring(string.length),this.pos+=string.length,string},Scanner.prototype.scanUntil=function(re){var match,index=this.tail.search(re);switch(index){case-1:match=this.tail,this.tail="";break;case 0:match="";break;default:match=this.tail.substring(0,index),this.tail=this.tail.substring(index)}return this.pos+=match.length,match},Context.prototype.push=function(view){return new Context(view,this)},Context.prototype.setBlockVar=function(name,value){return this.blocks[name]=value,value},Context.prototype.clearBlockVars=function(){this.blocks={}},Context.prototype.getBlockVar=function(name){var value,blocks=this.blocks;return blocks.hasOwnProperty(name)?value=blocks[name]:this.parent&&(value=this.parent.getBlockVar(name)),value},Context.prototype.parseNameAndArgs=function(name){var arg,argbuffer,parts=name.split(" "),inString=!1,first=!0,i=0,finalArgs=[];for(i=0;i<parts.length;i++)arg=parts[i],argbuffer="",inString?-1!==arg.replace("\\\\","").search(/^"$|[^\\]"$/)?(finalArgs[finalArgs.length]=argbuffer+" "+arg.substr(0,arg.length-1),argbuffer="",inString=!1):argbuffer+=" "+arg:-1===arg.search(/^"/)||first?(-1!==arg.search(/^\d+(\.\d*)?$/)?finalArgs[finalArgs.length]=parseFloat(arg):finalArgs[finalArgs.length]="true"===arg?1:"false"===arg?0:first?arg:this.lookup(arg),first=!1):-1!==arg.replace("\\\\","").search(/^".*[^\\]"$/)?finalArgs[finalArgs.length]=arg.substr(1,arg.length-2):(inString=!0,argbuffer=arg.substr(1));return finalArgs},Context.prototype.lookup=function(name){var value,primitive,propName,cache=this.cache,lambdaArgs=this.parseNameAndArgs(name);if(name=lambdaArgs.shift(),cache.hasOwnProperty(name))value=cache[name];else{for(var intermediateValue,names,index,context=this,lookupHit=!1;context;){if(name.indexOf(".")>0)for(intermediateValue=context.view,names=name.split("."),index=0;null!=intermediateValue&&index<names.length;)index===names.length-1&&(lookupHit=hasProperty(intermediateValue,names[index])||(primitive=intermediateValue,propName=names[index],null!=primitive&&"object"!=typeof primitive&&primitive.hasOwnProperty&&primitive.hasOwnProperty(propName))),intermediateValue=intermediateValue[names[index++]];else intermediateValue=context.view[name],lookupHit=hasProperty(context.view,name);if(lookupHit){value=intermediateValue;break}context=context.parent}cache[name]=value}return isFunction(value)&&(value=value.call(this.view,lambdaArgs)),value},Writer.prototype.clearCache=function(){void 0!==this.templateCache&&this.templateCache.clear()},Writer.prototype.parse=function(template,tags){var cache=this.templateCache,cacheKey=template+":"+(tags||mustache.tags).join(":"),isCacheEnabled=void 0!==cache,tokens=isCacheEnabled?cache.get(cacheKey):void 0;return null==tokens&&(tokens=function(template,tags){if(!template)return[];var openingTagRe,closingTagRe,closingCurlyRe,lineHasNonSpace=!1,sections=[],tokens=[],spaces=[],hasTag=!1,nonSpace=!1,indentation="",tagIndex=0;function stripSpace(){if(hasTag&&!nonSpace)for(;spaces.length;)delete tokens[spaces.pop()];else spaces=[];hasTag=!1,nonSpace=!1}function compileTags(tagsToCompile){if("string"==typeof tagsToCompile&&(tagsToCompile=tagsToCompile.split(spaceRe,2)),!isArray(tagsToCompile)||2!==tagsToCompile.length)throw new Error("Invalid tags: "+tagsToCompile);openingTagRe=new RegExp(escapeRegExp(tagsToCompile[0])+"\\s*"),closingTagRe=new RegExp("\\s*"+escapeRegExp(tagsToCompile[1])),closingCurlyRe=new RegExp("\\s*"+escapeRegExp("}"+tagsToCompile[1]))}compileTags(tags||mustache.tags);for(var start,type,value,chr,token,openSection,tagName,scanner=new Scanner(template);!scanner.eos();){if(start=scanner.pos,value=scanner.scanUntil(openingTagRe))for(var i=0,valueLength=value.length;i<valueLength;++i)isWhitespace(chr=value.charAt(i))?(spaces.push(tokens.length),indentation+=chr):(nonSpace=!0,lineHasNonSpace=!0,indentation+=" "),tokens.push(["text",chr,start,start+1]),start+=1,"\n"===chr&&(stripSpace(),indentation="",tagIndex=0,lineHasNonSpace=!1);if(!scanner.scan(openingTagRe))break;if(hasTag=!0,type=scanner.scan(tagRe)||"name",scanner.scan(whiteRe),"="===type?(value=scanner.scanUntil(equalsRe),scanner.scan(equalsRe),scanner.scanUntil(closingTagRe)):"{"===type?(value=scanner.scanUntil(closingCurlyRe),scanner.scan(curlyRe),scanner.scanUntil(closingTagRe),type="&"):value=scanner.scanUntil(closingTagRe),!scanner.scan(closingTagRe))throw new Error("Unclosed tag at "+scanner.pos);if(token=">"==type?[type,value,start,scanner.pos,indentation,tagIndex,lineHasNonSpace]:[type,value,start,scanner.pos],tagIndex++,tokens.push(token),"#"===type||"^"===type||"$"===type||"<"===type)sections.push(token);else if("/"===type){if(!(openSection=sections.pop()))throw new Error('Unopened section "'+value+'" at '+start);if((tagName=openSection[1].split(" ",1)[0])!==value.split(" ",1)[0])throw new Error('Unclosed section "'+tagName+'" at '+start)}else"name"===type||"{"===type||"&"===type?nonSpace=!0:"="===type&&compileTags(value)}if(stripSpace(),openSection=sections.pop())throw new Error('Unclosed section "'+openSection[1]+'" at '+scanner.pos);return function(tokens){for(var token,nestedTokens=[],collector=nestedTokens,sections=[],i=0,numTokens=tokens.length;i<numTokens;++i)switch((token=tokens[i])[0]){case"$":case"<":case"#":case"^":collector.push(token),sections.push(token),collector=token[4]=[];break;case"/":sections.pop()[5]=token[2],collector=sections.length>0?sections[sections.length-1][4]:nestedTokens;break;default:collector.push(token)}return nestedTokens}(function(tokens){for(var token,lastToken,squashedTokens=[],i=0,numTokens=tokens.length;i<numTokens;++i)(token=tokens[i])&&("text"===token[0]&&lastToken&&"text"===lastToken[0]?(lastToken[1]+=token[1],lastToken[3]=token[3]):(squashedTokens.push(token),lastToken=token));return squashedTokens}(tokens))}(template,tags),isCacheEnabled&&cache.set(cacheKey,tokens)),tokens},Writer.prototype.render=function(template,view,partials,config){var tags=this.getConfigTags(config),tokens=this.parse(template,tags),context=view instanceof Context?view:new Context(view,void 0);return this.renderTokens(tokens,context,partials,template,config)},Writer.prototype.renderTokens=function(tokens,context,partials,originalTemplate,config){for(var token,symbol,value,buffer="",i=0,numTokens=tokens.length;i<numTokens;++i)value=void 0,"#"===(symbol=(token=tokens[i])[0])?value=this.renderSection(token,context,partials,originalTemplate,config):"^"===symbol?value=this.renderInverted(token,context,partials,originalTemplate,config):">"===symbol?value=this.renderPartial(token,context,partials,config):"<"===symbol?value=this.renderBlock(token,context,partials,originalTemplate,config):"$"===symbol?value=this.renderBlockVariable(token,context,partials,originalTemplate,config):"&"===symbol?value=this.unescapedValue(token,context):"name"===symbol?value=this.escapedValue(token,context,config):"text"===symbol&&(value=this.rawValue(token)),void 0!==value&&(buffer+=value);return buffer},Writer.prototype.renderSection=function(token,context,partials,originalTemplate,config){var self=this,buffer="",lambdaArgs=context.parseNameAndArgs(token[1]),name=lambdaArgs.shift(),value=context.lookup(name);if(value){if(isArray(value))for(var j=0,valueLength=value.length;j<valueLength;++j)buffer+=this.renderTokens(token[4],context.push(value[j]),partials,originalTemplate,config);else if("object"==typeof value||"string"==typeof value||"number"==typeof value)buffer+=this.renderTokens(token[4],context.push(value),partials,originalTemplate,config);else if(isFunction(value)){if("string"!=typeof originalTemplate)throw new Error("Cannot use higher-order sections without the original template");null!=(value=value.call(context.view,originalTemplate.slice(token[3],token[5]),(function(template){return self.render(template,context,partials,config)}),lambdaArgs))&&(buffer+=value)}else buffer+=this.renderTokens(token[4],context,partials,originalTemplate,config);return buffer}},Writer.prototype.renderInverted=function(token,context,partials,originalTemplate,config){var value=context.lookup(token[1]);if(!value||isArray(value)&&0===value.length)return this.renderTokens(token[4],context,partials,originalTemplate,config)},Writer.prototype.indentPartial=function(partial,indentation,lineHasNonSpace){for(var filteredIndentation=indentation.replace(/[^ \t]/g,""),partialByNl=partial.split("\n"),i=0;i<partialByNl.length;i++)partialByNl[i].length&&(i>0||!lineHasNonSpace)&&(partialByNl[i]=filteredIndentation+partialByNl[i]);return partialByNl.join("\n")},Writer.prototype.renderPartial=function(token,context,partials,config){if(partials){var tags=this.getConfigTags(config),value=isFunction(partials)?partials(token[1]):partials[token[1]];if(null!=value){var lineHasNonSpace=token[6],tagIndex=token[5],indentation=token[4],indentedValue=value;0==tagIndex&&indentation&&(indentedValue=this.indentPartial(value,indentation,lineHasNonSpace));var tokens=this.parse(indentedValue,tags);return this.renderTokens(tokens,context,partials,indentedValue,config)}}},Writer.prototype.renderBlock=function(token,context,partials,originalTemplate,config){if(partials){var value=isFunction(partials)?partials(token[1]):partials[token[1]];null!=value&&context.clearBlockVars(),this.renderTokens(token[4],context,partials,originalTemplate,config);var result=this.renderTokens(this.parse(value),context,partials,value,config);return context.clearBlockVars(),result}},Writer.prototype.renderBlockVariable=function(token,context,partials,originalTemplate,config){var value=token[1],exists=context.getBlockVar(value);return exists?this.renderTokens(this.parse(exists),context,partials,exists,config):(context.setBlockVar(value,originalTemplate.slice(token[3],token[5])),this.renderTokens(token[4],context,partials,originalTemplate,config))},Writer.prototype.unescapedValue=function(token,context){var value=context.lookup(token[1]);if(null!=value)return value},Writer.prototype.escapedValue=function(token,context,config){var escape=this.getConfigEscape(config)||mustache.escape,value=context.lookup(token[1]);if(null!=value)return"number"==typeof value&&escape===mustache.escape?String(value):escape(value)},Writer.prototype.rawValue=function(token){return token[1]},Writer.prototype.getConfigTags=function(config){return isArray(config)?config:config&&"object"==typeof config?config.tags:void 0},Writer.prototype.getConfigEscape=function(config){return config&&"object"==typeof config&&!isArray(config)?config.escape:void 0};var mustache={name:"mustache.js",version:"4.2.0",tags:["{{","}}"],clearCache:void 0,escape:void 0,parse:void 0,render:void 0,Scanner:void 0,Context:void 0,Writer:void 0,set templateCache(cache){defaultWriter.templateCache=cache},get templateCache(){return defaultWriter.templateCache}},defaultWriter=new Writer;mustache.clearCache=function(){return defaultWriter.clearCache()},mustache.parse=function(template,tags){return defaultWriter.parse(template,tags)},mustache.render=function(template,view,partials,config){if("string"!=typeof template)throw new TypeError('Invalid template! Template should be a "string" but "'+((isArray(obj=template)?"array":typeof obj)+'" was given as the first argument for mustache#render(template, view, partials)'));var obj;return defaultWriter.render(template,view,partials,config)},mustache.escape=function(string){return String(string).replace(/[&<>"'`=\/]/g,(function(s){return entityMap[s]}))},mustache.Scanner=Scanner,mustache.Context=Context,mustache.Writer=Writer;var _default=mustache;return _exports.default=_default,_exports.default}));

//# sourceMappingURL=mustache.min.js.map