<?php
/**
 * ラベルを複数指定し、そのラベルに割り当てられているエントリーについているすべてのラベルを取得する
 */
class NarrowLabelListAction extends SOY2Action{

	private $labelIds = array();

	function setLabelIds($labelIds){
		$this->labelIds = $labelIds;
	}

    function execute() {
    
    	$logic = SOY2Logic::createInstance("logic.site.Label.LabelLogic");
    	$subLabels = $logic->getNarrowLabels($this->labelIds);

		//エントリー管理者の場合
		if(!UserInfoUtil::hasSiteAdminRole()){
			$res = array();
			foreach($subLabels as $key => $labelId){
				$label = $logic->getById($labelId);
				if(!preg_match('/^\*/',$label->getCaption())){
					$res[$key] = $labelId;
				}
			}
			
			$subLabels = $res;
		}


    	$this->setAttribute("labels",$subLabels);

    	return SOY2Action::SUCCESS;
    	
    }
}
?>