/*
 * This file is part of the TYPO3 CMS project.
 *
 * It is free software; you can redistribute it and/or modify it under
 * the terms of the GNU General Public License, either version 2
 * of the License, or any later version.
 *
 * For the full copyright and license information, please read the
 * LICENSE.txt file that was distributed with this source code.
 *
 * The TYPO3 project - inspiring people to share!
 */
import{property as d,customElement as $}from"lit/decorators.js";import{LitElement as k,css as z,html as r,nothing as p}from"lit";import h from"@typo3/backend/modal.js";import"@typo3/backend/element/icon-element.js";import M from"@typo3/core/ajax/ajax-request.js";import{lll as N}from"@typo3/core/lit-helper.js";import T from"@typo3/backend/notification.js";import f from"@typo3/backend/viewport.js";import E from"@typo3/core/event/regular-event.js";import{KeyTypesEnum as v}from"@typo3/backend/enum/key-types.js";var c=function(l,e,t,o){var s=arguments.length,i=s<3?e:o===null?o=Object.getOwnPropertyDescriptor(e,t):o,a;if(typeof Reflect=="object"&&typeof Reflect.decorate=="function")i=Reflect.decorate(l,e,t,o);else for(var g=l.length-1;g>=0;g--)(a=l[g])&&(i=(s<3?a(i):s>3?a(e,t,i):a(e,t))||i);return s>3&&i&&Object.defineProperty(e,t,i),i};const b={fromAttribute:l=>l===null?!0:l.toLowerCase()==="true",toAttribute:l=>l?"true":"false"};class y{constructor(e,t,o,s,i,a,g,w,C,x){this.identifier=e,this.label=t,this.description=o,this.icon=s,this.iconOverlay=i,this.url=a,this.requestType=g,this.defaultValues=w,this.saveAndClose=C,this.event=x,this.visible=!0}static fromData(e){return new y(e.identifier,e.label,e.description,e.icon,e.iconOverlay,e.url??null,e.requestType??"location",e.defaultValues??[],e.saveAndClose??!1,e.event??null)}reset(){this.visible=!0}}class u{constructor(e,t,o){this.identifier=e,this.label=t,this.items=o,this.disabled=!1}static fromData(e){return new u(e.identifier,e.label,e.items.map(t=>y.fromData(t)))}reset(){this.disabled=!1,this.items.forEach(e=>{e.reset()})}activeItems(){return this.items.filter(e=>e.visible)??[]}}class m{constructor(e){this.items=e}static fromData(e){return new m(Object.values(e).map(t=>u.fromData(t)))}reset(){this.items.forEach(e=>{e.reset()})}categoriesWithItems(){return this.items.filter(e=>e.activeItems().length>0)??[]}}let n=class extends k{constructor(){super(...arguments),this.categories=new m([]),this.searchPlaceholder="newRecordWizard.filter.placeholder",this.searchNothingFoundLabel="newRecordWizard.filter.noResults",this.displayMenu=!0,this.displayFilter=!0,this.selectedCategory=null,this.searchTerm="",this.messages=[],this.toggleMenu=!1,this.hasNavigation=!1}static{this.styles=[z`:host{display:block;container-type:inline-size;height:100%}.element{gap:var(--typo3-spacing);font-size:var(--typo3-component-font-size);line-height:var(--typo3-component-line-height);height:100%}.element,.main{display:flex;flex-direction:column}.main{width:100%;gap:calc(var(--typo3-spacing)*2)}@container (min-width: 500px){.main{flex-direction:row;overflow:hidden}}.main>*{flex-grow:1;padding-inline-end:calc(var(--typo3-spacing)/4)}.navigation{position:relative;flex-shrink:0}@container (min-width: 500px){.navigation{flex-grow:0;width:200px;overflow-block:auto}.navigation-toggle{display:none!important}}.navigation-list{display:none;flex-direction:column;gap:2px;list-style:none;padding:0;margin:0}.navigation-list.show{display:flex}@container (max-width: 499px){.navigation-list{z-index:1;position:absolute;padding:var(--typo3-component-border-width);background:var(--typo3-component-bg);border:var(--typo3-component-border-width) solid var(--typo3-component-border-color);border-radius:var(--typo3-component-border-radius);box-shadow:var(--typo3-component-box-shadow)}}@container (min-width: 500px){.navigation-list{display:flex}}.navigation-item{cursor:pointer;align-items:center;display:flex;width:100%;gap:calc(var(--typo3-spacing)/2);text-align:start;color:inherit;background:transparent;border:var(--typo3-component-border-width) solid var(--typo3-component-border-color);border-radius:var(--typo3-component-border-radius);padding:var(--typo3-list-item-padding-y) var(--typo3-list-item-padding-x)}@container (max-width: 499px){.navigation-item{border-radius:calc(var(--typo3-component-border-radius) - var(--typo3-component-border-width))}}.navigation-item:hover{color:var(--typo3-component-hover-color);background:var(--typo3-component-hover-bg);border-color:var(--typo3-component-hover-border-color)}.navigation-item:focus{outline:none;color:var(--typo3-component-focus-color);background:var(--typo3-component-focus-bg);border-color:var(--typo3-component-focus-border-color)}.navigation-item.active{color:var(--typo3-component-active-color);background:var(--typo3-component-active-bg);border-color:var(--typo3-component-active-border-color)}.navigation-item.active:focus-visible{outline:var(--typo3-outline-width) var(--typo3-outline-style) color-mix(in srgb,var(--typo3-component-active-border-color),transparent 25%)}.navigation-item[disabled]{cursor:not-allowed;color:var(--typo3-component-disabled-color);background:var(--typo3-component-disabled-bg);border-color:var(--typo3-component-disabled-border-color)}.navigation-item-label{flex-grow:1}.navigation-item-count{opacity:.75;flex-shrink:0}.content{container-type:inline-size;overflow-block:auto}.elementwizard-categories{display:grid;gap:var(--typo3-spacing)}.elementwizard-category-headline{font-weight:700;color:var(--typo3-text-color-variant);margin-bottom:calc(var(--typo3-spacing)/2)}.elementwizard-category-items{display:grid;grid-template-columns:repeat(1,1fr);gap:var(--typo3-spacing)}@container (min-width: 500px){.elementwizard-category-items{grid-template-columns:repeat(2,1fr)}}@container (min-width: 750px){.elementwizard-category-items{grid-template-columns:repeat(3,1fr)}}.item{cursor:pointer;display:flex;gap:calc(var(--typo3-spacing)/2);text-align:start;border:var(--typo3-component-border-width) solid transparent;border-radius:var(--typo3-component-border-radius);padding:var(--typo3-list-item-padding-y) var(--typo3-list-item-padding-x);background:transparent;color:inherit}.item:hover{color:var(--typo3-component-hover-color);background:var(--typo3-component-hover-bg);border-color:var(--typo3-component-hover-border-color)}.item:focus{outline:none;color:var(--typo3-component-focus-color);background:var(--typo3-component-focus-bg);border-color:var(--typo3-component-focus-border-color)}.item-body-label{text-wrap:balance;font-weight:700;margin-bottom:.25rem}.item-body-description{opacity:.75;text-wrap:pretty}`]}firstUpdated(){const e=document.createElement("link");e.setAttribute("rel","stylesheet"),e.setAttribute("href",TYPO3.settings.cssUrls.backend),this.shadowRoot.appendChild(e),this.displayFilter===!0&&this.renderRoot.querySelector('input[name="search"]').focus(),this.selectAvailableCategory()}getLanguageLabel(e){const t=N(e);return t!==""?t:e}selectAvailableCategory(){this.categories.categoriesWithItems().filter(t=>t===this.selectedCategory).length===0&&(this.selectedCategory=this.categories.categoriesWithItems()[0]??null),this.messages=[],this.selectedCategory===null&&(this.messages=[{message:this.getLanguageLabel(this.searchNothingFoundLabel),severity:"info"}])}filter(e){this.searchTerm=e,this.categories.reset(),this.categories.items.forEach(t=>{const o=t.label.trim().replace(/\s+/g," ");!(this.searchTerm!==""&&!RegExp(this.searchTerm,"i").test(o))||t.items.forEach(i=>{const a=i.label.trim().replace(/\s+/g," ")+i.description?.trim().replace(/\s+/g," ");i.visible=!(this.searchTerm!==""&&!RegExp(this.searchTerm,"i").test(a))}),t.disabled=t.items.filter(i=>i.visible).length===0}),this.selectAvailableCategory()}willUpdate(){const e=this.selectedCategory!==null&&this.displayMenu===!0&&this.categories.items.length>1;this.hasNavigation!==e&&(this.hasNavigation=e)}render(){return r`<div class=element>${this.displayFilter===!0?this.renderFilter():p} ${this.renderMessages()} ${this.selectedCategory===null?p:r`<div class=main>${this.categories.items.length>1&&this.displayMenu===!0?r`<div class=navigation>${this.renderNavigationToggle()} ${this.renderNavigationList()}</div>`:p}<div class=content>${this.renderCategories()}</div></div>`}</div>`}renderFilter(){return r`<form class=filter @submit=${e=>e.preventDefault()}><input name=search type=search autocomplete=off class=form-control .value=${this.searchTerm} @input=${e=>{this.filter(e.target.value)}} @keydown=${e=>{e.key===v.ESCAPE&&(e.stopImmediatePropagation(),this.filter(""))}} placeholder=${this.getLanguageLabel(this.searchPlaceholder)}></form>`}renderMessages(){return r`${this.messages.length>0?r`<div class=messages>${this.messages.map(e=>r`<div class="alert alert-${e.severity}" role=alert>${e.message}</div>`)}</div>`:p}`}renderNavigationToggle(){return r`<button class="navigation-toggle btn btn-light" @click=${()=>{this.toggleMenu=!this.toggleMenu}}>${this.selectedCategory.label}<typo3-backend-icon identifier=actions-chevron-${this.toggleMenu===!0?"up":"down"} size=small></typo3-backend-icon></button>`}renderNavigationList(){return r`<div class=navigation-list${this.toggleMenu===!0?" show":""} role=tablist aria-orientation=vertical>${this.categories.items.map(e=>r`<button data-identifier=${e.identifier} class=navigation-item${this.selectedCategory===e?" active":""} ?disabled=${e.disabled} @click=${()=>{this.handleNavigationClick(e)}} @keydown=${t=>{this.handleNavigationKeydown(t,e)}} role=tab aria-selected=${this.selectedCategory===e?"true":"false"} tabindex=${this.selectedCategory===e?"0":"-1"}><span class=navigation-item-label>${e.label}</span> <span class=navigation-item-count>${e.activeItems().length}</span></button>`)}</div>`}handleNavigationClick(e){this.selectedCategory=e,this.toggleMenu=!1}handleNavigationKeydown(e,t){const o=this.categories.categoriesWithItems(),s=o.findIndex(a=>a.identifier===t.identifier);let i;if(e.key===v.UP)i=o[s-1]??void 0;else if(e.key===v.DOWN)i=o[s+1]??void 0;else return;i&&(this.shadowRoot.querySelector(`button[data-identifier="${i.identifier}"]`).focus(),this.handleNavigationClick(i))}renderCategories(){return r`<div class=elementwizard-categories>${this.categories.items.map(e=>this.renderCategory(e))}</div>`}renderCategory(e){return r`${(this.selectedCategory===e||this.displayMenu===!1)&&!e.disabled?r`<div class=elementwizard-category>${this.displayMenu===!1?r`<div class=elementwizard-category-headline>${e.label}</div>`:p}<div class=elementwizard-category-items>${e.items.map(t=>this.renderCategoryItem(t))}</div></div>`:p}`}renderCategoryItem(e){return r`${e.visible?r`<button type=button class=item data-identifier=${e.identifier} @click=${t=>{t.preventDefault(),this.handleItemClick(e)}}><div class=item-icon><typo3-backend-icon identifier=${e.icon||"empty-empty"} overlay=${e.iconOverlay} size=medium></typo3-backend-icon></div><div class=item-body><div class=item-body-label>${e.label}</div><div class=item-body-description>${e.description}</div></div></button>`:p}`}handleItemClick(e){if(e.requestType==="event"){const t=new CustomEvent(e.event,{detail:{item:e}});this.dispatchEvent(t),h.dismiss();return}if(e.url.trim()!==""){if(e.requestType==="location"){f.ContentContainer.setUrl(e.url),h.dismiss();return}e.requestType==="ajax"&&new M(e.url).post({defVals:e.defaultValues,saveAndClose:e.saveAndClose?"1":"0"}).then(async t=>{const o=document.createRange().createContextualFragment(await t.resolve());h.currentModal.addEventListener("modal-updated",()=>{new E("click",(s,i)=>{s.preventDefault();const a=i.dataset.target;a&&(f.ContentContainer.setUrl(a),h.dismiss())}).delegateTo(h.currentModal,"button[data-target]")}),h.currentModal.setContent(o)}).catch(()=>{T.error("Could not load module data")})}}};c([d({type:Object,converter:{fromAttribute:l=>{const e=JSON.parse(l);return m.fromData(e)}}})],n.prototype,"categories",void 0),c([d({type:String})],n.prototype,"searchPlaceholder",void 0),c([d({type:String})],n.prototype,"searchNothingFoundLabel",void 0),c([d({type:Boolean,converter:b})],n.prototype,"displayMenu",void 0),c([d({type:Boolean,converter:b})],n.prototype,"displayFilter",void 0),c([d({type:String,attribute:!1})],n.prototype,"selectedCategory",void 0),c([d({type:String,attribute:!1})],n.prototype,"searchTerm",void 0),c([d({type:Array,attribute:!1})],n.prototype,"messages",void 0),c([d({type:Boolean,attribute:!1})],n.prototype,"toggleMenu",void 0),c([d({type:Boolean,reflect:!0,attribute:"has-navigation"})],n.prototype,"hasNavigation",void 0),n=c([$("typo3-backend-new-record-wizard")],n);export{m as Categories,u as Category,n as NewRecordWizard};
