/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.openapi.application.ex;

import com.intellij.openapi.application.ex.ApplicationManagerEx;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.util.io.URLUtil;
import gnu.trove.THashMap;
import java.io.IOException;
import java.io.InputStream;
import java.net.URL;
import java.util.Collections;
import java.util.Map;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class DecodeDefaultsUtil {
    private static final Logger LOG = Logger.getInstance((String)"#com.intellij.openapi.application.ex.DecodeDefaultsUtil");
    private static final Map<String, URL> RESOURCE_CACHE = Collections.synchronizedMap(new THashMap());

    public static URL getDefaults(Object requestor, @NotNull String componentResourcePath) {
        URL url;
        if (componentResourcePath == null) {
            DecodeDefaultsUtil.$$$reportNull$$$0(0);
        }
        if ((url = RESOURCE_CACHE.get(componentResourcePath)) == null) {
            if (StringUtil.startsWithChar((CharSequence)componentResourcePath, (char)'/')) {
                url = DecodeDefaultsUtil.getResource(DecodeDefaultsUtil.appendExt(componentResourcePath), requestor);
            } else {
                url = DecodeDefaultsUtil.getResource(DecodeDefaultsUtil.appendExt('/' + ApplicationManagerEx.getApplicationEx().getName() + '/' + componentResourcePath), requestor);
                if (url == null) {
                    url = DecodeDefaultsUtil.getResource(DecodeDefaultsUtil.appendExt('/' + componentResourcePath), requestor);
                }
            }
            RESOURCE_CACHE.put(componentResourcePath, url);
        }
        return url;
    }

    private static URL getResource(String path, Object requestor) {
        if (requestor instanceof ClassLoader) {
            return ((ClassLoader)requestor).getResource(path);
        }
        return requestor.getClass().getResource(path);
    }

    private static String appendExt(@NotNull String s) {
        if (s == null) {
            DecodeDefaultsUtil.$$$reportNull$$$0(1);
        }
        return DecodeDefaultsUtil.appendIfNeeded(s, ".xml");
    }

    private static String appendIfNeeded(@NotNull String head, @NotNull String tail) {
        if (head == null) {
            DecodeDefaultsUtil.$$$reportNull$$$0(2);
        }
        if (tail == null) {
            DecodeDefaultsUtil.$$$reportNull$$$0(3);
        }
        return head.endsWith(tail) ? head : head + tail;
    }

    @Nullable
    public static InputStream getDefaultsInputStream(Object requestor, @NotNull String componentResourcePath) {
        if (componentResourcePath == null) {
            DecodeDefaultsUtil.$$$reportNull$$$0(4);
        }
        try {
            URL defaults = DecodeDefaultsUtil.getDefaults(requestor, componentResourcePath);
            return defaults == null ? null : URLUtil.openStream((URL)defaults);
        }
        catch (IOException e) {
            LOG.error((Throwable)e);
            return null;
        }
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[3];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "componentResourcePath";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "s";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "head";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "tail";
                break;
            }
        }
        objectArray2[1] = "com/intellij/openapi/application/ex/DecodeDefaultsUtil";
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[2] = "getDefaults";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[2] = "appendExt";
                break;
            }
            case 2: 
            case 3: {
                objectArray = objectArray2;
                objectArray2[2] = "appendIfNeeded";
                break;
            }
            case 4: {
                objectArray = objectArray2;
                objectArray2[2] = "getDefaultsInputStream";
                break;
            }
        }
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
    }
}

