/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.openapi.diff.actions;

import com.intellij.openapi.actionSystem.AnAction;
import com.intellij.openapi.actionSystem.AnActionEvent;
import com.intellij.openapi.actionSystem.Presentation;
import com.intellij.openapi.diff.impl.DiffUtil;
import com.intellij.openapi.diff.impl.util.FocusDiffSide;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.editor.LogicalPosition;
import com.intellij.openapi.editor.ScrollType;
import com.intellij.openapi.project.DumbAware;
import java.awt.event.KeyEvent;
import org.jetbrains.annotations.NotNull;

public abstract class DiffWalkerAction
extends AnAction
implements DumbAware {
    protected DiffWalkerAction() {
        this.setEnabledInModalContext(true);
    }

    public void actionPerformed(@NotNull AnActionEvent event) {
        FocusDiffSide side;
        if (event == null) {
            DiffWalkerAction.$$$reportNull$$$0(0);
        }
        if ((side = DiffUtil.getFocusDiffSide(event.getDataContext())) == null) {
            return;
        }
        int line = this.getLineNumberToGo(side);
        Editor editor = side.getEditor();
        if (line >= 0 && editor != null) {
            LogicalPosition pos = new LogicalPosition(line, 0);
            editor.getCaretModel().removeSecondaryCarets();
            editor.getCaretModel().moveToLogicalPosition(pos);
            editor.getScrollingModel().scrollToCaret(ScrollType.CENTER);
        }
    }

    public void update(@NotNull AnActionEvent event) {
        if (event == null) {
            DiffWalkerAction.$$$reportNull$$$0(1);
        }
        FocusDiffSide side = DiffUtil.getFocusDiffSide(event.getDataContext());
        Presentation presentation = event.getPresentation();
        if (side == null) {
            presentation.setEnabled(false);
        } else {
            presentation.setEnabled(this.getLineNumberToGo(side) >= 0 || event.getInputEvent() instanceof KeyEvent);
        }
    }

    protected abstract int getLineNumberToGo(FocusDiffSide var1);

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2 = new Object[3];
        objectArray2[0] = "event";
        objectArray2[1] = "com/intellij/openapi/diff/actions/DiffWalkerAction";
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[2] = "actionPerformed";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[2] = "update";
                break;
            }
        }
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
    }
}

