/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.plugins.less.completion.provider;

import com.intellij.codeInsight.completion.CompletionParameters;
import com.intellij.codeInsight.completion.CompletionProvider;
import com.intellij.codeInsight.completion.CompletionResultSet;
import com.intellij.codeInsight.completion.CompletionUtil;
import com.intellij.openapi.project.Project;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.css.impl.util.CssUtil;
import com.intellij.psi.search.GlobalSearchScope;
import com.intellij.psi.stubs.StubIndex;
import com.intellij.psi.util.PsiTreeUtil;
import com.intellij.util.ProcessingContext;
import com.intellij.util.Processor;
import java.util.Set;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.plugins.less.LESSUtil;
import org.jetbrains.plugins.less.LessLangUtil;
import org.jetbrains.plugins.less.psi.LESSMixin;
import org.jetbrains.plugins.less.psi.LESSVariableDeclaration;
import org.jetbrains.plugins.less.psi.LessParameter;
import org.jetbrains.plugins.less.psi.stubs.LessVariableIndex;

public class LessVariableCompletionProvider
extends CompletionProvider<CompletionParameters> {
    protected void addCompletions(@NotNull CompletionParameters parameters, @NotNull ProcessingContext context, @NotNull CompletionResultSet result) {
        if (parameters == null) {
            LessVariableCompletionProvider.$$$reportNull$$$0(0);
        }
        if (context == null) {
            LessVariableCompletionProvider.$$$reportNull$$$0(1);
        }
        if (result == null) {
            LessVariableCompletionProvider.$$$reportNull$$$0(2);
        }
        CompletionResultSet resultSet = LessVariableCompletionProvider.fixPrefix(result);
        PsiElement position = parameters.getPosition();
        Project project = position.getProject();
        LESSVariableDeclaration originalParentDeclaration = LessVariableCompletionProvider.getParentVariableDeclaration(position);
        Set importedFiles = CssUtil.getImportedFiles((PsiFile)parameters.getOriginalFile(), (PsiElement)position, (boolean)false);
        GlobalSearchScope scope = CssUtil.getCompletionAndResolvingScopeForElement((PsiElement)position);
        for (String name : StubIndex.getInstance().getAllKeys(LessVariableIndex.KEY, project)) {
            LessVariableIndex.process(name, project, scope, (Processor<? super LESSVariableDeclaration>)((Processor)variableDeclaration -> {
                if (originalParentDeclaration == variableDeclaration || position.getParent() == variableDeclaration) {
                    return true;
                }
                if (LessLangUtil.isVisibleDeclaration((PsiElement)variableDeclaration, position)) {
                    boolean validResult = importedFiles.contains(variableDeclaration.getContainingFile().getVirtualFile());
                    resultSet.addElement(LESSUtil.createVariableLookupItem(variableDeclaration, validResult));
                }
                return true;
            }));
        }
        LessVariableCompletionProvider.addParametersVariableVariant(resultSet, position);
    }

    @NotNull
    private static CompletionResultSet fixPrefix(@NotNull CompletionResultSet result) {
        String prefix;
        if (result == null) {
            LessVariableCompletionProvider.$$$reportNull$$$0(3);
        }
        if ((prefix = result.getPrefixMatcher().getPrefix()).startsWith("@{")) {
            CompletionResultSet completionResultSet = result.withPrefixMatcher(prefix.substring(2));
            if (completionResultSet == null) {
                LessVariableCompletionProvider.$$$reportNull$$$0(4);
            }
            return completionResultSet;
        }
        if (prefix.startsWith("@")) {
            CompletionResultSet completionResultSet = result.withPrefixMatcher(prefix.substring(1));
            if (completionResultSet == null) {
                LessVariableCompletionProvider.$$$reportNull$$$0(5);
            }
            return completionResultSet;
        }
        CompletionResultSet completionResultSet = result;
        if (completionResultSet == null) {
            LessVariableCompletionProvider.$$$reportNull$$$0(6);
        }
        return completionResultSet;
    }

    private static void addParametersVariableVariant(@NotNull CompletionResultSet result, @NotNull PsiElement position) {
        LESSMixin lessMixin;
        LESSMixin closestMixin;
        if (result == null) {
            LessVariableCompletionProvider.$$$reportNull$$$0(7);
        }
        if (position == null) {
            LessVariableCompletionProvider.$$$reportNull$$$0(8);
        }
        if (PsiTreeUtil.getParentOfType((PsiElement)position, LessParameter.class) != null && (closestMixin = (LESSMixin)PsiTreeUtil.getParentOfType((PsiElement)position, LESSMixin.class)) != null) {
            position = closestMixin;
        }
        if ((lessMixin = (LESSMixin)PsiTreeUtil.getParentOfType((PsiElement)position, LESSMixin.class)) != null && lessMixin.hasParameters()) {
            result.addElement(LESSUtil.createArgumentsLookupItem(lessMixin));
        }
    }

    @Nullable
    private static LESSVariableDeclaration getParentVariableDeclaration(PsiElement variable) {
        LESSVariableDeclaration parentDeclaration = (LESSVariableDeclaration)PsiTreeUtil.getParentOfType((PsiElement)variable, LESSVariableDeclaration.class);
        return parentDeclaration != null ? (LESSVariableDeclaration)CompletionUtil.getOriginalElement((PsiElement)parentDeclaration) : null;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 4: 
            case 5: 
            case 6: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 4: 
            case 5: 
            case 6: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "parameters";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "context";
                break;
            }
            case 2: 
            case 3: 
            case 7: {
                objectArray2 = objectArray3;
                objectArray3[0] = "result";
                break;
            }
            case 4: 
            case 5: 
            case 6: {
                objectArray2 = objectArray3;
                objectArray3[0] = "org/jetbrains/plugins/less/completion/provider/LessVariableCompletionProvider";
                break;
            }
            case 8: {
                objectArray2 = objectArray3;
                objectArray3[0] = "position";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "org/jetbrains/plugins/less/completion/provider/LessVariableCompletionProvider";
                break;
            }
            case 4: 
            case 5: 
            case 6: {
                objectArray = objectArray2;
                objectArray2[1] = "fixPrefix";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "addCompletions";
                break;
            }
            case 3: {
                objectArray = objectArray;
                objectArray[2] = "fixPrefix";
                break;
            }
            case 4: 
            case 5: 
            case 6: {
                break;
            }
            case 7: 
            case 8: {
                objectArray = objectArray;
                objectArray[2] = "addParametersVariableVariant";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 4: 
            case 5: 
            case 6: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

