/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.php.joomla.inspections;

import com.intellij.codeInspection.LocalQuickFix;
import com.intellij.codeInspection.ProblemsHolder;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiElementVisitor;
import com.intellij.psi.tree.IElementType;
import com.jetbrains.php.joomla.JoomlaBundle;
import com.jetbrains.php.joomla.settings.JoomlaDataService;
import com.jetbrains.php.lang.documentation.phpdoc.psi.PhpDocComment;
import com.jetbrains.php.lang.inspections.PhpInspection;
import com.jetbrains.php.lang.lexer.PhpTokenTypes;
import com.jetbrains.php.lang.psi.PhpFile;
import com.jetbrains.php.lang.psi.PhpPsiUtil;
import com.jetbrains.php.lang.psi.elements.GroupStatement;
import com.jetbrains.php.lang.psi.visitors.PhpElementVisitor;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class FileHeaderInspection
extends PhpInspection {
    @NotNull
    public PsiElementVisitor buildVisitor(final @NotNull ProblemsHolder holder, boolean isOnTheFly) {
        if (holder == null) {
            FileHeaderInspection.$$$reportNull$$$0(0);
        }
        PhpElementVisitor phpElementVisitor = new PhpElementVisitor(){
            JoomlaDataService service;
            final boolean serviceEnabled;
            {
                this.service = JoomlaDataService.getInstance(holder.getProject());
                this.serviceEnabled = this.service.isEnabled();
            }

            public void visitPhpFile(PhpFile phpFile) {
                this.checkFileCopyright(phpFile, holder, JoomlaBundle.message("joomla.inspection.missing.copyright.tag", new Object[0]));
                this.checkFileLicense(phpFile, holder, JoomlaBundle.message("joomla.inspection.missing.license.tag", new Object[0]));
            }

            private void checkFileLicense(PhpFile file, ProblemsHolder holder2, String message) {
                if (!this.serviceEnabled) {
                    return;
                }
                PhpDocComment docComment = FileHeaderInspection.getFileComment(file);
                if (FileHeaderInspection.isHeaderWithoutLicenseTag(docComment)) {
                    holder2.registerProblem((PsiElement)docComment, message, new LocalQuickFix[0]);
                }
            }

            private void checkFileCopyright(PhpFile file, ProblemsHolder holder2, String message) {
                if (!this.serviceEnabled) {
                    return;
                }
                PhpDocComment docComment = FileHeaderInspection.getFileComment(file);
                if (FileHeaderInspection.isHeaderWithoutCopyrightTag(docComment)) {
                    holder2.registerProblem((PsiElement)docComment, message, new LocalQuickFix[0]);
                }
            }
        };
        if (phpElementVisitor == null) {
            FileHeaderInspection.$$$reportNull$$$0(1);
        }
        return phpElementVisitor;
    }

    @Nullable
    private static PhpDocComment getFileComment(PhpFile constElement) {
        PsiElement nextSiblingIgnoreWhitespace;
        PsiElement firstChild = constElement.getFirstChild();
        if (!(firstChild instanceof GroupStatement)) {
            return null;
        }
        PsiElement firstFirstChild = firstChild.getFirstChild();
        if (PhpPsiUtil.isOfType((PsiElement)firstFirstChild, (IElementType)PhpTokenTypes.PHP_OPENING_TAG) && (nextSiblingIgnoreWhitespace = PhpPsiUtil.getNextSiblingIgnoreWhitespace((PsiElement)firstFirstChild, (boolean)true)) instanceof PhpDocComment) {
            return (PhpDocComment)nextSiblingIgnoreWhitespace;
        }
        return null;
    }

    private static boolean isHeaderWithoutCopyrightTag(@Nullable PhpDocComment docComment) {
        return docComment != null && docComment.getTagElementsByName("@copyright").length == 0;
    }

    private static boolean isHeaderWithoutLicenseTag(@Nullable PhpDocComment docComment) {
        return docComment != null && docComment.getTagElementsByName("@license").length == 0;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 1: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 1: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "holder";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/jetbrains/php/joomla/inspections/FileHeaderInspection";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/jetbrains/php/joomla/inspections/FileHeaderInspection";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[1] = "buildVisitor";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "buildVisitor";
                break;
            }
            case 1: {
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 1: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

