/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.lang.javascript.flow.lsp;

import com.intellij.codeInsight.completion.CompletionInitializationContext;
import com.intellij.codeInsight.completion.CompletionParameters;
import com.intellij.lang.javascript.flow.FlowJSServerService;
import com.intellij.lang.javascript.flow.flowconfig.FlowJSConfig;
import com.intellij.lang.javascript.flow.lsp.FlowJSHighlightingCache;
import com.intellij.lang.javascript.flow.lsp.FlowJSLanguageClient;
import com.intellij.lang.javascript.flow.lsp.FlowJSLanguageServerConnector;
import com.intellij.lang.javascript.flow.lsp.FlowJSLspService;
import com.intellij.lang.javascript.flow.lsp.FlowJSLspServiceKt;
import com.intellij.lang.javascript.integration.JSAnnotationError;
import com.intellij.lang.javascript.psi.JSElement;
import com.intellij.lang.javascript.service.JSFileHighlightingInfo;
import com.intellij.lang.javascript.service.JSHighlightingInfoBuilder;
import com.intellij.lang.javascript.service.JSLanguageServiceExecutor;
import com.intellij.lang.javascript.service.JSLanguageServiceExecutorImpl;
import com.intellij.lang.javascript.service.JSLanguageServiceQueue;
import com.intellij.lang.javascript.service.JSLanguageServiceUtil;
import com.intellij.lang.javascript.service.protocol.JSLanguageServiceConnector;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.editor.Document;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.vfs.LocalFileSystem;
import com.intellij.openapi.vfs.VfsUtil;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.psi.PsiDocumentManager;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.concurrent.Callable;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.Future;
import kotlin.Metadata;
import kotlin.Pair;
import kotlin.TuplesKt;
import kotlin.TypeCastException;
import kotlin.Unit;
import kotlin.collections.CollectionsKt;
import kotlin.collections.MapsKt;
import kotlin.jvm.internal.Intrinsics;
import org.eclipse.lsp4j.CompletionItem;
import org.eclipse.lsp4j.CompletionList;
import org.eclipse.lsp4j.Hover;
import org.eclipse.lsp4j.Location;
import org.eclipse.lsp4j.MarkedString;
import org.eclipse.lsp4j.Position;
import org.eclipse.lsp4j.Range;
import org.eclipse.lsp4j.TextDocumentIdentifier;
import org.eclipse.lsp4j.TextDocumentPositionParams;
import org.eclipse.lsp4j.jsonrpc.messages.Either;
import org.eclipse.lsp4j.services.LanguageServer;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 1, 13}, bv={1, 0, 3}, k=1, d1={"\u0000\u009e\u0001\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0000\n\u0002\u0010$\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\u0018\u00002\u00020\u0001B\u001d\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\u0006\u0010\u0006\u001a\u00020\u0007\u00a2\u0006\u0002\u0010\bJ\u0010\u0010\u0013\u001a\u00020\u00142\u0006\u0010\u0015\u001a\u00020\u0016H\u0016J\u0010\u0010\u0017\u001a\u00020\u00142\u0006\u0010\u0018\u001a\u00020\u0019H\u0016J\b\u0010\u001a\u001a\u00020\u001bH\u0014J\u001a\u0010\u001c\u001a\u0004\u0018\u00010\u001d2\u0006\u0010\u001e\u001a\u00020\u001f2\u0006\u0010 \u001a\u00020\u001dH\u0016J\u000e\u0010!\u001a\b\u0012\u0004\u0012\u00020#0\"H\u0016J4\u0010$\u001a\u000e\u0012\u0004\u0012\u00020\u0007\u0012\u0004\u0012\u00020\u00070%2\u0006\u0010&\u001a\u00020'2\u0006\u0010\u001e\u001a\u00020\u001f2\u0006\u0010(\u001a\u00020)2\u0006\u0010*\u001a\u00020\u0007H\u0016J\u0016\u0010+\u001a\b\u0012\u0004\u0012\u00020#0\"2\u0006\u0010&\u001a\u00020'H\u0016J\u001a\u0010,\u001a\u0004\u0018\u00010\u001d2\u0006\u0010\u001e\u001a\u00020\u001f2\u0006\u0010 \u001a\u00020\u001dH\u0016J \u0010-\u001a\u00020.2\u0006\u0010&\u001a\u00020'2\u0006\u0010\u001e\u001a\u00020\u001f2\u0006\u0010/\u001a\u000200H\u0002J\u0012\u00101\u001a\u0004\u0018\u00010\u00072\u0006\u0010 \u001a\u000202H\u0014J&\u00103\u001a\u0010\u0012\n\u0012\b\u0012\u0004\u0012\u00020#0\"\u0018\u0001042\u0006\u0010\u0018\u001a\u00020'2\u0006\u00105\u001a\u000206H\u0016J\u0010\u00107\u001a\u00020\u00142\u0006\u0010\u0018\u001a\u00020\u0019H\u0016R\u000e\u0010\t\u001a\u00020\nX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u000b\u001a\u00020\fX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0016\u0010\r\u001a\u0004\u0018\u00010\u000e8BX\u0082\u0004\u00a2\u0006\u0006\u001a\u0004\b\u000f\u0010\u0010R\u000e\u0010\u0011\u001a\u00020\u0012X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u00068"}, d2={"Lcom/intellij/lang/javascript/flow/lsp/FlowJSLspService;", "Lcom/intellij/lang/javascript/flow/FlowJSServerService;", "config", "Lcom/intellij/lang/javascript/flow/flowconfig/FlowJSConfig;", "project", "Lcom/intellij/openapi/project/Project;", "consoleId", "", "(Lcom/intellij/lang/javascript/flow/flowconfig/FlowJSConfig;Lcom/intellij/openapi/project/Project;Ljava/lang/String;)V", "highlightingCache", "Lcom/intellij/lang/javascript/flow/lsp/FlowJSHighlightingCache;", "languageClient", "Lcom/intellij/lang/javascript/flow/lsp/FlowJSLanguageClient;", "languageServer", "Lorg/eclipse/lsp4j/services/LanguageServer;", "getLanguageServer", "()Lorg/eclipse/lsp4j/services/LanguageServer;", "myReporter", "Lcom/intellij/lang/javascript/service/JSLanguageServiceQueue$ServiceInfoReporter;", "beforeCompletion", "", "context", "Lcom/intellij/codeInsight/completion/CompletionInitializationContext;", "closeLastEditor", "file", "Lcom/intellij/openapi/vfs/VirtualFile;", "createLanguageServiceQueue", "Lcom/intellij/lang/javascript/service/JSLanguageServiceExecutorImpl;", "findModuleOfElement", "Lcom/intellij/psi/PsiElement;", "document", "Lcom/intellij/openapi/editor/Document;", "element", "getAllErrors", "", "Lcom/intellij/lang/javascript/integration/JSAnnotationError;", "getCompletionOfElement", "", "originalFile", "Lcom/intellij/psi/PsiFile;", "parameters", "Lcom/intellij/codeInsight/completion/CompletionParameters;", "text", "getCoverageOfFile", "getDefinitionOfElement", "getPositionParams", "Lorg/eclipse/lsp4j/TextDocumentPositionParams;", "offset", "", "getTypeOfElement", "Lcom/intellij/lang/javascript/psi/JSElement;", "highlight", "Ljava/util/concurrent/Future;", "info", "Lcom/intellij/lang/javascript/service/JSFileHighlightingInfo;", "openEditor", "intellij.javascript.impl"})
public final class FlowJSLspService
extends FlowJSServerService {
    private final FlowJSHighlightingCache highlightingCache;
    private final FlowJSLanguageClient languageClient;
    private final JSLanguageServiceQueue.ServiceInfoReporter myReporter;

    private final LanguageServer getLanguageServer() {
        JSLanguageServiceExecutor jSLanguageServiceExecutor = this.getProcess();
        if (!(jSLanguageServiceExecutor instanceof JSLanguageServiceExecutorImpl)) {
            jSLanguageServiceExecutor = null;
        }
        JSLanguageServiceExecutorImpl jSLanguageServiceExecutorImpl = (JSLanguageServiceExecutorImpl)jSLanguageServiceExecutor;
        JSLanguageServiceConnector jSLanguageServiceConnector = jSLanguageServiceExecutorImpl != null ? jSLanguageServiceExecutorImpl.getProtocol() : null;
        if (jSLanguageServiceConnector == null) {
            throw new TypeCastException("null cannot be cast to non-null type com.intellij.lang.javascript.flow.lsp.FlowJSLanguageServerConnector");
        }
        return ((FlowJSLanguageServerConnector)jSLanguageServiceConnector).getServer();
    }

    @Override
    public void openEditor(@NotNull VirtualFile file2) {
        Intrinsics.checkParameterIsNotNull((Object)file2, (String)"file");
        LanguageServer languageServer = this.getLanguageServer();
        if (languageServer == null) {
            Intrinsics.throwNpe();
        }
        this.highlightingCache.openEditor(file2, languageServer);
    }

    @Override
    public void closeLastEditor(@NotNull VirtualFile file2) {
        Intrinsics.checkParameterIsNotNull((Object)file2, (String)"file");
        LanguageServer languageServer = this.getLanguageServer();
        if (languageServer == null) {
            Intrinsics.throwNpe();
        }
        this.highlightingCache.closeLastEditor(file2, languageServer);
    }

    @Override
    @Nullable
    public PsiElement getDefinitionOfElement(@NotNull Document document, @NotNull PsiElement element) {
        Intrinsics.checkParameterIsNotNull((Object)document, (String)"document");
        Intrinsics.checkParameterIsNotNull((Object)element, (String)"element");
        LanguageServer languageServer = this.getLanguageServer();
        if (languageServer == null) {
            return null;
        }
        LanguageServer server = languageServer;
        PsiFile psiFile = element.getContainingFile();
        Intrinsics.checkExpressionValueIsNotNull((Object)psiFile, (String)"element.containingFile");
        TextDocumentPositionParams positionParams = this.getPositionParams(psiFile, document, element.getTextOffset());
        CompletableFuture definitionFuture = server.getTextDocumentService().definition(positionParams);
        List list = (List)JSLanguageServiceUtil.awaitFuture(definitionFuture, FlowJSServerService.DEFINITION_TIMEOUT_MILLIS);
        if (list == null) {
            return null;
        }
        Intrinsics.checkExpressionValueIsNotNull((Object)list, (String)"JSLanguageServiceUtil.aw\u2026UT_MILLIS) ?: return null");
        List definition = list;
        if (definition.size() != 1) {
            return null;
        }
        Location location = (Location)definition.get(0);
        LocalFileSystem localFileSystem = LocalFileSystem.getInstance();
        Location location2 = location;
        Intrinsics.checkExpressionValueIsNotNull((Object)location2, (String)"location");
        VirtualFile virtualFile = localFileSystem.findFileByPath(VfsUtil.urlToPath((String)location2.getUri()));
        if (virtualFile == null) {
            return null;
        }
        Intrinsics.checkExpressionValueIsNotNull((Object)virtualFile, (String)"LocalFileSystem.getInsta\u2026tion.uri)) ?: return null");
        VirtualFile file2 = virtualFile;
        Range range = location.getRange();
        Intrinsics.checkExpressionValueIsNotNull((Object)range, (String)"location.range");
        Position position = range.getStart();
        Intrinsics.checkExpressionValueIsNotNull((Object)position, (String)"location.range.start");
        int n = position.getLine();
        Range range2 = location.getRange();
        Intrinsics.checkExpressionValueIsNotNull((Object)range2, (String)"location.range");
        Position position2 = range2.getStart();
        Intrinsics.checkExpressionValueIsNotNull((Object)position2, (String)"location.range.start");
        return this.getElementByPosition(file2, n, position2.getCharacter());
    }

    @Override
    @Nullable
    public PsiElement findModuleOfElement(@NotNull Document document, @NotNull PsiElement element) {
        Intrinsics.checkParameterIsNotNull((Object)document, (String)"document");
        Intrinsics.checkParameterIsNotNull((Object)element, (String)"element");
        return this.getDefinitionOfElement(document, element);
    }

    @Override
    @Nullable
    protected String getTypeOfElement(@NotNull JSElement element) {
        String string;
        Either either;
        Intrinsics.checkParameterIsNotNull((Object)element, (String)"element");
        LanguageServer languageServer = this.getLanguageServer();
        if (languageServer == null) {
            return null;
        }
        LanguageServer server = languageServer;
        PsiFile file2 = element.getContainingFile();
        Document document = PsiDocumentManager.getInstance((Project)this.myProject).getDocument(file2);
        if (document == null) {
            return null;
        }
        Intrinsics.checkExpressionValueIsNotNull((Object)document, (String)"PsiDocumentManager.getIn\u2026ment(file) ?: return null");
        Document document2 = document;
        PsiFile psiFile = file2;
        Intrinsics.checkExpressionValueIsNotNull((Object)psiFile, (String)"file");
        TextDocumentPositionParams positionParams = this.getPositionParams(psiFile, document2, element.getTextOffset());
        CompletableFuture hoverFuture = server.getTextDocumentService().hover(positionParams);
        Hover hover = (Hover)JSLanguageServiceUtil.awaitFuture(hoverFuture, FlowJSServerService.TYPEOF_TIMEOUT_MILLIS);
        if (hover == null) {
            return null;
        }
        Intrinsics.checkExpressionValueIsNotNull((Object)hover, (String)"JSLanguageServiceUtil.aw\u2026UT_MILLIS) ?: return null");
        Hover hover2 = hover;
        if (hover2.getContents().isEmpty()) {
            return null;
        }
        Either either2 = either = (Either)hover2.getContents().get(0);
        Intrinsics.checkExpressionValueIsNotNull((Object)either2, (String)"either");
        if (either2.getLeft() != null) {
            string = (String)either.getLeft();
        } else {
            Object object = either.getRight();
            Intrinsics.checkExpressionValueIsNotNull((Object)object, (String)"either.right");
            string = ((MarkedString)object).getValue();
        }
        return string;
    }

    @Override
    public void beforeCompletion(@NotNull CompletionInitializationContext context) {
        Intrinsics.checkParameterIsNotNull((Object)context, (String)"context");
    }

    /*
     * WARNING - void declaration
     */
    @Override
    @NotNull
    public Map<String, String> getCompletionOfElement(@NotNull PsiFile originalFile, @NotNull Document document, @NotNull CompletionParameters parameters, @NotNull String text) {
        void $receiver$iv$iv;
        Iterable $receiver$iv;
        Iterable right;
        Intrinsics.checkParameterIsNotNull((Object)originalFile, (String)"originalFile");
        Intrinsics.checkParameterIsNotNull((Object)document, (String)"document");
        Intrinsics.checkParameterIsNotNull((Object)parameters, (String)"parameters");
        Intrinsics.checkParameterIsNotNull((Object)text, (String)"text");
        LanguageServer languageServer = this.getLanguageServer();
        if (languageServer == null) {
            return MapsKt.emptyMap();
        }
        LanguageServer server = languageServer;
        TextDocumentPositionParams params = this.getPositionParams(originalFile, document, parameters.getOffset());
        CompletableFuture completionFuture = server.getTextDocumentService().completion(params);
        Either either = (Either)JSLanguageServiceUtil.awaitFuture(completionFuture, FlowJSServerService.COMPLETION_TIMEOUT_MILLIS);
        List items = CollectionsKt.emptyList();
        if (either != null) {
            List left = (List)either.getLeft();
            if (left != null) {
                items = left;
            } else {
                right = (CompletionList)either.getRight();
                if (right != null) {
                    List list = right.getItems();
                    Intrinsics.checkExpressionValueIsNotNull((Object)list, (String)"right.items");
                    items = list;
                }
            }
        }
        right = $receiver$iv = (Iterable)items;
        Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$receiver$iv, (int)10));
        for (Object item$iv$iv : $receiver$iv$iv) {
            void it;
            CompletionItem completionItem = (CompletionItem)item$iv$iv;
            Collection collection = destination$iv$iv;
            Pair pair = TuplesKt.to((Object)it.getLabel(), (Object)it.getDetail());
            collection.add(pair);
        }
        return MapsKt.toMap((Iterable)((List)destination$iv$iv));
    }

    private final TextDocumentPositionParams getPositionParams(PsiFile originalFile, Document document, int offset) {
        VirtualFile virtualFile = originalFile.getVirtualFile();
        Intrinsics.checkExpressionValueIsNotNull((Object)virtualFile, (String)"originalFile.virtualFile");
        TextDocumentIdentifier identifier = new TextDocumentIdentifier(virtualFile.getUrl());
        Position position = FlowJSLspServiceKt.getPositionByOffset(document, offset);
        return new TextDocumentPositionParams(identifier, position);
    }

    @Override
    @NotNull
    public List<JSAnnotationError> getAllErrors() {
        return this.highlightingCache.getAllHighlights();
    }

    @Override
    @NotNull
    public List<JSAnnotationError> getCoverageOfFile(@NotNull PsiFile originalFile) {
        Intrinsics.checkParameterIsNotNull((Object)originalFile, (String)"originalFile");
        return CollectionsKt.emptyList();
    }

    @Override
    @Nullable
    public Future<List<JSAnnotationError>> highlight(@NotNull PsiFile file2, @NotNull JSFileHighlightingInfo info) {
        Intrinsics.checkParameterIsNotNull((Object)file2, (String)"file");
        Intrinsics.checkParameterIsNotNull((Object)info, (String)"info");
        List<JSAnnotationError> highlights = this.highlightingCache.getHighlights(file2);
        ApplicationManager.getApplication().invokeLater(new Runnable(this, highlights){
            final /* synthetic */ FlowJSLspService this$0;
            final /* synthetic */ List $highlights;

            public final void run() {
                FlowJSLspService.access$getMyReporter$p(this.this$0).logCurrentErrors(this.$highlights);
            }
            {
                this.this$0 = flowJSLspService;
                this.$highlights = list;
            }
        });
        return CompletableFuture.completedFuture(highlights);
    }

    @Override
    @NotNull
    protected JSLanguageServiceExecutorImpl createLanguageServiceQueue() {
        FlowJSLanguageServerConnector connector = new FlowJSLanguageServerConnector(this.myProject, this.myConfig, this.languageClient);
        JSLanguageServiceExecutorImpl executor = new JSLanguageServiceExecutorImpl(this.myProject, connector, this.myProcessConnector, this.myReporter);
        executor.submit("Initializing opened files", (Callable)new Callable<Unit>(this){
            final /* synthetic */ FlowJSLspService this$0;

            public final void call() {
                ApplicationManager.getApplication().runReadAction(new Runnable(this){
                    final /* synthetic */ createLanguageServiceQueue.1 this$0;

                    public final void run() {
                        Iterable $receiver$iv = JSHighlightingInfoBuilder.getFilteredOpenedFiles(FlowJSLspService.access$getMyProject$p(this.this$0.this$0), this.this$0.this$0.getAcceptableFilesFilter()).keySet();
                        for (T element$iv : $receiver$iv) {
                            VirtualFile it = (VirtualFile)element$iv;
                            FlowJSLspService flowJSLspService = this.this$0.this$0;
                            VirtualFile virtualFile = it;
                            Intrinsics.checkExpressionValueIsNotNull((Object)virtualFile, (String)"it");
                            flowJSLspService.openEditor(virtualFile);
                        }
                    }
                    {
                        this.this$0 = var1_1;
                    }
                });
            }
            {
                this.this$0 = flowJSLspService;
            }
        });
        return executor;
    }

    public FlowJSLspService(@NotNull FlowJSConfig config2, @NotNull Project project, @NotNull String consoleId) {
        Intrinsics.checkParameterIsNotNull((Object)config2, (String)"config");
        Intrinsics.checkParameterIsNotNull((Object)project, (String)"project");
        Intrinsics.checkParameterIsNotNull((Object)consoleId, (String)"consoleId");
        super(config2, project, consoleId);
        this.highlightingCache = new FlowJSHighlightingCache(this);
        this.languageClient = new FlowJSLanguageClient(this.highlightingCache);
        JSLanguageServiceQueue.ServiceInfoReporter serviceInfoReporter = this.createDefaultReporter();
        Intrinsics.checkExpressionValueIsNotNull((Object)serviceInfoReporter, (String)"createDefaultReporter()");
        this.myReporter = serviceInfoReporter;
    }

    @NotNull
    public static final /* synthetic */ JSLanguageServiceQueue.ServiceInfoReporter access$getMyReporter$p(FlowJSLspService $this) {
        return $this.myReporter;
    }

    @NotNull
    public static final /* synthetic */ Project access$getMyProject$p(FlowJSLspService $this) {
        return $this.myProject;
    }
}

