/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.php.profiler.xdebug.model2;

import com.intellij.util.containers.WeakStringInterner;
import com.jetbrains.php.profiler.model.impl.ProfilerSourcePositionData;
import com.jetbrains.php.profiler.xdebug.model2.storage.XModelStorage;
import java.util.Objects;

public class XCallable {
    public final ProfilerSourcePositionData mySourcePosition;
    public final String myFunctionName;
    public static final XCallable UNKNOWN = new XCallable(ProfilerSourcePositionData.NULL, "UNKNOWN");
    public static final String ALL_SCRIPTS = "<All scripts>";
    public static final XCallable CALLABLE_ROOT = new XCallable(ProfilerSourcePositionData.NULL, "<All scripts>");
    static final WeakStringInterner INTERNER = new WeakStringInterner();

    private XCallable(ProfilerSourcePositionData sourcePosition, String functionName) {
        this.mySourcePosition = sourcePosition;
        this.myFunctionName = functionName;
    }

    public static XCallable createCallable(XModelStorage storage, ProfilerSourcePositionData sourcePosition, String functionName) {
        return storage.createOrGet(new XCallable(sourcePosition, INTERNER.intern(functionName)));
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        XCallable callable = (XCallable)o;
        return Objects.equals(this.mySourcePosition, callable.mySourcePosition) && Objects.equals(this.myFunctionName, callable.myFunctionName);
    }

    public int hashCode() {
        return Objects.hash(this.mySourcePosition, this.myFunctionName);
    }
}

