/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.php.refactoring.introduce.inplace;

import com.intellij.openapi.util.Condition;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiNamedElement;
import com.intellij.psi.util.PsiTreeUtil;
import com.intellij.util.ObjectUtils;
import com.intellij.util.containers.ContainerUtil;
import com.jetbrains.php.lang.PhpCodeValidationUtil;
import com.jetbrains.php.lang.PhpLangUtil;
import com.jetbrains.php.lang.psi.elements.ClassConstantReference;
import com.jetbrains.php.lang.psi.elements.ConstantReference;
import com.jetbrains.php.lang.psi.elements.PhpClass;
import com.jetbrains.php.lang.psi.elements.PhpModifier;
import com.jetbrains.php.lang.psi.elements.PhpNamedElement;
import com.jetbrains.php.lang.psi.elements.PhpReference;
import com.jetbrains.php.refactoring.PhpNameUtil;
import com.jetbrains.php.refactoring.introduce.PhpIntroduceContext;
import com.jetbrains.php.refactoring.introduce.inplace.PhpFieldInplaceIntroduceFacade;
import com.jetbrains.php.refactoring.introduce.inplace.PhpInplaceConstantInClassIntroducer;
import com.jetbrains.php.refactoring.introduce.inplace.PhpInplaceConstantInFileIntroducer;
import com.jetbrains.php.refactoring.introduce.inplace.PhpInplaceIntroduceFacade;
import com.jetbrains.php.refactoring.introduce.introduceConstant.PhpIntroduceConstantNameSuggestionProvider;
import com.jetbrains.php.refactoring.introduce.introduceConstant.PhpIntroduceConstantPresenter;
import com.jetbrains.php.refactoring.introduce.introduceConstant.PhpIntroduceConstantSettings;
import java.util.LinkedHashSet;
import java.util.Set;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class PhpConstantInplaceIntroduceFacade
implements PhpInplaceIntroduceFacade<PhpIntroduceConstantSettings> {
    private final PhpIntroduceContext myContext;
    private final LinkedHashSet<String> mySuggestedNames;
    private final Set<String> myOccupiedNames;

    public PhpConstantInplaceIntroduceFacade(@NotNull PhpIntroduceContext context) {
        if (context == null) {
            PhpConstantInplaceIntroduceFacade.$$$reportNull$$$0(0);
        }
        this.myContext = context;
        this.myOccupiedNames = ContainerUtil.map2Set(PhpIntroduceConstantPresenter.collectConstDeclarations(context), PhpNamedElement::getName);
        this.mySuggestedNames = ContainerUtil.newLinkedHashSet((Object[])new PhpIntroduceConstantNameSuggestionProvider(context, this.myOccupiedNames).getSuggestedNames());
    }

    @Override
    @NotNull
    public PhpIntroduceConstantSettings getSettings(final boolean replaceAllOccurrences) {
        final String suggestedName = (String)ContainerUtil.getFirstItem(this.mySuggestedNames);
        PhpIntroduceConstantSettings phpIntroduceConstantSettings = new PhpIntroduceConstantSettings(){

            @Override
            public PsiElement getScope() {
                return PhpConstantInplaceIntroduceFacade.this.myContext.getScope();
            }

            @Override
            @Nullable
            public PhpModifier.Access getAccess() {
                return PhpInplaceConstantInClassIntroducer.getLastSelectedAccess(PhpConstantInplaceIntroduceFacade.this.myContext.getProject());
            }

            @Override
            public boolean isDefineSyntax() {
                return !PhpCodeValidationUtil.isAllowedAsConstantValue(PhpConstantInplaceIntroduceFacade.this.myContext.getLogicalElement()) || PhpInplaceConstantInFileIntroducer.lastSelectedSyntaxIsDefine(PhpConstantInplaceIntroduceFacade.this.myContext.getProject());
            }

            @Override
            public String getName() {
                return suggestedName != null ? PhpNameUtil.unique(suggestedName, "", "", (Condition<? super String>)((Condition)str -> PhpLangUtil.isPhpReservedKeyword(str) || PhpConstantInplaceIntroduceFacade.this.myOccupiedNames.contains(str))) : "C";
            }

            @Override
            public boolean isReplaceAllOccurrences() {
                return replaceAllOccurrences;
            }
        };
        if (phpIntroduceConstantSettings == null) {
            PhpConstantInplaceIntroduceFacade.$$$reportNull$$$0(1);
        }
        return phpIntroduceConstantSettings;
    }

    @Override
    public void performInplaceIntroduce(@NotNull PsiElement introducedElement, PhpIntroduceConstantSettings settings) {
        boolean insideClass;
        PhpNamedElement constant;
        if (introducedElement == null) {
            PhpConstantInplaceIntroduceFacade.$$$reportNull$$$0(2);
        }
        if ((constant = PhpConstantInplaceIntroduceFacade.resolveConstantReferenceAtCaret(this.myContext, insideClass = this.myContext.getScope() instanceof PhpClass)) != null) {
            if (insideClass) {
                new PhpInplaceConstantInClassIntroducer(this.myContext, (PsiNamedElement)constant, settings.getAccess()).performInplaceRefactoring(this.mySuggestedNames);
            } else {
                new PhpInplaceConstantInFileIntroducer(this.myContext, (PsiNamedElement)constant, settings.isDefineSyntax()).performInplaceRefactoring(this.mySuggestedNames);
            }
        }
    }

    public static PhpNamedElement resolveConstantReferenceAtCaret(PhpIntroduceContext context, boolean insideClass) {
        PsiElement element = PhpFieldInplaceIntroduceFacade.findElementAtOffset(context);
        PhpReference reference = insideClass ? (PhpReference)PsiTreeUtil.getParentOfType((PsiElement)element, ClassConstantReference.class, (boolean)false) : (PhpReference)PsiTreeUtil.getParentOfType((PsiElement)element, ConstantReference.class, (boolean)false);
        return (PhpNamedElement)ObjectUtils.tryCast((Object)(reference != null ? reference.resolve() : null), PhpNamedElement.class);
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 1: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 1: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "context";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/jetbrains/php/refactoring/introduce/inplace/PhpConstantInplaceIntroduceFacade";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "introducedElement";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/jetbrains/php/refactoring/introduce/inplace/PhpConstantInplaceIntroduceFacade";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[1] = "getSettings";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 1: {
                break;
            }
            case 2: {
                objectArray = objectArray;
                objectArray[2] = "performInplaceIntroduce";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 1: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

