/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.php.uml;

import com.intellij.diagram.DiagramVfsResolver;
import com.intellij.openapi.application.ReadAction;
import com.intellij.openapi.project.DumbService;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.vfs.LocalFileSystem;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.psi.PsiDirectory;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiManager;
import com.intellij.psi.PsiNamedElement;
import com.jetbrains.php.PhpIndex;
import com.jetbrains.php.uml.PhpUmlUtil;
import java.util.Collection;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class PhpUmlVfsResolver
implements DiagramVfsResolver<PsiElement> {
    public String getQualifiedName(PsiElement element) {
        return PhpUmlUtil.getFQN(element);
    }

    @Nullable
    public PsiElement resolveElementByFQN(String fqn, @NotNull Project project) {
        if (project == null) {
            PhpUmlVfsResolver.$$$reportNull$$$0(0);
        }
        return (PsiElement)ReadAction.compute(() -> {
            if (project == null) {
                PhpUmlVfsResolver.$$$reportNull$$$0(1);
            }
            if (fqn == null) {
                return null;
            }
            PhpIndex phpIndex = PhpIndex.getInstance((Project)project);
            if (DumbService.isDumb((Project)project)) {
                return null;
            }
            Collection classesByFQN = phpIndex.getClassesByFQN(fqn);
            if (!classesByFQN.isEmpty()) {
                return (PsiNamedElement)classesByFQN.iterator().next();
            }
            Collection interfacesByFQN = phpIndex.getInterfacesByFQN(fqn);
            if (!interfacesByFQN.isEmpty()) {
                return (PsiNamedElement)interfacesByFQN.iterator().next();
            }
            VirtualFile byPath = LocalFileSystem.getInstance().findFileByPath(fqn);
            if (byPath != null) {
                PsiDirectory psiFile = PsiManager.getInstance((Project)project).findDirectory(byPath);
                return psiFile;
            }
            return null;
        });
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2 = new Object[3];
        objectArray2[0] = "project";
        objectArray2[1] = "com/jetbrains/php/uml/PhpUmlVfsResolver";
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[2] = "resolveElementByFQN";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[2] = "lambda$resolveElementByFQN$0";
                break;
            }
        }
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
    }
}

