/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.php.uml.providers.member;

import com.intellij.codeInsight.FileModificationService;
import com.intellij.diagram.DiagramBuilder;
import com.intellij.openapi.actionSystem.AnActionEvent;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.util.PlatformIcons;
import com.jetbrains.php.lang.psi.PhpCodeEditUtil;
import com.jetbrains.php.lang.psi.PhpPsiElementFactory;
import com.jetbrains.php.lang.psi.elements.Field;
import com.jetbrains.php.lang.psi.elements.PhpClass;
import com.jetbrains.php.uml.providers.member.CreateNewPhpFieldDialog;
import com.jetbrains.php.uml.providers.member.CreateNewPhpMember;

public class CreateNewPhpField
extends CreateNewPhpMember {
    public CreateNewPhpField() {
        super("Create New Field", PlatformIcons.FIELD_ICON);
    }

    public boolean isEnabledOn(PsiElement element) {
        PsiFile file = element.getContainingFile();
        return file != null && file.isWritable() && element instanceof PhpClass && !((PhpClass)element).isInterface();
    }

    public Runnable prepare(PsiElement element, DiagramBuilder builder) {
        CreateNewPhpFieldDialog dlg;
        if (element instanceof PhpClass && (dlg = new CreateNewPhpFieldDialog(builder.getProject(), (PhpClass)element)).showAndGet()) {
            return () -> {
                Field field = PhpPsiElementFactory.createFromText(builder.getProject(), Field.class, "class intellijrulezz {" + dlg.getNewFieldText() + "}");
                if (field != null && FileModificationService.getInstance().prepareFileForWrite(element.getContainingFile())) {
                    PhpCodeEditUtil.insertClassMember((PhpClass)element, field.getParent());
                }
            };
        }
        return null;
    }

    public void execute(DiagramBuilder builder, Runnable runnable, AnActionEvent e) {
        runnable.run();
    }

    public String getActionName() {
        return this.getTemplatePresentation().getText();
    }
}

