/*
 * Decompiled with CFR 0.152.
 */
package org.owasp.html;

import java.io.IOException;
import javax.annotation.WillCloseWhenClosed;
import org.owasp.html.Handler;
import org.owasp.html.HtmlStreamRenderer;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
final class AutoCloseableHtmlStreamRenderer
extends HtmlStreamRenderer
implements AutoCloseable {
    private final AutoCloseable closeable;

    static boolean isAutoCloseable(Object o) {
        return o instanceof AutoCloseable;
    }

    static AutoCloseableHtmlStreamRenderer createAutoCloseableHtmlStreamRenderer(@WillCloseWhenClosed Appendable output, Handler<? super IOException> errorHandler, Handler<? super String> badHtmlHandler) {
        return new AutoCloseableHtmlStreamRenderer(output, errorHandler, badHtmlHandler);
    }

    private AutoCloseableHtmlStreamRenderer(@WillCloseWhenClosed Appendable output, Handler<? super IOException> errorHandler, Handler<? super String> badHtmlHandler) {
        super(output, errorHandler, badHtmlHandler);
        this.closeable = (AutoCloseable)((Object)output);
    }

    @Override
    public void close() throws Exception {
        if (this.isDocumentOpen()) {
            this.closeDocument();
        }
        this.closeable.close();
    }
}

