/*
 * Decompiled with CFR 0.152.
 */
package org.w3c.css.values;

import org.w3c.css.util.Util;

public class RGBA {
    static final String functionname = "rgba";
    String fname;
    String output = null;
    int r;
    int g;
    int b;
    float fr;
    float fg;
    float fb;
    float a;
    boolean percent = false;

    public boolean isPercent() {
        return this.percent;
    }

    public void setPercent(boolean percent) {
        this.percent = percent;
    }

    public final void setRed(int r) {
        this.r = r;
        this.fr = r;
    }

    public final void setRed(float fr) {
        this.fr = fr;
    }

    public final void setGreen(int g) {
        this.g = g;
        this.fg = g;
    }

    public final void setGreen(float fg) {
        this.fg = fg;
    }

    public final void setBlue(int b) {
        this.b = b;
        this.fb = b;
    }

    public final void setBlue(float fb) {
        this.fb = fb;
    }

    public final void setAlpha(float a) {
        this.a = a;
    }

    public boolean equals(RGBA other) {
        if (other != null && (this.percent ? other.percent : !other.percent)) {
            return this.fr == other.fr && this.fg == other.fg && this.fb == other.fb && this.a == other.a;
        }
        return false;
    }

    public RGBA() {
        this.fname = functionname;
    }

    public RGBA(String fname) {
        this.fname = fname;
    }

    public RGBA(int r, int g, int b, float a) {
        this.r = r;
        this.g = g;
        this.b = b;
        this.a = a;
        this.percent = false;
    }

    public RGBA(float r, float g, float b, float a) {
        this.fr = r;
        this.fg = g;
        this.fb = b;
        this.a = a;
        this.percent = true;
    }

    public String toString() {
        if (this.output == null) {
            StringBuilder sb = new StringBuilder();
            sb.append(this.fname).append('(');
            if (this.isPercent()) {
                sb.append(Util.displayFloat(this.fr)).append("%, ");
                sb.append(Util.displayFloat(this.fg)).append("%, ");
                sb.append(Util.displayFloat(this.fb)).append("%, ");
            } else {
                sb.append(this.r).append(", ");
                sb.append(this.g).append(", ");
                sb.append(this.b).append(", ");
            }
            sb.append(Util.displayFloat(this.a)).append(')');
            this.output = sb.toString();
        }
        return this.output;
    }
}

