/*
 * Decompiled with CFR 0.152.
 */
package javax.swing;

import java.io.Serializable;

public class SizeRequirements
implements Serializable {
    private static final long serialVersionUID = 9217749429906736553L;
    public int minimum;
    public int preferred;
    public int maximum;
    public float alignment;

    public String toString() {
        StringBuilder b = new StringBuilder();
        b.append("<[");
        b.append(this.minimum);
        b.append(',');
        b.append(this.preferred);
        b.append(',');
        b.append(this.maximum);
        b.append("]@");
        b.append(this.alignment);
        b.append('>');
        return b.toString();
    }

    public static SizeRequirements getTiledSizeRequirements(SizeRequirements[] children) {
        SizeRequirements result = new SizeRequirements();
        int i = 0;
        while (i < children.length) {
            result.minimum += children[i].minimum;
            result.preferred += children[i].preferred;
            result.maximum += children[i].maximum;
            ++i;
        }
        return result;
    }

    public static SizeRequirements getAlignedSizeRequirements(SizeRequirements[] children) {
        float minLeft = 0.0f;
        float minRight = 0.0f;
        float prefLeft = 0.0f;
        float prefRight = 0.0f;
        float maxLeft = 0.0f;
        float maxRight = 0.0f;
        int i = 0;
        while (i < children.length) {
            float myMinLeft = (float)children[i].minimum * children[i].alignment;
            float myMinRight = (float)children[i].minimum - myMinLeft;
            minLeft = Math.max(myMinLeft, minLeft);
            minRight = Math.max(myMinRight, minRight);
            float myPrefLeft = (float)children[i].preferred * children[i].alignment;
            float myPrefRight = (float)children[i].preferred - myPrefLeft;
            prefLeft = Math.max(myPrefLeft, prefLeft);
            prefRight = Math.max(myPrefRight, prefRight);
            float myMaxLeft = (float)children[i].maximum * children[i].alignment;
            float myMaxRight = (float)children[i].maximum - myMaxLeft;
            maxLeft = Math.max(myMaxLeft, maxLeft);
            maxRight = Math.max(myMaxRight, maxRight);
            ++i;
        }
        int minSize = (int)(minLeft + minRight);
        int prefSize = (int)(prefLeft + prefRight);
        int maxSize = (int)(maxLeft + maxRight);
        float align = prefLeft / (prefRight + prefLeft);
        if (Float.isNaN(align)) {
            align = 0.0f;
        }
        return new SizeRequirements(minSize, prefSize, maxSize, align);
    }

    public static void calculateTiledPositions(int allocated, SizeRequirements total, SizeRequirements[] children, int[] offsets, int[] spans) {
        SizeRequirements.calculateTiledPositions(allocated, total, children, offsets, spans, true);
    }

    public static void calculateTiledPositions(int allocated, SizeRequirements total, SizeRequirements[] children, int[] offsets, int[] spans, boolean forward) {
        int i;
        int offset;
        int span = 0;
        if (forward) {
            offset = 0;
            i = 0;
            while (i < children.length) {
                offsets[i] = offset;
                spans[i] = children[i].preferred;
                span += spans[i];
                offset += children[i].preferred;
                ++i;
            }
        } else {
            offset = allocated;
            i = 0;
            while (i < children.length) {
                offsets[i] = offset -= children[i].preferred;
                span += spans[i];
                spans[i] = children[i].preferred;
                ++i;
            }
        }
        if (span > allocated) {
            SizeRequirements.adjustSmaller(allocated, children, spans, span);
        } else if (span < allocated) {
            SizeRequirements.adjustGreater(allocated, children, spans, span);
        }
        if (forward) {
            offset = 0;
            i = 0;
            while (i < children.length) {
                offsets[i] = offset;
                offset += spans[i];
                ++i;
            }
        } else {
            offset = allocated;
            i = 0;
            while (i < children.length) {
                offsets[i] = offset -= spans[i];
                ++i;
            }
        }
    }

    private static final void adjustSmaller(int allocated, SizeRequirements[] children, int[] spans, int span) {
        int sumDelta = 0;
        int i = 0;
        while (i < children.length) {
            sumDelta += children[i].preferred - children[i].minimum;
            ++i;
        }
        if (sumDelta == 0) {
            return;
        }
        i = 0;
        while (i < children.length) {
            double factor = (double)(children[i].preferred - children[i].minimum) / (double)sumDelta;
            if (Double.isNaN(factor)) {
                factor = 0.0;
            }
            int n = i++;
            spans[n] = (int)((double)spans[n] - factor * (double)(span - allocated));
        }
    }

    private static final void adjustGreater(int allocated, SizeRequirements[] children, int[] spans, int span) {
        int sumDelta = 0;
        int i = 0;
        while (i < children.length) {
            if ((sumDelta += children[i].maximum - children[i].preferred) < 0) {
                sumDelta = Integer.MAX_VALUE;
            }
            ++i;
        }
        if (sumDelta == 0) {
            return;
        }
        i = 0;
        while (i < children.length) {
            double factor = (double)(children[i].maximum - children[i].preferred) / (double)sumDelta;
            int n = i++;
            spans[n] = (int)((double)spans[n] - factor * (double)(span - allocated));
        }
    }

    public static void calculateAlignedPositions(int allocated, SizeRequirements total, SizeRequirements[] children, int[] offsets, int[] spans) {
        SizeRequirements.calculateAlignedPositions(allocated, total, children, offsets, spans, true);
    }

    public static void calculateAlignedPositions(int allocated, SizeRequirements total, SizeRequirements[] children, int[] offset, int[] spans, boolean forward) {
        float baseline = (float)allocated * total.alignment;
        int i = 0;
        while (i < children.length) {
            float align = children[i].alignment;
            int[] spanAndOffset = new int[2];
            if (align < 0.5f || baseline == 0.0f) {
                SizeRequirements.adjustFromRight(children[i], baseline, allocated, spanAndOffset);
            } else {
                SizeRequirements.adjustFromLeft(children[i], baseline, allocated, spanAndOffset);
            }
            spans[i] = spanAndOffset[0];
            offset[i] = spanAndOffset[1];
            ++i;
        }
    }

    private static final void adjustFromRight(SizeRequirements reqs, float baseline, int allocated, int[] spanAndOffset) {
        float right = (float)allocated - baseline;
        float maxRight = (float)reqs.maximum * (1.0f - reqs.alignment);
        if (right / (1.0f - reqs.alignment) > (float)reqs.maximum) {
            right = maxRight;
        }
        if (right / (1.0f - reqs.alignment) * reqs.alignment > (float)allocated - baseline) {
            right = ((float)allocated - baseline) / reqs.alignment * (1.0f - reqs.alignment);
        }
        spanAndOffset[0] = (int)(right / (1.0f - reqs.alignment));
        spanAndOffset[1] = (int)(baseline - (float)spanAndOffset[0] * reqs.alignment);
    }

    private static final void adjustFromLeft(SizeRequirements reqs, float baseline, int allocated, int[] spanAndOffset) {
        float left = baseline;
        float maxLeft = (float)reqs.maximum * reqs.alignment;
        if (left / reqs.alignment > (float)reqs.maximum) {
            left = maxLeft;
        }
        if (left / reqs.alignment * (1.0f - reqs.alignment) > (float)allocated - baseline) {
            left = ((float)allocated - baseline) / (1.0f - reqs.alignment) * reqs.alignment;
        }
        spanAndOffset[0] = (int)(left / reqs.alignment);
        spanAndOffset[1] = (int)(baseline - (float)spanAndOffset[0] * reqs.alignment);
    }

    public static int[] adjustSizes(int delta, SizeRequirements[] children) {
        return null;
    }

    public SizeRequirements() {
        this(0, 0, 0, 0.5f);
    }

    public SizeRequirements(int min, int pref, int max, float align) {
        this.minimum = min;
        this.preferred = pref;
        this.maximum = max;
        this.alignment = align;
    }
}

