/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ivy.core.repository;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Comparator;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.TreeSet;
import org.apache.ivy.core.module.descriptor.DefaultDependencyDescriptor;
import org.apache.ivy.core.module.descriptor.DependencyDescriptor;
import org.apache.ivy.core.module.descriptor.ModuleDescriptor;
import org.apache.ivy.core.module.id.ModuleRevisionId;
import org.apache.ivy.core.repository.RepositoryManagementEngineSettings;
import org.apache.ivy.core.resolve.ResolveData;
import org.apache.ivy.core.resolve.ResolveEngine;
import org.apache.ivy.core.resolve.ResolveOptions;
import org.apache.ivy.core.resolve.ResolvedModuleRevision;
import org.apache.ivy.core.search.SearchEngine;
import org.apache.ivy.plugins.latest.ArtifactInfo;
import org.apache.ivy.plugins.matcher.PatternMatcher;
import org.apache.ivy.plugins.matcher.RegexpPatternMatcher;
import org.apache.ivy.plugins.version.VersionMatcher;
import org.apache.ivy.util.MemoryUtil;
import org.apache.ivy.util.Message;

public class RepositoryManagementEngine {
    private static final double THOUSAND = 1000.0;
    private static final int KILO = 1024;
    private boolean loaded;
    private Map revisions = new HashMap();
    private Map errors = new HashMap();
    private Map modules = new HashMap();
    private boolean analyzed;
    private Map cache = new HashMap();
    private Map dependers = new HashMap();
    private SearchEngine searchEngine;
    private ResolveEngine resolveEngine;
    private RepositoryManagementEngineSettings settings;

    public RepositoryManagementEngine(RepositoryManagementEngineSettings repositoryManagementEngineSettings, SearchEngine searchEngine, ResolveEngine resolveEngine) {
        this.settings = repositoryManagementEngineSettings;
        this.searchEngine = searchEngine;
        this.resolveEngine = resolveEngine;
    }

    public void load() {
        long l = 0L;
        if (this.settings.dumpMemoryUsage()) {
            l = MemoryUtil.getUsedMemory();
        }
        long l2 = System.currentTimeMillis();
        Message.rawinfo("searching modules... ");
        ModuleRevisionId[] moduleRevisionIdArray = this.searchModules();
        Message.info("loading repository metadata...");
        for (int i = 0; i < moduleRevisionIdArray.length; ++i) {
            try {
                this.loadModuleRevision(moduleRevisionIdArray[i]);
                continue;
            }
            catch (Exception exception) {
                this.errors.put(moduleRevisionIdArray[i], exception.getMessage());
            }
        }
        long l3 = System.currentTimeMillis();
        Message.info("\nrepository loaded: " + this.modules.size() + " modules; " + this.revisions.size() + " revisions; " + (this.settings.dumpMemoryUsage() ? (MemoryUtil.getUsedMemory() - l) / 1024L + "kB; " : "") + (double)(l3 - l2) / 1000.0 + "s");
        this.loaded = true;
    }

    public void analyze() {
        this.ensureLoaded();
        Message.info("\nanalyzing dependencies...");
        for (ModuleDescriptor moduleDescriptor : this.revisions.values()) {
            DependencyDescriptor[] dependencyDescriptorArray = moduleDescriptor.getDependencies();
            for (int i = 0; i < dependencyDescriptorArray.length; ++i) {
                ModuleRevisionId moduleRevisionId = this.getDependency(dependencyDescriptorArray[i]);
                if (moduleRevisionId == null) {
                    Message.warn("inconsistent repository: declared dependency not found: " + dependencyDescriptorArray[i]);
                    continue;
                }
                this.getDependers(moduleRevisionId).add(moduleDescriptor.getModuleRevisionId());
            }
            Message.progress();
        }
        this.analyzed = true;
    }

    public int getRevisionsNumber() {
        this.ensureLoaded();
        return this.revisions.size();
    }

    public int getModuleIdsNumber() {
        this.ensureLoaded();
        return this.modules.size();
    }

    public Collection getOrphans() {
        this.ensureAnalyzed();
        HashSet hashSet = new HashSet(this.revisions.keySet());
        hashSet.removeAll(this.dependers.keySet());
        return hashSet;
    }

    private ModuleRevisionId[] searchModules() {
        ModuleRevisionId[] moduleRevisionIdArray = this.searchEngine.listModules(ModuleRevisionId.newInstance("*", "*", "*", "*"), (PatternMatcher)RegexpPatternMatcher.INSTANCE);
        return moduleRevisionIdArray;
    }

    private ModuleRevisionId getDependency(DependencyDescriptor dependencyDescriptor) {
        ModuleRevisionId moduleRevisionId = dependencyDescriptor.getDependencyRevisionId();
        VersionMatcher versionMatcher = this.settings.getVersionMatcher();
        if (versionMatcher.isDynamic(moduleRevisionId)) {
            ModuleRevisionId moduleRevisionId2 = (ModuleRevisionId)this.cache.get(moduleRevisionId);
            if (moduleRevisionId2 == null) {
                Collection collection = this.getAllRevisions(moduleRevisionId);
                for (ModuleDescriptor moduleDescriptor : collection) {
                    if (versionMatcher.needModuleDescriptor(moduleRevisionId, moduleDescriptor.getResolvedModuleRevisionId())) {
                        if (!versionMatcher.accept(moduleRevisionId, moduleDescriptor)) continue;
                        moduleRevisionId2 = moduleDescriptor.getResolvedModuleRevisionId();
                        break;
                    }
                    if (!versionMatcher.accept(moduleRevisionId, moduleDescriptor.getResolvedModuleRevisionId())) continue;
                    moduleRevisionId2 = moduleDescriptor.getResolvedModuleRevisionId();
                    break;
                }
                if (moduleRevisionId2 == null) {
                    return null;
                }
                this.cache.put(moduleRevisionId, moduleRevisionId2);
            }
            return moduleRevisionId2;
        }
        return moduleRevisionId;
    }

    private Collection getDependers(ModuleRevisionId moduleRevisionId) {
        ArrayList arrayList = (ArrayList)this.dependers.get(moduleRevisionId);
        if (arrayList == null) {
            arrayList = new ArrayList();
            this.dependers.put(moduleRevisionId, arrayList);
        }
        return arrayList;
    }

    private void loadModuleRevision(ModuleRevisionId moduleRevisionId) throws Exception {
        ResolvedModuleRevision resolvedModuleRevision = this.settings.getResolver(moduleRevisionId).getDependency(new DefaultDependencyDescriptor(moduleRevisionId, false), this.newResolveData());
        if (resolvedModuleRevision == null) {
            Message.warn("module not found while listed: " + moduleRevisionId);
        } else {
            this.revisions.put(resolvedModuleRevision.getId(), resolvedModuleRevision.getDescriptor());
            this.getAllRevisions(resolvedModuleRevision.getId()).add(resolvedModuleRevision.getDescriptor());
        }
        Message.progress();
    }

    private Collection getAllRevisions(ModuleRevisionId moduleRevisionId) {
        TreeSet treeSet = (TreeSet)this.modules.get(moduleRevisionId.getModuleId());
        if (treeSet == null) {
            treeSet = new TreeSet(new Comparator(){

                public int compare(Object object, Object object2) {
                    ModuleDescriptor moduleDescriptor = (ModuleDescriptor)object;
                    ModuleDescriptor moduleDescriptor2 = (ModuleDescriptor)object2;
                    return RepositoryManagementEngine.this.settings.getDefaultLatestStrategy().sort(new ArtifactInfo[]{moduleDescriptor, moduleDescriptor2}).get(0).equals(moduleDescriptor) ? 1 : -1;
                }
            });
            this.modules.put(moduleRevisionId.getModuleId(), treeSet);
        }
        return treeSet;
    }

    private ResolveData newResolveData() {
        return new ResolveData(this.resolveEngine, new ResolveOptions());
    }

    private void ensureAnalyzed() {
        if (!this.analyzed) {
            throw new IllegalStateException("repository must have been analyzed to perform this method");
        }
    }

    private void ensureLoaded() {
        if (!this.loaded) {
            throw new IllegalStateException("repository must have be loaded to perform this method");
        }
    }
}

