/*
 * Decompiled with CFR 0.152.
 */
package org.apache.zookeeper.graph;

import java.util.Iterator;
import java.util.LinkedList;
import java.util.NoSuchElementException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class LogSkipList {
    private static final Logger LOG = LoggerFactory.getLogger(LogSkipList.class);
    private LinkedList<Mark> marks;

    public LogSkipList() {
        if (LOG.isTraceEnabled()) {
            LOG.trace("New skip list");
        }
        this.marks = new LinkedList();
    }

    public void addMark(long time, long bytes, long skipped) {
        if (LOG.isTraceEnabled()) {
            LOG.trace("addMark (time:" + time + ", bytes: " + bytes + ", skipped: " + skipped + ")");
        }
        this.marks.add(new Mark(time, bytes, skipped));
    }

    public Mark findMarkBefore(long time) throws NoSuchElementException {
        Mark m;
        if (LOG.isTraceEnabled()) {
            LOG.trace("findMarkBefore(" + time + ")");
        }
        Mark last = this.marks.getFirst();
        Iterator iterator = this.marks.iterator();
        while (iterator.hasNext() && (m = (Mark)iterator.next()).getTime() <= time) {
            last = m;
        }
        if (LOG.isTraceEnabled()) {
            LOG.trace("return " + last);
        }
        return last;
    }

    public class Mark {
        private long time;
        private long bytes;
        private long skipped;

        public Mark(long time, long bytes, long skipped) {
            this.time = time;
            this.bytes = bytes;
            this.skipped = skipped;
        }

        public long getTime() {
            return this.time;
        }

        public long getBytes() {
            return this.bytes;
        }

        public long getEntriesSkipped() {
            return this.skipped;
        }

        public String toString() {
            return "Mark(time=" + this.time + ", bytes=" + this.bytes + ", skipped=" + this.skipped + ")";
        }
    }
}

