/*
 * Decompiled with CFR 0.152.
 */
package com.sun.grizzly.filter;

import com.sun.grizzly.BaseSelectionKeyHandler;
import com.sun.grizzly.Context;
import com.sun.grizzly.Controller;
import com.sun.grizzly.ProtocolChain;
import com.sun.grizzly.ProtocolFilter;
import com.sun.grizzly.ReinvokeAware;
import com.sun.grizzly.SelectionKeyHandler;
import com.sun.grizzly.SelectorHandler;
import com.sun.grizzly.util.WorkerThread;
import java.io.IOException;
import java.net.SocketAddress;
import java.nio.ByteBuffer;
import java.nio.channels.DatagramChannel;
import java.nio.channels.SelectionKey;
import java.nio.channels.SocketChannel;
import java.util.logging.Level;

public class ReadFilter
implements ProtocolFilter,
ReinvokeAware {
    public static final String UDP_SOCKETADDRESS = "socketAddress";
    protected boolean continousExecution = false;
    protected int readAttempts = 3;

    public boolean execute(Context ctx) throws IOException {
        return this.execute(ctx, null);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    protected boolean execute(Context ctx, ByteBuffer byteBuffer) throws IOException {
        if (ctx.getCurrentOpType() == Context.OpType.OP_WRITE) {
            if (!Controller.logger().isLoggable(Level.FINE)) return false;
            Controller.logger().fine("ReadFilter cannont handle OP_WRITE");
            return false;
        }
        if (byteBuffer == null) {
            byteBuffer = ((WorkerThread)Thread.currentThread()).getByteBuffer();
        }
        if (!byteBuffer.hasRemaining()) {
            throw new IllegalStateException("ByteBuffer is full: " + byteBuffer);
        }
        boolean invokeNextFilter = true;
        int count = -1;
        SocketAddress socketAddress = null;
        Exception exception = null;
        SelectionKey key = ctx.getSelectionKey();
        Controller.Protocol protocol = ctx.getProtocol();
        try {
            block31: {
                try {
                    int loop = 0;
                    if (protocol == Controller.Protocol.TCP || protocol == Controller.Protocol.TLS) {
                        SocketChannel channel = (SocketChannel)key.channel();
                        while ((count = channel.read(byteBuffer)) == 0) {
                            if (++loop < this.readAttempts) continue;
                            if (ctx.getKeyRegistrationState() != Context.KeyRegistrationState.NONE) {
                                ctx.setAttribute("succes_read", Boolean.FALSE);
                                invokeNextFilter = false;
                            }
                            break block31;
                        }
                        break block31;
                    }
                    if (protocol != Controller.Protocol.UDP) break block31;
                    DatagramChannel datagramChannel = (DatagramChannel)key.channel();
                    socketAddress = datagramChannel.receive(byteBuffer);
                    ctx.getSelectorHandler().register(key, 1);
                }
                catch (IOException ex) {
                    exception = ex;
                    this.log("ReadFilter.execute", ex);
                    Object var12_15 = null;
                    SelectionKeyHandler skh222 = ctx.getSelectorHandler().getSelectionKeyHandler();
                    if (skh222 instanceof BaseSelectionKeyHandler) {
                        ((WorkerThread)Thread.currentThread()).getAttachment().setAttribute("ConnectionCloseHandler", (Object)((BaseSelectionKeyHandler)skh222).getConnectionCloseHandler());
                    }
                    if (exception != null) {
                        ctx.setAttribute("throwable", exception);
                        if (protocol != Controller.Protocol.UDP) {
                            ctx.setKeyRegistrationState(Context.KeyRegistrationState.CANCEL);
                        }
                        invokeNextFilter = false;
                        if (!(skh222 instanceof BaseSelectionKeyHandler)) return invokeNextFilter;
                        ((BaseSelectionKeyHandler)skh222).notifyRemotlyClose(key);
                        return invokeNextFilter;
                    }
                    if (count == -1 && protocol != Controller.Protocol.UDP) {
                        ctx.setKeyRegistrationState(Context.KeyRegistrationState.CANCEL);
                        invokeNextFilter = false;
                        if (!(skh222 instanceof BaseSelectionKeyHandler)) return invokeNextFilter;
                        ((BaseSelectionKeyHandler)skh222).notifyRemotlyClose(key);
                        return invokeNextFilter;
                    }
                    if (socketAddress == null && protocol == Controller.Protocol.UDP) {
                        ctx.setKeyRegistrationState(Context.KeyRegistrationState.REGISTER);
                        return false;
                    }
                    if (protocol != Controller.Protocol.UDP) return invokeNextFilter;
                    ctx.setAttribute(UDP_SOCKETADDRESS, socketAddress);
                    return invokeNextFilter;
                }
                catch (RuntimeException ex) {
                    exception = ex;
                    this.log("ReadFilter.execute", ex);
                    Object var12_16 = null;
                    SelectionKeyHandler skh222 = ctx.getSelectorHandler().getSelectionKeyHandler();
                    if (skh222 instanceof BaseSelectionKeyHandler) {
                        ((WorkerThread)Thread.currentThread()).getAttachment().setAttribute("ConnectionCloseHandler", (Object)((BaseSelectionKeyHandler)skh222).getConnectionCloseHandler());
                    }
                    if (exception != null) {
                        ctx.setAttribute("throwable", exception);
                        if (protocol != Controller.Protocol.UDP) {
                            ctx.setKeyRegistrationState(Context.KeyRegistrationState.CANCEL);
                        }
                        invokeNextFilter = false;
                        if (!(skh222 instanceof BaseSelectionKeyHandler)) return invokeNextFilter;
                        ((BaseSelectionKeyHandler)skh222).notifyRemotlyClose(key);
                        return invokeNextFilter;
                    }
                    if (count == -1 && protocol != Controller.Protocol.UDP) {
                        ctx.setKeyRegistrationState(Context.KeyRegistrationState.CANCEL);
                        invokeNextFilter = false;
                        if (!(skh222 instanceof BaseSelectionKeyHandler)) return invokeNextFilter;
                        ((BaseSelectionKeyHandler)skh222).notifyRemotlyClose(key);
                        return invokeNextFilter;
                    }
                    if (socketAddress == null && protocol == Controller.Protocol.UDP) {
                        ctx.setKeyRegistrationState(Context.KeyRegistrationState.REGISTER);
                        return false;
                    }
                    if (protocol != Controller.Protocol.UDP) return invokeNextFilter;
                    ctx.setAttribute(UDP_SOCKETADDRESS, socketAddress);
                    return invokeNextFilter;
                }
            }
            Object var12_14 = null;
            SelectionKeyHandler skh222 = ctx.getSelectorHandler().getSelectionKeyHandler();
            if (skh222 instanceof BaseSelectionKeyHandler) {
                ((WorkerThread)Thread.currentThread()).getAttachment().setAttribute("ConnectionCloseHandler", (Object)((BaseSelectionKeyHandler)skh222).getConnectionCloseHandler());
            }
            if (exception != null) {
                ctx.setAttribute("throwable", exception);
                if (protocol != Controller.Protocol.UDP) {
                    ctx.setKeyRegistrationState(Context.KeyRegistrationState.CANCEL);
                }
                invokeNextFilter = false;
                if (!(skh222 instanceof BaseSelectionKeyHandler)) return invokeNextFilter;
                ((BaseSelectionKeyHandler)skh222).notifyRemotlyClose(key);
                return invokeNextFilter;
            }
            if (count == -1 && protocol != Controller.Protocol.UDP) {
                ctx.setKeyRegistrationState(Context.KeyRegistrationState.CANCEL);
                invokeNextFilter = false;
                if (!(skh222 instanceof BaseSelectionKeyHandler)) return invokeNextFilter;
                ((BaseSelectionKeyHandler)skh222).notifyRemotlyClose(key);
                return invokeNextFilter;
            }
            if (socketAddress == null && protocol == Controller.Protocol.UDP) {
                ctx.setKeyRegistrationState(Context.KeyRegistrationState.REGISTER);
                return false;
            }
            if (protocol != Controller.Protocol.UDP) return invokeNextFilter;
            ctx.setAttribute(UDP_SOCKETADDRESS, socketAddress);
            return invokeNextFilter;
        }
        catch (Throwable throwable) {
            Object var12_17 = null;
            SelectionKeyHandler skh222 = ctx.getSelectorHandler().getSelectionKeyHandler();
            if (skh222 instanceof BaseSelectionKeyHandler) {
                ((WorkerThread)Thread.currentThread()).getAttachment().setAttribute("ConnectionCloseHandler", (Object)((BaseSelectionKeyHandler)skh222).getConnectionCloseHandler());
            }
            if (exception != null) {
                ctx.setAttribute("throwable", exception);
                if (protocol != Controller.Protocol.UDP) {
                    ctx.setKeyRegistrationState(Context.KeyRegistrationState.CANCEL);
                }
                invokeNextFilter = false;
                if (!(skh222 instanceof BaseSelectionKeyHandler)) throw throwable;
                ((BaseSelectionKeyHandler)skh222).notifyRemotlyClose(key);
                throw throwable;
            }
            if (count == -1 && protocol != Controller.Protocol.UDP) {
                ctx.setKeyRegistrationState(Context.KeyRegistrationState.CANCEL);
                invokeNextFilter = false;
                if (!(skh222 instanceof BaseSelectionKeyHandler)) throw throwable;
                ((BaseSelectionKeyHandler)skh222).notifyRemotlyClose(key);
                throw throwable;
            }
            if (socketAddress == null && protocol == Controller.Protocol.UDP) {
                ctx.setKeyRegistrationState(Context.KeyRegistrationState.REGISTER);
                invokeNextFilter = false;
                throw throwable;
            }
            if (protocol != Controller.Protocol.UDP) throw throwable;
            ctx.setAttribute(UDP_SOCKETADDRESS, socketAddress);
            throw throwable;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean postExecute(Context ctx) throws IOException {
        boolean isReinvoke;
        Context.KeyRegistrationState state;
        SelectionKey key;
        SelectorHandler selectorHandler;
        block8: {
            boolean bl;
            selectorHandler = ctx.getSelectorHandler();
            key = ctx.getSelectionKey();
            state = ctx.getKeyRegistrationState();
            Controller.Protocol protocol = ctx.getProtocol();
            try {
                if (protocol != Controller.Protocol.UDP) break block8;
                bl = true;
                Object var10_8 = null;
                ctx.removeAttribute("throwable");
            }
            catch (Throwable throwable) {
                Object var10_10 = null;
                ctx.removeAttribute("throwable");
                ctx.removeAttribute(UDP_SOCKETADDRESS);
                throw throwable;
            }
            ctx.removeAttribute(UDP_SOCKETADDRESS);
            return bl;
        }
        ProtocolChain protocolChain = ctx.getProtocolChain();
        boolean bl = isReinvoke = this.continousExecution && protocolChain instanceof ReinvokeAware && ((ReinvokeAware)((Object)protocolChain)).isContinuousExecution();
        if (isReinvoke && state == Context.KeyRegistrationState.REGISTER && Boolean.FALSE != (Boolean)ctx.getAttribute("succes_read")) {
            ctx.setAttribute("succes_read", Boolean.TRUE);
        } else if (state == Context.KeyRegistrationState.CANCEL) {
            selectorHandler.getSelectionKeyHandler().cancel(key);
        } else if (state == Context.KeyRegistrationState.REGISTER) {
            selectorHandler.register(key, 1);
        }
        boolean bl2 = true;
        Object var10_9 = null;
        ctx.removeAttribute("throwable");
        ctx.removeAttribute(UDP_SOCKETADDRESS);
        return bl2;
    }

    public void setContinuousExecution(boolean continousExecution) {
        this.continousExecution = continousExecution;
    }

    public boolean isContinuousExecution() {
        return this.continousExecution;
    }

    public int getReadAttempts() {
        return this.readAttempts;
    }

    public void setReadAttempts(int readAttempts) {
        if (readAttempts < 1) {
            throw new IllegalArgumentException("The readAttempts parameter should be >= 1");
        }
        this.readAttempts = readAttempts;
    }

    protected void log(String msg, Throwable t) {
        if (Controller.logger().isLoggable(Level.FINE)) {
            Controller.logger().log(Level.FINE, msg, t);
        }
    }
}

