/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cassandra.service.paxos;

import java.io.IOException;
import java.util.UUID;
import org.apache.cassandra.db.TypeSizes;
import org.apache.cassandra.db.partitions.PartitionUpdate;
import org.apache.cassandra.db.rows.SerializationHelper;
import org.apache.cassandra.io.IVersionedSerializer;
import org.apache.cassandra.io.util.DataInputPlus;
import org.apache.cassandra.io.util.DataOutputPlus;
import org.apache.cassandra.service.paxos.Commit;
import org.apache.cassandra.utils.UUIDSerializer;

public class PrepareResponse {
    public static final PrepareResponseSerializer serializer = new PrepareResponseSerializer();
    public final boolean promised;
    public final Commit inProgressCommit;
    public final Commit mostRecentCommit;

    public PrepareResponse(boolean promised, Commit inProgressCommit, Commit mostRecentCommit) {
        assert (inProgressCommit.update.partitionKey().equals(mostRecentCommit.update.partitionKey()));
        assert (inProgressCommit.update.metadata() == mostRecentCommit.update.metadata());
        this.promised = promised;
        this.mostRecentCommit = mostRecentCommit;
        this.inProgressCommit = inProgressCommit;
    }

    public String toString() {
        return String.format("PrepareResponse(%s, %s, %s)", this.promised, this.mostRecentCommit, this.inProgressCommit);
    }

    public static class PrepareResponseSerializer
    implements IVersionedSerializer<PrepareResponse> {
        @Override
        public void serialize(PrepareResponse response, DataOutputPlus out, int version) throws IOException {
            out.writeBoolean(response.promised);
            Commit.serializer.serialize(response.inProgressCommit, out, version);
            if (version < 10) {
                UUIDSerializer.serializer.serialize(response.mostRecentCommit.ballot, out, version);
                PartitionUpdate.serializer.serialize(response.mostRecentCommit.update, out, version);
            } else {
                Commit.serializer.serialize(response.mostRecentCommit, out, version);
            }
        }

        @Override
        public PrepareResponse deserialize(DataInputPlus in, int version) throws IOException {
            Commit mostRecent;
            boolean success = in.readBoolean();
            Commit inProgress = Commit.serializer.deserialize(in, version);
            if (version < 10) {
                UUID ballot = UUIDSerializer.serializer.deserialize(in, version);
                PartitionUpdate update = PartitionUpdate.serializer.deserialize(in, version, SerializationHelper.Flag.LOCAL, inProgress.update.partitionKey());
                mostRecent = new Commit(ballot, update);
            } else {
                mostRecent = Commit.serializer.deserialize(in, version);
            }
            return new PrepareResponse(success, inProgress, mostRecent);
        }

        @Override
        public long serializedSize(PrepareResponse response, int version) {
            long size = (long)TypeSizes.sizeof(response.promised) + Commit.serializer.serializedSize(response.inProgressCommit, version);
            if (version < 10) {
                size += UUIDSerializer.serializer.serializedSize(response.mostRecentCommit.ballot, version);
                size += PartitionUpdate.serializer.serializedSize(response.mostRecentCommit.update, version);
            } else {
                size += Commit.serializer.serializedSize(response.mostRecentCommit, version);
            }
            return size;
        }
    }
}

