/*
 * Decompiled with CFR 0.152.
 */
package org.trie4j.tail.index;

import java.io.Externalizable;
import java.io.IOException;
import java.io.ObjectInput;
import java.io.ObjectOutput;
import org.trie4j.bv.BytesSuccinctBitVector;
import org.trie4j.bv.SuccinctBitVector;
import org.trie4j.tail.index.SBVTailIndex;
import org.trie4j.tail.index.TailIndex;
import org.trie4j.tail.index.TailIndexBuilder;

public class SBVTailIndexAppendingBuilder
implements Externalizable,
TailIndexBuilder {
    private int current;
    private SuccinctBitVector sbv;
    private static final long serialVersionUID = 8843853578097509573L;

    public SBVTailIndexAppendingBuilder() {
        this.sbv = new BytesSuccinctBitVector();
    }

    public SBVTailIndexAppendingBuilder(int initialCapacity) {
        this.sbv = new BytesSuccinctBitVector(initialCapacity);
    }

    public SuccinctBitVector getSbv() {
        return this.sbv;
    }

    @Override
    public void add(int nodeId, int start, int end) {
        if (nodeId != this.current) {
            throw new IllegalArgumentException("nodeId must be a strictly increasing.");
        }
        for (int i = start; i < end; ++i) {
            this.sbv.append1();
        }
        this.sbv.append0();
        ++this.current;
    }

    @Override
    public void addEmpty(int nodeId) {
        if (nodeId != this.current) {
            throw new IllegalArgumentException("nodeId must be a strictly increasing.");
        }
        this.sbv.append0();
        ++this.current;
    }

    @Override
    public void trimToSize() {
    }

    @Override
    public TailIndex build() {
        return new SBVTailIndex(this.sbv, this.current);
    }

    @Override
    public void readExternal(ObjectInput in) throws ClassNotFoundException, IOException {
        this.current = in.readInt();
        this.sbv = (SuccinctBitVector)in.readObject();
    }

    @Override
    public void writeExternal(ObjectOutput out) throws IOException {
        out.writeInt(this.current);
        out.writeObject(this.sbv);
    }
}

