/*
 * Decompiled with CFR 0.152.
 */
package org.apache.catalina.filters;

import java.io.IOException;
import java.util.Enumeration;
import javax.servlet.Filter;
import javax.servlet.FilterChain;
import javax.servlet.FilterConfig;
import javax.servlet.ServletException;
import javax.servlet.ServletRequest;
import javax.servlet.ServletResponse;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.tomcat.util.res.StringManager;

public class SetCharacterEncodingFilter
implements Filter {
    private static final Log log = LogFactory.getLog((Class)SetCharacterEncodingFilter.class);
    protected static final StringManager sm = StringManager.getManager((String)"org.apache.catalina.filters");
    private String encoding = null;
    private boolean ignore = false;

    public void setEncoding(String encoding) {
        this.encoding = encoding;
    }

    public String getEncoding() {
        return this.encoding;
    }

    public void setIgnore(boolean ignore) {
        this.ignore = ignore;
    }

    public boolean isIgnore() {
        return this.ignore;
    }

    public void init(FilterConfig filterConfig) throws ServletException {
        Enumeration paramNames = filterConfig.getInitParameterNames();
        while (paramNames.hasMoreElements()) {
            String paramName = (String)paramNames.nextElement();
            if ("encoding".equals(paramName)) {
                this.setEncoding(filterConfig.getInitParameter(paramName));
                continue;
            }
            if ("ignore".equals(paramName)) {
                this.setIgnore(Boolean.valueOf(filterConfig.getInitParameter(paramName)));
                continue;
            }
            String msg = sm.getString("filterbase.noSuchProperty", (Object)paramName, (Object)this.getClass().getName());
            log.warn((Object)msg);
        }
    }

    public void destroy() {
    }

    public void doFilter(ServletRequest request, ServletResponse response, FilterChain chain) throws IOException, ServletException {
        String characterEncoding;
        if ((this.ignore || request.getCharacterEncoding() == null) && (characterEncoding = this.selectEncoding(request)) != null) {
            request.setCharacterEncoding(characterEncoding);
        }
        chain.doFilter(request, response);
    }

    protected String selectEncoding(ServletRequest request) {
        return this.encoding;
    }
}

