/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.xpack.sql.expression;

import java.util.List;
import java.util.Objects;
import org.elasticsearch.xpack.sql.expression.Attribute;
import org.elasticsearch.xpack.sql.expression.Expression;
import org.elasticsearch.xpack.sql.expression.ExpressionId;
import org.elasticsearch.xpack.sql.expression.gen.pipeline.AttributeInput;
import org.elasticsearch.xpack.sql.expression.gen.pipeline.ConstantInput;
import org.elasticsearch.xpack.sql.expression.gen.pipeline.Pipe;
import org.elasticsearch.xpack.sql.expression.gen.script.ScriptTemplate;
import org.elasticsearch.xpack.sql.tree.Source;

public abstract class NamedExpression
extends Expression {
    private final String name;
    private final ExpressionId id;
    private final boolean synthetic;
    private Pipe lazyPipe = null;

    public NamedExpression(Source source, String name, List<Expression> children, ExpressionId id) {
        this(source, name, children, id, false);
    }

    public NamedExpression(Source source, String name, List<Expression> children, ExpressionId id, boolean synthetic) {
        super(source, children);
        this.name = name;
        this.id = id == null ? new ExpressionId() : id;
        this.synthetic = synthetic;
    }

    public String name() {
        return this.name;
    }

    public ExpressionId id() {
        return this.id;
    }

    public boolean synthetic() {
        return this.synthetic;
    }

    public abstract Attribute toAttribute();

    public Pipe asPipe() {
        if (this.lazyPipe == null) {
            this.lazyPipe = this.foldable() ? new ConstantInput(this.source(), (Expression)this, this.fold()) : this.makePipe();
        }
        return this.lazyPipe;
    }

    protected Pipe makePipe() {
        return new AttributeInput(this.source(), (Expression)this, this.toAttribute());
    }

    public abstract ScriptTemplate asScript();

    @Override
    public int hashCode() {
        return Objects.hash(super.hashCode(), this.name, this.synthetic);
    }

    @Override
    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null || this.getClass() != obj.getClass()) {
            return false;
        }
        NamedExpression other = (NamedExpression)obj;
        return Objects.equals(this.synthetic, other.synthetic) && Objects.equals(this.name, other.name) && Objects.equals(this.children(), other.children());
    }

    @Override
    public String toString() {
        return super.toString() + "#" + this.id();
    }
}

