/*
 * Decompiled with CFR 0.152.
 */
package org.flexdock.plaf.resources.border;

import java.awt.Color;
import java.awt.Component;
import java.awt.Graphics;
import java.awt.Insets;
import javax.swing.border.Border;
import javax.swing.plaf.ColorUIResource;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.flexdock.plaf.resources.ColorResourceHandler;
import org.flexdock.plaf.resources.ResourceHandler;

public class SquareBevelBorderResource
extends ResourceHandler {
    private static Log log = LogFactory.getLog((Class)SquareBevelBorderResource.class);
    private static final ColorUIResource DEFAULT_COLOR = new ColorUIResource(Color.WHITE);

    public Object getResource(String data) {
        String[] args = this.getArgs(data);
        int lineWidth = args.length > 0 ? this.getInt(args[0]) : 1;
        ColorUIResource lightColor = args.length > 1 ? this.getColor(args[1]) : DEFAULT_COLOR;
        ColorUIResource darkColor = args.length > 2 ? this.getColor(args[2]) : DEFAULT_COLOR;
        return new SquareBevelBorder(lineWidth, lightColor, darkColor);
    }

    private int getInt(String data) {
        try {
            return Integer.parseInt(data);
        }
        catch (Exception e) {
            log.debug((Object)e.getMessage(), (Throwable)e);
            return 1;
        }
    }

    private ColorUIResource getColor(String data) {
        ColorUIResource color = ColorResourceHandler.parseHexColor(data);
        return data == null ? DEFAULT_COLOR : color;
    }

    public static class SquareBevelBorder
    implements Border {
        private int lineWidth;
        private Color light;
        private Color dark;
        private Insets insets;

        public SquareBevelBorder(int lineWidth, Color light, Color dark) {
            this.lineWidth = lineWidth;
            this.light = light;
            this.dark = dark;
            this.insets = new Insets(lineWidth, lineWidth, lineWidth, lineWidth);
        }

        public Insets getBorderInsets(Component c) {
            return this.insets;
        }

        public boolean isBorderOpaque() {
            return true;
        }

        public void paintBorder(Component c, Graphics g, int x, int y, int width, int height) {
            Color saved = g.getColor();
            --width;
            --height;
            for (int i = 0; i < this.lineWidth; ++i) {
                g.setColor(this.dark);
                g.drawLine(width - i, i, width - i, height - i);
                g.drawLine(i, height - i, width - i, height - i);
                g.setColor(this.light);
                g.drawLine(i, i, width - i, i);
                g.drawLine(i, i, i, height - i);
            }
            g.setColor(saved);
        }
    }
}

