/*
 * Decompiled with CFR 0.152.
 */
package com.gallery.GalleryRemote.prefs;

import com.gallery.GalleryRemote.prefs.PreferenceNames;
import com.gallery.GalleryRemote.prefs.PreferencePanel;
import com.gallery.GalleryRemote.prefs.PropertiesFile;
import com.gallery.GalleryRemote.util.GRI18n;
import java.awt.Color;
import java.awt.Component;
import java.awt.FlowLayout;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import javax.swing.BorderFactory;
import javax.swing.JCheckBox;
import javax.swing.JComboBox;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.border.TitledBorder;

public class FilePanel
extends PreferencePanel
implements ActionListener,
PreferenceNames {
    public static final String MODULE = "FilePa";
    JLabel icon = new JLabel(GRI18n.getString((String)"FilePa", (String)"icon"));
    JCheckBox m_loadLastMRU = new JCheckBox();
    JComboBox m_numberOfMRU = new JComboBox<String>(new String[]{" 1", " 2", " 3", " 4", " 5", " 6", " 7", " 8", " 9"});

    public JLabel getIcon() {
        return this.icon;
    }

    public void readProperties(PropertiesFile props) {
        this.m_loadLastMRU.setSelected(props.getLoadLastMRU());
        this.m_numberOfMRU.setSelectedIndex(props.getIntProperty("mruCount") - 1);
        this.resetUIState();
    }

    public void writeProperties(PropertiesFile props) {
        props.setLoadLastMRU(this.m_loadLastMRU.isSelected());
        props.setMRUCountProperty(this.m_numberOfMRU.getSelectedIndex() + 1);
    }

    public void resetUIState() {
    }

    public void buildUI() {
        this.jbInit();
    }

    private void jbInit() {
        this.setLayout(new FlowLayout());
        JPanel thePanel = new JPanel();
        thePanel.setLayout(new GridBagLayout());
        thePanel.setBorder(new TitledBorder(BorderFactory.createEtchedBorder(Color.white, new Color(148, 145, 140)), GRI18n.getString((String)MODULE, (String)"mainPanelTitle")));
        JLabel numberOfMRULabel = new JLabel();
        this.m_loadLastMRU.setText(GRI18n.getString((String)MODULE, (String)"loadLastMRU"));
        numberOfMRULabel.setText(GRI18n.getString((String)MODULE, (String)"numberOfMRU"));
        this.m_numberOfMRU.setPrototypeDisplayValue("XXX");
        thePanel.add((Component)this.m_loadLastMRU, new GridBagConstraints(0, 0, 2, 1, 0.0, 0.0, 17, 0, new Insets(0, 0, 0, 0), 0, 0));
        thePanel.add((Component)numberOfMRULabel, new GridBagConstraints(0, 2, 1, 1, 0.0, 0.0, 17, 0, new Insets(0, 0, 0, 0), 0, 0));
        thePanel.add((Component)this.m_numberOfMRU, new GridBagConstraints(0, 3, 1, 1, 0.0, 0.0, 17, 0, new Insets(0, 0, 0, 0), 0, 0));
        this.add(thePanel, new GridBagConstraints(0, 2, 2, 1, 1.0, 1.0, 10, 1, new Insets(0, 0, 0, 0), 0, 0));
        this.m_loadLastMRU.addActionListener(this);
        this.m_numberOfMRU.addActionListener(this);
    }

    public void actionPerformed(ActionEvent e) {
        this.resetUIState();
    }
}

