/*
 * Decompiled with CFR 0.152.
 */
package org.opensolaris.opengrok.history;

import java.io.BufferedReader;
import java.io.ByteArrayInputStream;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.text.DateFormat;
import java.text.ParseException;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import java.util.logging.Level;
import org.opensolaris.opengrok.OpenGrokLogger;
import org.opensolaris.opengrok.configuration.RuntimeEnvironment;
import org.opensolaris.opengrok.history.BazaarRepository;
import org.opensolaris.opengrok.history.History;
import org.opensolaris.opengrok.history.HistoryEntry;
import org.opensolaris.opengrok.history.HistoryException;
import org.opensolaris.opengrok.util.Executor;

class BazaarHistoryParser
implements Executor.StreamHandler {
    private String myDir;
    private List<HistoryEntry> entries = new ArrayList<HistoryEntry>();
    private BazaarRepository repository = new BazaarRepository();

    BazaarHistoryParser(BazaarRepository repository) {
        this.repository = repository;
        this.myDir = repository.getDirectoryName() + File.separator;
    }

    History parse(File file, String sinceRevision) throws HistoryException {
        try {
            Executor executor = this.repository.getHistoryLogExecutor(file, sinceRevision);
            int status = executor.exec(true, this);
            if (status != 0) {
                throw new HistoryException("Failed to get history for: \"" + file.getAbsolutePath() + "\" Exit code: " + status);
            }
        }
        catch (IOException e) {
            throw new HistoryException("Failed to get history for: \"" + file.getAbsolutePath() + "\"", e);
        }
        if (sinceRevision != null) {
            this.repository.removeAndVerifyOldestChangeset(this.entries, sinceRevision);
        }
        return new History(this.entries);
    }

    @Override
    public void processStream(InputStream input) throws IOException {
        String s;
        DateFormat df = this.repository.getDateFormat();
        RuntimeEnvironment env = RuntimeEnvironment.getInstance();
        BufferedReader in = new BufferedReader(new InputStreamReader(input));
        HistoryEntry entry = null;
        int state = 0;
        block9: while ((s = in.readLine()) != null) {
            if ("------------------------------------------------------------".equals(s)) {
                if (entry != null && state > 2) {
                    this.entries.add(entry);
                }
                entry = new HistoryEntry();
                entry.setActive(true);
                state = 0;
                continue;
            }
            switch (state) {
                case 0: {
                    if (!s.startsWith("revno:")) continue block9;
                    String[] rev = s.substring("revno:".length()).trim().split(" ");
                    entry.setRevision(rev[0]);
                    ++state;
                    continue block9;
                }
                case 1: {
                    if (!s.startsWith("committer:")) continue block9;
                    entry.setAuthor(s.substring("committer:".length()).trim());
                    ++state;
                    continue block9;
                }
                case 2: {
                    if (!s.startsWith("timestamp:")) continue block9;
                    try {
                        Date date = df.parse(s.substring("timestamp:".length()).trim());
                        entry.setDate(date);
                    }
                    catch (ParseException e) {
                        OpenGrokLogger.getLogger().log(Level.WARNING, "Failed to parse history timestamp:" + s, e);
                    }
                    ++state;
                    continue block9;
                }
                case 3: {
                    if (s.startsWith("modified:") || s.startsWith("added:") || s.startsWith("removed:")) {
                        ++state;
                        continue block9;
                    }
                    if (!s.startsWith("  ")) continue block9;
                    entry.appendMessage(s.substring(2));
                    continue block9;
                }
                case 4: {
                    if (s.startsWith("modified:") || s.startsWith("added:") || s.startsWith("removed:")) continue block9;
                    int idx = (s = s.trim()).indexOf(" => ");
                    if (idx != -1) {
                        s = s.substring(idx + 4);
                    }
                    File f = new File(this.myDir, s);
                    String name = env.getPathRelativeToSourceRoot(f, 0);
                    entry.addFile(name);
                    continue block9;
                }
            }
            OpenGrokLogger.getLogger().warning("Unknown parser state: " + state);
        }
        if (entry != null && state > 2) {
            this.entries.add(entry);
        }
    }

    History parse(String buffer) throws IOException {
        this.myDir = File.separator;
        this.processStream(new ByteArrayInputStream(buffer.getBytes("UTF-8")));
        return new History(this.entries);
    }
}

