/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.tasks.generic;

import com.intellij.icons.AllIcons;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.JDOMUtil;
import com.intellij.tasks.TaskRepository;
import com.intellij.tasks.TaskRepositorySubtype;
import com.intellij.tasks.TaskRepositoryType;
import com.intellij.tasks.config.TaskRepositoryEditor;
import com.intellij.tasks.generic.GenericRepository;
import com.intellij.tasks.generic.GenericRepositoryEditor;
import com.intellij.tasks.impl.BaseRepositoryType;
import com.intellij.util.Consumer;
import com.intellij.util.xmlb.XmlSerializer;
import icons.TasksCoreIcons;
import java.net.URL;
import java.util.Arrays;
import java.util.List;
import javax.swing.Icon;
import org.jdom.Element;
import org.jetbrains.annotations.NotNull;

public class GenericRepositoryType
extends BaseRepositoryType<GenericRepository> {
    @NotNull
    public String getName() {
        if ("Generic" == null) {
            GenericRepositoryType.$$$reportNull$$$0(0);
        }
        return "Generic";
    }

    @NotNull
    public Icon getIcon() {
        Icon icon = AllIcons.General.Web;
        if (icon == null) {
            GenericRepositoryType.$$$reportNull$$$0(1);
        }
        return icon;
    }

    @NotNull
    public TaskRepository createRepository() {
        GenericRepository genericRepository = new GenericRepository((TaskRepositoryType)this);
        if (genericRepository == null) {
            GenericRepositoryType.$$$reportNull$$$0(2);
        }
        return genericRepository;
    }

    public Class<GenericRepository> getRepositoryClass() {
        return GenericRepository.class;
    }

    @NotNull
    public TaskRepositoryEditor createEditor(GenericRepository repository, Project project, Consumer<GenericRepository> changeListener) {
        GenericRepositoryEditor<GenericRepository> genericRepositoryEditor = new GenericRepositoryEditor<GenericRepository>(project, repository, changeListener);
        if (genericRepositoryEditor == null) {
            GenericRepositoryType.$$$reportNull$$$0(3);
        }
        return genericRepositoryEditor;
    }

    public List<TaskRepositorySubtype> getAvailableSubtypes() {
        return Arrays.asList(new TaskRepositorySubtype[]{this, new AsanaRepository(), new AssemblaRepository(), new SprintlyRepository()});
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2 = new Object[2];
        objectArray2[0] = "com/intellij/tasks/generic/GenericRepositoryType";
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "getName";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[1] = "getIcon";
                break;
            }
            case 2: {
                objectArray = objectArray2;
                objectArray2[1] = "createRepository";
                break;
            }
            case 3: {
                objectArray = objectArray2;
                objectArray2[1] = "createEditor";
                break;
            }
        }
        throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", objectArray));
    }

    public final class SprintlyRepository
    extends GenericSubtype {
        public SprintlyRepository() {
            super("Sprintly", TasksCoreIcons.Sprintly);
        }
    }

    public final class AssemblaRepository
    extends GenericSubtype {
        public AssemblaRepository() {
            super("Assembla", TasksCoreIcons.Assembla);
        }
    }

    public final class AsanaRepository
    extends GenericSubtype {
        public AsanaRepository() {
            super("Asana", TasksCoreIcons.Asana);
        }
    }

    public class GenericSubtype
    implements TaskRepositorySubtype {
        private final String myName;
        private final Icon myIcon;

        GenericSubtype(String name, Icon icon) {
            this.myName = name;
            this.myIcon = icon;
        }

        public String getName() {
            return this.myName + " [G]";
        }

        public Icon getIcon() {
            return this.myIcon;
        }

        public TaskRepository createRepository() {
            Element element;
            try {
                String configFileName = this.myName.toLowerCase() + ".xml";
                URL resourceUrl = GenericRepository.class.getResource("connectors/" + configFileName);
                if (resourceUrl == null) {
                    throw new AssertionError((Object)("Repository configuration file '" + configFileName + "' not found"));
                }
                element = JDOMUtil.loadResource((URL)resourceUrl);
            }
            catch (Exception e) {
                throw new AssertionError((Object)e);
            }
            GenericRepository repository = (GenericRepository)((Object)XmlSerializer.deserialize((Element)element, GenericRepository.class));
            repository.setRepositoryType((TaskRepositoryType)GenericRepositoryType.this);
            repository.setSubtypeName(this.getName());
            return repository;
        }
    }
}

