/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.plugins.ruby.gem.module.rbenv;

import b.h.la;
import com.intellij.codeInspection.LocalQuickFix;
import com.intellij.codeInspection.ProblemsHolder;
import com.intellij.openapi.module.Module;
import com.intellij.openapi.module.ModuleUtilCore;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.projectRoots.Sdk;
import com.intellij.openapi.roots.ProjectFileIndex;
import com.intellij.openapi.roots.ProjectRootManager;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.util.containers.ContainerUtil;
import java.lang.invoke.MethodHandles;
import java.util.Collection;
import java.util.List;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.plugins.ruby.RBundle;
import org.jetbrains.plugins.ruby.gem.module.rbenv.RbenvElementVisitor;
import org.jetbrains.plugins.ruby.gem.module.rbenv.RbenvGemsetCreateFix;
import org.jetbrains.plugins.ruby.gem.module.rbenv.RbenvGemsetSaveQuickFix;
import org.jetbrains.plugins.ruby.gem.module.rbenv.RbenvLocalGemsetExclusionFix;
import org.jetbrains.plugins.ruby.gem.module.rbenv.RbenvLocalGemsetFix;
import org.jetbrains.plugins.ruby.ruby.RModuleUtil;
import org.jetbrains.plugins.ruby.version.management.rbenv.gemsets.RbenvGemset;
import org.jetbrains.plugins.ruby.version.management.rbenv.gemsets.RbenvGemsetManager;
import org.jetbrains.plugins.ruby.version.management.rbenv.gemsets.RbenvLocalGemset;

public class RbenvGemsetVisitor
extends RbenvElementVisitor {
    private final ProblemsHolder a;
    private static final long c = la.a(-5392811789082623381L, 5293540935844319778L, MethodHandles.lookup().lookupClass()).a(109852466486161L);

    public RbenvGemsetVisitor(ProblemsHolder holder) {
        this.a = holder;
    }

    @Override
    public void visitGemset(@NotNull RbenvGemset gemset) {
        Module module;
        long l2 = c ^ 0x28ECBA9E7797L;
        if (gemset == null) {
            RbenvGemsetVisitor.b(0);
        }
        if ((module = ModuleUtilCore.findModuleForPsiElement((PsiElement)gemset)) == null) {
            return;
        }
        Sdk sdk = RModuleUtil.getInstance().findRubySdkForModule(module);
        if (sdk == null) {
            return;
        }
        String string = gemset.getName();
        if (!RbenvGemsetManager.hasGemset(sdk, string)) {
            this.a.registerProblem((PsiElement)gemset, RBundle.message((String)"ruby.rbenv.gemset.inspection.fix.text", (Object[])new Object[]{string, sdk.getName()}), new LocalQuickFix[]{new RbenvGemsetCreateFix(module, string)});
        }
    }

    @Override
    public void visitLocalGemset(@NotNull RbenvLocalGemset localGemset) {
        Module module;
        long l2 = c ^ 0x1ACAE844D506L;
        if (localGemset == null) {
            RbenvGemsetVisitor.b(1);
        }
        if ((module = ModuleUtilCore.findModuleForPsiElement((PsiElement)localGemset)) == null) {
            return;
        }
        String string = localGemset.getName();
        VirtualFile virtualFile = RbenvGemsetManager.getLocalGemsetFolder(module, string);
        if (virtualFile == null) {
            this.a.registerProblem((PsiElement)localGemset, RBundle.message((String)"ruby.rbenv.local.gemset.create.inspection.fix.text", (Object[])new Object[]{string}), new LocalQuickFix[]{new RbenvLocalGemsetFix(module, string)});
            return;
        }
        ProjectFileIndex projectFileIndex = ProjectRootManager.getInstance((Project)module.getProject()).getFileIndex();
        if (projectFileIndex.isExcluded(virtualFile)) {
            return;
        }
        this.a.registerProblem((PsiElement)localGemset, RBundle.message((String)"ruby.rbenv.local.gemset.inspection.fix.text", (Object[])new Object[]{string}), new LocalQuickFix[]{new RbenvLocalGemsetExclusionFix(module, virtualFile)});
    }

    public void visitFile(@NotNull PsiFile file) {
        Module module;
        long l2 = c ^ 0xBBA8B3A8A30L;
        if (file == null) {
            RbenvGemsetVisitor.b(2);
        }
        if ((module = ModuleUtilCore.findModuleForPsiElement((PsiElement)file)) == null) {
            return;
        }
        Sdk sdk = RModuleUtil.getInstance().findRubySdkForModule(module);
        if (sdk == null) {
            return;
        }
        for (String object2 : RbenvGemsetManager.getCurrentGemsetsOnly(module)) {
            if (RbenvGemsetManager.hasGemset(sdk, object2) || RbenvGemsetManager.hasLocalGemset(module, object2)) continue;
            return;
        }
        List<String> list2 = RbenvGemsetManager.getRbenvConfiguredGemsets(module, sdk);
        List<String> list3 = RbenvGemsetManager.getRbenvCurrentGemsets(module);
        if (ContainerUtil.compareLexicographically((List)ContainerUtil.sorted((Collection)list2), (List)ContainerUtil.sorted(list3)) != 0) {
            this.a.registerProblem((PsiElement)this.a.getFile(), RBundle.message((String)"ruby.rbenv.gemset.refresh.libs.text"), new LocalQuickFix[]{new RbenvGemsetSaveQuickFix(module)});
        }
    }

    private static /* synthetic */ void b(int n2) {
        Object[] objectArray;
        Object[] objectArray2;
        long l2 = c ^ 0x4C866AD2DCB0L;
        Object[] objectArray3 = new Object[3];
        switch (n2) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "gemset";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "localGemset";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "file";
                break;
            }
        }
        objectArray2[1] = "org/jetbrains/plugins/ruby/gem/module/rbenv/RbenvGemsetVisitor";
        switch (n2) {
            default: {
                objectArray = objectArray2;
                objectArray2[2] = "visitGemset";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[2] = "visitLocalGemset";
                break;
            }
            case 2: {
                objectArray = objectArray2;
                objectArray2[2] = "visitFile";
                break;
            }
        }
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
    }
}

