/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.lang.javascript.linter.tslint.codestyle.rules;

import com.google.gson.Gson;
import com.intellij.application.options.CodeStyle;
import com.intellij.lang.Language;
import com.intellij.lang.javascript.JavaScriptSupportLoader;
import com.intellij.lang.javascript.formatter.JSCodeStyleSettings;
import com.intellij.lang.javascript.linter.tslint.codestyle.rules.TsLintConfigKt;
import com.intellij.lang.javascript.linter.tslint.codestyle.rules.TsLintConfigWrapper;
import com.intellij.lang.javascript.linter.tslint.codestyle.rules.TsLintRulesKt;
import com.intellij.lang.javascript.linter.tslint.codestyle.rules.TsLintSimpleRule;
import com.intellij.lang.javascript.linter.tslint.codestyle.rules.TslintJsonOption;
import com.intellij.lang.typescript.formatter.TypeScriptCodeStyleSettings;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.application.WriteAction;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Key;
import com.intellij.openapi.util.UserDataHolder;
import com.intellij.psi.PsiFile;
import com.intellij.psi.codeStyle.CodeStyleSettings;
import com.intellij.psi.codeStyle.CodeStyleSettingsManager;
import com.intellij.psi.codeStyle.CommonCodeStyleSettings;
import com.intellij.psi.codeStyle.CustomCodeStyleSettings;
import com.intellij.psi.util.CachedValuesManager;
import com.intellij.psi.util.ParameterizedCachedValue;
import com.intellij.psi.util.ParameterizedCachedValueProvider;
import com.intellij.util.ThrowableRunnable;
import java.lang.reflect.Type;
import java.util.ArrayList;
import java.util.Collection;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.function.BiConsumer;
import kotlin.Metadata;
import kotlin.Pair;
import kotlin.collections.CollectionsKt;
import kotlin.collections.MapsKt;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.ranges.RangesKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.yaml.snakeyaml.Yaml;

/*
 * Illegal identifiers - consider using --renameillegalidents true
 */
@Metadata(mv={1, 1, 13}, bv={1, 0, 3}, k=1, d1={"\u0000R\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010$\n\u0002\u0010\u000e\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010 \n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0010\u001e\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0006\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\u0018\u0000 \u001e2\u00020\u0001:\u0001\u001eB'\u0012\u0012\u0010\u0002\u001a\u000e\u0012\u0004\u0012\u00020\u0004\u0012\u0004\u0012\u00020\u00050\u0003\u0012\f\u0010\u0006\u001a\b\u0012\u0004\u0012\u00020\u00040\u0007\u00a2\u0006\u0002\u0010\bJ \u0010\t\u001a\u00020\n2\u0006\u0010\u000b\u001a\u00020\f2\u0010\u0010\u0002\u001a\f\u0012\b\u0012\u0006\u0012\u0002\b\u00030\u000e0\rJ$\u0010\u000f\u001a\u00020\n2\u0006\u0010\u000b\u001a\u00020\f2\u0014\u0010\u0010\u001a\u0010\u0012\b\u0012\u0006\u0012\u0002\b\u00030\u000e\u0012\u0002\b\u00030\u0003J\u0010\u0010\u0011\u001a\u00020\u00122\u0006\u0010\u000b\u001a\u00020\fH\u0002J\u0010\u0010\u0013\u001a\u00020\u00142\u0006\u0010\u0015\u001a\u00020\u0012H\u0002J2\u0010\u0016\u001a\u0014\u0012\b\u0012\u0006\u0012\u0002\b\u00030\u000e\u0012\u0006\u0012\u0004\u0018\u00010\u00010\u00032\u0006\u0010\u000b\u001a\u00020\f2\u0010\u0010\u0002\u001a\f\u0012\b\u0012\u0006\u0012\u0002\b\u00030\u000e0\rJ\u0010\u0010\u0017\u001a\u0004\u0018\u00010\u00052\u0006\u0010\u0018\u001a\u00020\u0004J\u0018\u0010\u0019\u001a\f\u0012\b\u0012\u0006\u0012\u0002\b\u00030\u000e0\r2\u0006\u0010\u000b\u001a\u00020\fJ\u0006\u0010\u001a\u001a\u00020\u001bJ\u0010\u0010\u001c\u001a\u00020\u001d2\u0006\u0010\u0015\u001a\u00020\u0012H\u0002R\u0014\u0010\u0006\u001a\b\u0012\u0004\u0012\u00020\u00040\u0007X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u001a\u0010\u0002\u001a\u000e\u0012\u0004\u0012\u00020\u0004\u0012\u0004\u0012\u00020\u00050\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u001f"}, d2={"Lcom/intellij/lang/javascript/linter/tslint/codestyle/rules/TsLintConfigWrapper;", "", "rules", "", "", "Lcom/intellij/lang/javascript/linter/tslint/codestyle/rules/TslintJsonOption;", "extends", "", "(Ljava/util/Map;Ljava/util/List;)V", "applyRules", "", "project", "Lcom/intellij/openapi/project/Project;", "", "Lcom/intellij/lang/javascript/linter/tslint/codestyle/rules/TsLintSimpleRule;", "applyValues", "values", "current", "Lcom/intellij/psi/codeStyle/CodeStyleSettings;", "custom", "Lcom/intellij/lang/typescript/formatter/TypeScriptCodeStyleSettings;", "settings", "getCurrentSettings", "getOption", "name", "getRulesToApply", "hasExtends", "", "language", "Lcom/intellij/psi/codeStyle/CommonCodeStyleSettings;", "Companion", "intellij.tslint"})
public final class TsLintConfigWrapper {
    private final Map<String, TslintJsonOption> rules;
    private final List<String> extends;
    private static final Key<ParameterizedCachedValue<TsLintConfigWrapper, PsiFile>> RULES_CACHE_KEY;
    private static final ParameterizedCachedValueProvider<TsLintConfigWrapper, PsiFile> CACHED_VALUE_PROVIDER;
    public static final Companion Companion;

    public final boolean hasExtends() {
        return !this.extends.isEmpty();
    }

    @Nullable
    public final TslintJsonOption getOption(@NotNull String name) {
        Intrinsics.checkParameterIsNotNull((Object)name, (String)"name");
        return this.rules.get(name);
    }

    /*
     * WARNING - void declaration
     */
    @NotNull
    public final Collection<TsLintSimpleRule<?>> getRulesToApply(@NotNull Project project) {
        void $receiver$iv$iv;
        Iterable $receiver$iv;
        Intrinsics.checkParameterIsNotNull((Object)project, (String)"project");
        ApplicationManager.getApplication().assertReadAccessAllowed();
        CodeStyleSettings settings = this.current(project);
        CommonCodeStyleSettings languageSettings = this.language(settings);
        TypeScriptCodeStyleSettings jsCodeStyleSettings = this.custom(settings);
        Iterable iterable = $receiver$iv = (Iterable)TsLintRulesKt.getTslintRulesSet();
        Collection destination$iv$iv = new ArrayList();
        for (Object element$iv$iv : $receiver$iv$iv) {
            TsLintSimpleRule it = (TsLintSimpleRule)element$iv$iv;
            if (!it.isAvailable(project, languageSettings, (JSCodeStyleSettings)jsCodeStyleSettings, this)) continue;
            destination$iv$iv.add(element$iv$iv);
        }
        return (List)destination$iv$iv;
    }

    private final CodeStyleSettings current(Project project) {
        CodeStyleSettings codeStyleSettings = CodeStyle.getSettings((Project)project);
        Intrinsics.checkExpressionValueIsNotNull((Object)codeStyleSettings, (String)"CodeStyle.getSettings(project)");
        return codeStyleSettings;
    }

    private final CommonCodeStyleSettings language(CodeStyleSettings settings) {
        CommonCodeStyleSettings commonCodeStyleSettings = settings.getCommonSettings((Language)JavaScriptSupportLoader.TYPESCRIPT);
        Intrinsics.checkExpressionValueIsNotNull((Object)commonCodeStyleSettings, (String)"settings.getCommonSettin\u2026SupportLoader.TYPESCRIPT)");
        return commonCodeStyleSettings;
    }

    private final TypeScriptCodeStyleSettings custom(CodeStyleSettings settings) {
        CustomCodeStyleSettings customCodeStyleSettings = settings.getCustomSettings(TypeScriptCodeStyleSettings.class);
        Intrinsics.checkExpressionValueIsNotNull((Object)customCodeStyleSettings, (String)"settings.getCustomSettin\u2026tyleSettings::class.java)");
        return (TypeScriptCodeStyleSettings)customCodeStyleSettings;
    }

    /*
     * WARNING - void declaration
     */
    @NotNull
    public final Map<TsLintSimpleRule<?>, Object> getCurrentSettings(@NotNull Project project, @NotNull Collection<? extends TsLintSimpleRule<?>> rules) {
        void $receiver$iv$iv;
        Intrinsics.checkParameterIsNotNull((Object)project, (String)"project");
        Intrinsics.checkParameterIsNotNull(rules, (String)"rules");
        ApplicationManager.getApplication().assertReadAccessAllowed();
        CodeStyleSettings settings = this.current(project);
        CommonCodeStyleSettings languageSettings = this.language(settings);
        TypeScriptCodeStyleSettings jsCodeStyleSettings = this.custom(settings);
        Iterable $receiver$iv = rules;
        int capacity$iv = RangesKt.coerceAtLeast((int)MapsKt.mapCapacity((int)CollectionsKt.collectionSizeOrDefault((Iterable)$receiver$iv, (int)10)), (int)16);
        Iterable iterable = $receiver$iv;
        Map destination$iv$iv = new LinkedHashMap(capacity$iv);
        for (Object element$iv$iv : $receiver$iv$iv) {
            Map map = destination$iv$iv;
            TsLintSimpleRule it = (TsLintSimpleRule)element$iv$iv;
            Pair pair = new Pair((Object)it, it.getSettingsValue(languageSettings, (JSCodeStyleSettings)jsCodeStyleSettings));
            map.put(pair.getFirst(), pair.getSecond());
        }
        return destination$iv$iv;
    }

    public final void applyValues(@NotNull Project project, @NotNull Map<TsLintSimpleRule<?>, ?> values) {
        Intrinsics.checkParameterIsNotNull((Object)project, (String)"project");
        Intrinsics.checkParameterIsNotNull(values, (String)"values");
        CodeStyleSettings settings = this.current(project);
        CommonCodeStyleSettings languageSettings = this.language(settings);
        TypeScriptCodeStyleSettings jsCodeStyleSettings = this.custom(settings);
        WriteAction.run((ThrowableRunnable)new ThrowableRunnable<E>(values, languageSettings, jsCodeStyleSettings){
            final /* synthetic */ Map $values;
            final /* synthetic */ CommonCodeStyleSettings $languageSettings;
            final /* synthetic */ TypeScriptCodeStyleSettings $jsCodeStyleSettings;

            public final void run() {
                this.$values.forEach((BiConsumer)new BiConsumer<TsLintSimpleRule<?>, Object>(this){
                    final /* synthetic */ applyValues.1 this$0;

                    public final void accept(@NotNull TsLintSimpleRule<?> key, @Nullable Object value) {
                        Intrinsics.checkParameterIsNotNull(key, (String)"key");
                        key.setDirectValue(this.this$0.$languageSettings, (JSCodeStyleSettings)this.this$0.$jsCodeStyleSettings, value);
                    }
                    {
                        this.this$0 = var1_1;
                    }
                });
            }
            {
                this.$values = map;
                this.$languageSettings = commonCodeStyleSettings;
                this.$jsCodeStyleSettings = typeScriptCodeStyleSettings;
            }
        });
    }

    public final void applyRules(@NotNull Project project, @NotNull Collection<? extends TsLintSimpleRule<?>> rules) {
        Intrinsics.checkParameterIsNotNull((Object)project, (String)"project");
        Intrinsics.checkParameterIsNotNull(rules, (String)"rules");
        WriteAction.run((ThrowableRunnable)new ThrowableRunnable<E>(this, project, rules){
            final /* synthetic */ TsLintConfigWrapper this$0;
            final /* synthetic */ Project $project;
            final /* synthetic */ Collection $rules;

            public final void run() {
                CodeStyleSettingsManager settingsManager = CodeStyleSettingsManager.getInstance((Project)this.$project);
                if (!settingsManager.USE_PER_PROJECT_SETTINGS) {
                    CodeStyleSettingsManager codeStyleSettingsManager = settingsManager;
                    Intrinsics.checkExpressionValueIsNotNull((Object)codeStyleSettingsManager, (String)"settingsManager");
                    codeStyleSettingsManager.setMainProjectCodeStyle(settingsManager.getCurrentSettings().clone());
                    settingsManager.USE_PER_PROJECT_SETTINGS = true;
                }
                CodeStyleSettingsManager codeStyleSettingsManager = settingsManager;
                Intrinsics.checkExpressionValueIsNotNull((Object)codeStyleSettingsManager, (String)"settingsManager");
                CodeStyleSettings codeStyleSettings = codeStyleSettingsManager.getCurrentSettings();
                Intrinsics.checkExpressionValueIsNotNull((Object)codeStyleSettings, (String)"settingsManager.currentSettings");
                CodeStyleSettings newSettings = codeStyleSettings;
                CommonCodeStyleSettings newLanguageSettings = TsLintConfigWrapper.access$language(this.this$0, newSettings);
                TypeScriptCodeStyleSettings newJsCodeStyleSettings = TsLintConfigWrapper.access$custom(this.this$0, newSettings);
                Iterable $receiver$iv = this.$rules;
                for (T element$iv : $receiver$iv) {
                    TsLintSimpleRule rule = (TsLintSimpleRule)element$iv;
                    rule.apply(this.$project, newLanguageSettings, (JSCodeStyleSettings)newJsCodeStyleSettings, this.this$0);
                }
            }
            {
                this.this$0 = tsLintConfigWrapper;
                this.$project = project;
                this.$rules = collection;
            }
        });
    }

    public TsLintConfigWrapper(@NotNull Map<String, TslintJsonOption> rules, @NotNull List<String> list) {
        Intrinsics.checkParameterIsNotNull(rules, (String)"rules");
        Intrinsics.checkParameterIsNotNull(list, (String)"extends");
        this.rules = rules;
        this.extends = list;
    }

    static {
        Companion = new Companion(null);
        Key key = Key.create((String)"tslint.cache.key.config.json");
        Intrinsics.checkExpressionValueIsNotNull((Object)key, (String)"Key.create<Parameterized\u2026t.cache.key.config.json\")");
        RULES_CACHE_KEY = key;
        CACHED_VALUE_PROVIDER = Companion.CACHED_VALUE_PROVIDER.1.INSTANCE;
    }

    @NotNull
    public static final /* synthetic */ CommonCodeStyleSettings access$language(TsLintConfigWrapper $this, @NotNull CodeStyleSettings settings) {
        return $this.language(settings);
    }

    @NotNull
    public static final /* synthetic */ TypeScriptCodeStyleSettings access$custom(TsLintConfigWrapper $this, @NotNull CodeStyleSettings settings) {
        return $this.custom(settings);
    }

    @Metadata(mv={1, 1, 13}, bv={1, 0, 3}, k=1, d1={"\u00004\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010$\n\u0002\b\u0002\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\u0012\u0010\u000b\u001a\u0004\u0018\u00010\u00052\b\u0010\f\u001a\u0004\u0018\u00010\u0006J\u0012\u0010\r\u001a\u0004\u0018\u00010\u00052\b\u0010\u000e\u001a\u0004\u0018\u00010\u000fJ \u0010\u0010\u001a\u0010\u0012\u0004\u0012\u00020\u000f\u0012\u0004\u0012\u00020\u0001\u0018\u00010\u00112\b\u0010\u000e\u001a\u0004\u0018\u00010\u000fH\u0002J \u0010\u0012\u001a\u0010\u0012\u0004\u0012\u00020\u000f\u0012\u0004\u0012\u00020\u0001\u0018\u00010\u00112\b\u0010\u000e\u001a\u0004\u0018\u00010\u000fH\u0002R\u001a\u0010\u0003\u001a\u000e\u0012\u0004\u0012\u00020\u0005\u0012\u0004\u0012\u00020\u00060\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000R4\u0010\u0007\u001a(\u0012$\u0012\"\u0012\u0004\u0012\u00020\u0005\u0012\u0004\u0012\u00020\u0006 \n*\u0010\u0012\u0004\u0012\u00020\u0005\u0012\u0004\u0012\u00020\u0006\u0018\u00010\t0\t0\bX\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0013"}, d2={"Lcom/intellij/lang/javascript/linter/tslint/codestyle/rules/TsLintConfigWrapper$Companion;", "", "()V", "CACHED_VALUE_PROVIDER", "Lcom/intellij/psi/util/ParameterizedCachedValueProvider;", "Lcom/intellij/lang/javascript/linter/tslint/codestyle/rules/TsLintConfigWrapper;", "Lcom/intellij/psi/PsiFile;", "RULES_CACHE_KEY", "Lcom/intellij/openapi/util/Key;", "Lcom/intellij/psi/util/ParameterizedCachedValue;", "kotlin.jvm.PlatformType", "getConfigForFile", "psiFile", "getConfigFromText", "text", "", "jsonAsMap", "", "yamlAsMap", "intellij.tslint"})
    public static final class Companion {
        @Nullable
        public final TsLintConfigWrapper getConfigForFile(@Nullable PsiFile psiFile) {
            if (psiFile == null) {
                return null;
            }
            TsLintConfigWrapper tsLintConfigWrapper = (TsLintConfigWrapper)CachedValuesManager.getManager((Project)psiFile.getProject()).getParameterizedCachedValue((UserDataHolder)psiFile, RULES_CACHE_KEY, CACHED_VALUE_PROVIDER, false, (Object)psiFile);
            if (tsLintConfigWrapper == null) {
                return null;
            }
            return tsLintConfigWrapper;
        }

        /*
         * WARNING - void declaration
         */
        @Nullable
        public final TsLintConfigWrapper getConfigFromText(@Nullable String text) {
            Object rulesObject;
            Map<String, Object> map;
            Map<String, Object> map2 = this.jsonAsMap(text);
            if (map2 == null) {
                map2 = map = this.yamlAsMap(text);
            }
            if (map != null && (rulesObject = map.get("rules")) instanceof Map) {
                Map map3;
                void $receiver$iv$iv;
                void $receiver$iv;
                TsLintConfigWrapper tsLintConfigWrapper;
                Map typed;
                Map map4 = typed = (Map)rulesObject;
                TsLintConfigWrapper tsLintConfigWrapper2 = tsLintConfigWrapper;
                TsLintConfigWrapper tsLintConfigWrapper3 = tsLintConfigWrapper;
                void var6_8 = $receiver$iv;
                Map destination$iv$iv = new LinkedHashMap(MapsKt.mapCapacity((int)$receiver$iv.size()));
                Iterable $receiver$iv$iv$iv = $receiver$iv$iv.entrySet();
                for (Object element$iv$iv$iv : $receiver$iv$iv$iv) {
                    void it;
                    void it$iv$iv;
                    Map.Entry entry = (Map.Entry)element$iv$iv$iv;
                    Map map5 = destination$iv$iv;
                    Object k = it$iv$iv.getKey();
                    Map.Entry entry2 = (Map.Entry)element$iv$iv$iv;
                    Object k2 = k;
                    map3 = map5;
                    TslintJsonOption tslintJsonOption = new TslintJsonOption(it.getValue());
                    map3.put(k2, tslintJsonOption);
                }
                map3 = destination$iv$iv;
                tsLintConfigWrapper2(map3, TsLintConfigKt.access$asStringArrayOrSingleString(map.get("extends")));
                return tsLintConfigWrapper3;
            }
            return null;
        }

        private final Map<String, Object> jsonAsMap(String text) {
            Map map;
            try {
                map = (Map)new Gson().fromJson(text, (Type)((Object)Map.class));
            }
            catch (Exception e) {
                TsLintConfigKt.access$getLOG$p().debug("Could not parse JSON TSLint config from " + text, (Throwable)e);
                map = null;
            }
            return map;
        }

        private final Map<String, Object> yamlAsMap(String text) {
            Map map;
            try {
                map = (Map)new Yaml().load(text);
            }
            catch (Exception e) {
                TsLintConfigKt.access$getLOG$p().debug("Could not parse YAML TSLint config from " + text, (Throwable)e);
                map = null;
            }
            return map;
        }

        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

