/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.cvsSupport2.connections.ssh;

import com.intellij.cvsSupport2.connections.ssh.SSHPasswordProvider;
import com.intellij.openapi.components.NamedComponent;
import com.intellij.openapi.components.ServiceManager;
import com.intellij.openapi.util.InvalidDataException;
import com.intellij.openapi.util.JDOMExternalizable;
import com.intellij.openapi.util.WriteExternalException;
import java.util.HashMap;
import java.util.Map;
import org.jdom.Element;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.netbeans.lib.cvsclient.connection.PServerPasswordScrambler;

public class SSHPasswordProviderImpl
implements NamedComponent,
JDOMExternalizable,
SSHPasswordProvider {
    private final Map<String, String> myCvsRootToPasswordMap = new HashMap<String, String>();
    private final Map<String, String> myCvsRootToStoringPasswordMap = new HashMap<String, String>();
    private final Map<String, String> myCvsRootToPPKPasswordMap = new HashMap<String, String>();
    private final Map<String, String> myCvsRootToStoringPPKPasswordMap = new HashMap<String, String>();
    private final Object myLock = new Object();
    @NonNls
    private static final String PASSWORDS = "passwords";
    @NonNls
    private static final String PASSWORD = "password";
    @NonNls
    private static final String PPKPASSWORDS = "ppkpasswords";
    @NonNls
    private static final String CVSROOT_ATTR = "CVSROOT";
    @NonNls
    private static final String PASSWORD_ATTR = "PASSWORD";

    public static SSHPasswordProviderImpl getInstance() {
        return (SSHPasswordProviderImpl)ServiceManager.getService(SSHPasswordProviderImpl.class);
    }

    @NotNull
    public String getComponentName() {
        if ("SSHPasswordProvider" == null) {
            SSHPasswordProviderImpl.$$$reportNull$$$0(0);
        }
        return "SSHPasswordProvider";
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Nullable
    public String getPasswordForCvsRoot(String cvsRoot) {
        Object object = this.myLock;
        synchronized (object) {
            String password = this.myCvsRootToStoringPasswordMap.get(cvsRoot);
            if (password != null) {
                return password;
            }
            return this.myCvsRootToPasswordMap.get(cvsRoot);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void storePasswordForCvsRoot(String cvsRoot, String password, boolean storeInWorkspace) {
        Object object = this.myLock;
        synchronized (object) {
            if (storeInWorkspace) {
                this.myCvsRootToStoringPasswordMap.put(cvsRoot, password);
            } else {
                this.myCvsRootToPasswordMap.put(cvsRoot, password);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Nullable
    public String getPPKPasswordForCvsRoot(String cvsRoot) {
        Object object = this.myLock;
        synchronized (object) {
            String password = this.myCvsRootToStoringPPKPasswordMap.get(cvsRoot);
            if (password != null) {
                return password;
            }
            return this.myCvsRootToPPKPasswordMap.get(cvsRoot);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void storePPKPasswordForCvsRoot(String cvsRoot, String password, boolean storeInWorkspace) {
        Object object = this.myLock;
        synchronized (object) {
            if (storeInWorkspace) {
                this.myCvsRootToStoringPPKPasswordMap.put(cvsRoot, password);
            } else {
                this.myCvsRootToPPKPasswordMap.put(cvsRoot, password);
            }
        }
    }

    public void writeExternal(Element element) throws WriteExternalException {
        Element password;
        if (!this.myCvsRootToStoringPasswordMap.isEmpty()) {
            Element passwords = new Element(PASSWORDS);
            for (String cvsRoot : this.myCvsRootToStoringPasswordMap.keySet()) {
                password = new Element(PASSWORD);
                password.setAttribute(CVSROOT_ATTR, cvsRoot);
                password.setAttribute(PASSWORD_ATTR, PServerPasswordScrambler.getInstance().scramble(this.myCvsRootToStoringPasswordMap.get(cvsRoot)));
                passwords.addContent(password);
            }
            element.addContent(passwords);
        }
        if (!this.myCvsRootToStoringPPKPasswordMap.isEmpty()) {
            Element ppkPasswords = new Element(PPKPASSWORDS);
            for (String cvsRoot : this.myCvsRootToStoringPPKPasswordMap.keySet()) {
                password = new Element(PASSWORD);
                password.setAttribute(CVSROOT_ATTR, cvsRoot);
                password.setAttribute(PASSWORD_ATTR, PServerPasswordScrambler.getInstance().scramble(this.myCvsRootToStoringPPKPasswordMap.get(cvsRoot)));
                ppkPasswords.addContent(password);
            }
            element.addContent(ppkPasswords);
        }
    }

    public void readExternal(Element element) throws InvalidDataException {
        Element ppkPasswords;
        Element passwords = element.getChild(PASSWORDS);
        if (passwords != null) {
            for (Element passElement : passwords.getChildren(PASSWORD)) {
                String cvsRoot = passElement.getAttributeValue(CVSROOT_ATTR);
                String password = passElement.getAttributeValue(PASSWORD_ATTR);
                if (cvsRoot == null || password == null) continue;
                this.myCvsRootToStoringPasswordMap.put(cvsRoot, PServerPasswordScrambler.getInstance().unscramble(password));
            }
        }
        if ((ppkPasswords = element.getChild(PPKPASSWORDS)) != null) {
            for (Element passElement : ppkPasswords.getChildren(PASSWORD)) {
                String cvsRoot = passElement.getAttributeValue(CVSROOT_ATTR);
                String password = passElement.getAttributeValue(PASSWORD_ATTR);
                if (cvsRoot == null || password == null) continue;
                this.myCvsRootToStoringPPKPasswordMap.put(cvsRoot, PServerPasswordScrambler.getInstance().unscramble(password));
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void removePasswordFor(String stringRepresentation) {
        Object object = this.myLock;
        synchronized (object) {
            this.myCvsRootToPasswordMap.remove(stringRepresentation);
            this.myCvsRootToStoringPasswordMap.remove(stringRepresentation);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void removePPKPasswordFor(String stringRepresentation) {
        Object object = this.myLock;
        synchronized (object) {
            this.myCvsRootToPPKPasswordMap.remove(stringRepresentation);
            this.myCvsRootToStoringPPKPasswordMap.remove(stringRepresentation);
        }
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/cvsSupport2/connections/ssh/SSHPasswordProviderImpl", "getComponentName"));
    }
}

