/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.codeInsight.editorActions;

import com.intellij.codeInsight.CodeInsightSettings;
import com.intellij.codeInsight.editorActions.TabOutScopesTracker;
import com.intellij.injected.editor.DocumentWindow;
import com.intellij.injected.editor.EditorWindow;
import com.intellij.openapi.Disposable;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.editor.Caret;
import com.intellij.openapi.editor.Document;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.editor.RangeMarker;
import com.intellij.openapi.editor.event.DocumentEvent;
import com.intellij.openapi.editor.event.DocumentListener;
import com.intellij.openapi.editor.ex.DocumentBulkUpdateListener;
import com.intellij.openapi.editor.impl.EditorImpl;
import com.intellij.openapi.util.Key;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import org.jetbrains.annotations.NotNull;

public class TabOutScopesTrackerImpl
implements TabOutScopesTracker {
    public void registerEmptyScope(@NotNull Editor editor, int offset) {
        if (editor == null) {
            TabOutScopesTrackerImpl.$$$reportNull$$$0(0);
        }
        ApplicationManager.getApplication().assertIsDispatchThread();
        assert (!editor.isDisposed()) : "Disposed editor";
        if (!CodeInsightSettings.getInstance().TAB_EXITS_BRACKETS_AND_QUOTES) {
            return;
        }
        if (editor instanceof EditorWindow) {
            DocumentWindow documentWindow = ((EditorWindow)editor).getDocument();
            offset = documentWindow.injectedToHost(offset);
            editor = ((EditorWindow)editor).getDelegate();
        }
        if (!(editor instanceof EditorImpl)) {
            return;
        }
        Tracker tracker = Tracker.forEditor((EditorImpl)editor, true);
        tracker.registerScope(offset);
    }

    public boolean hasScopeEndingAt(@NotNull Editor editor, int offset) {
        if (editor == null) {
            TabOutScopesTrackerImpl.$$$reportNull$$$0(1);
        }
        return TabOutScopesTrackerImpl.checkOrRemoveScopeEndingAt(editor, offset, false);
    }

    public boolean removeScopeEndingAt(@NotNull Editor editor, int offset) {
        if (editor == null) {
            TabOutScopesTrackerImpl.$$$reportNull$$$0(2);
        }
        return TabOutScopesTrackerImpl.checkOrRemoveScopeEndingAt(editor, offset, true);
    }

    private static boolean checkOrRemoveScopeEndingAt(@NotNull Editor editor, int offset, boolean removeScope) {
        if (editor == null) {
            TabOutScopesTrackerImpl.$$$reportNull$$$0(3);
        }
        ApplicationManager.getApplication().assertIsDispatchThread();
        if (!CodeInsightSettings.getInstance().TAB_EXITS_BRACKETS_AND_QUOTES) {
            return false;
        }
        if (editor instanceof EditorWindow) {
            DocumentWindow documentWindow = ((EditorWindow)editor).getDocument();
            offset = documentWindow.injectedToHost(offset);
            editor = ((EditorWindow)editor).getDelegate();
        }
        if (!(editor instanceof EditorImpl)) {
            return false;
        }
        Tracker tracker = Tracker.forEditor((EditorImpl)editor, false);
        if (tracker == null) {
            return false;
        }
        return tracker.hasScopeEndingAt(offset, removeScope);
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2 = new Object[3];
        objectArray2[0] = "editor";
        objectArray2[1] = "com/intellij/codeInsight/editorActions/TabOutScopesTrackerImpl";
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[2] = "registerEmptyScope";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[2] = "hasScopeEndingAt";
                break;
            }
            case 2: {
                objectArray = objectArray2;
                objectArray2[2] = "removeScopeEndingAt";
                break;
            }
            case 3: {
                objectArray = objectArray2;
                objectArray2[2] = "checkOrRemoveScopeEndingAt";
                break;
            }
        }
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
    }

    private static class Tracker
    extends DocumentBulkUpdateListener.Adapter
    implements DocumentListener {
        private static final Key<Tracker> TRACKER = Key.create((String)"tab.out.scope.tracker");
        private static final Key<List<RangeMarker>> TRACKED_SCOPES = Key.create((String)"tab.out.scopes");
        private final Editor myEditor;

        private static Tracker forEditor(@NotNull EditorImpl editor, boolean createIfAbsent) {
            Tracker tracker;
            if (editor == null) {
                Tracker.$$$reportNull$$$0(0);
            }
            if ((tracker = (Tracker)editor.getUserData(TRACKER)) == null && createIfAbsent) {
                tracker = new Tracker(editor);
                editor.putUserData(TRACKER, tracker);
            }
            return tracker;
        }

        private Tracker(@NotNull EditorImpl editor) {
            if (editor == null) {
                Tracker.$$$reportNull$$$0(1);
            }
            this.myEditor = editor;
            Disposable editorDisposable = editor.getDisposable();
            this.myEditor.getDocument().addDocumentListener((DocumentListener)this, editorDisposable);
            ApplicationManager.getApplication().getMessageBus().connect(editorDisposable).subscribe(DocumentBulkUpdateListener.TOPIC, (Object)this);
        }

        private List<RangeMarker> getCurrentScopes(boolean create2) {
            Caret currentCaret = this.myEditor.getCaretModel().getCurrentCaret();
            ArrayList result2 = (ArrayList)currentCaret.getUserData(TRACKED_SCOPES);
            if (result2 == null && create2) {
                result2 = new ArrayList();
                currentCaret.putUserData(TRACKED_SCOPES, result2);
            }
            return result2;
        }

        private void registerScope(int offset) {
            RangeMarker marker = this.myEditor.getDocument().createRangeMarker(offset, offset);
            marker.setGreedyToLeft(true);
            marker.setGreedyToRight(true);
            this.getCurrentScopes(true).add(marker);
        }

        private boolean hasScopeEndingAt(int offset, boolean remove) {
            List<RangeMarker> scopes = this.getCurrentScopes(false);
            if (scopes == null) {
                return false;
            }
            Iterator<RangeMarker> it = scopes.iterator();
            while (it.hasNext()) {
                RangeMarker scope = it.next();
                if (offset != scope.getEndOffset()) continue;
                if (remove) {
                    it.remove();
                }
                return true;
            }
            return false;
        }

        public void beforeDocumentChange(@NotNull DocumentEvent event) {
            List<RangeMarker> scopes;
            if (event == null) {
                Tracker.$$$reportNull$$$0(2);
            }
            if ((scopes = this.getCurrentScopes(false)) == null) {
                return;
            }
            int caretOffset = this.myEditor.getCaretModel().getOffset();
            int changeStart = event.getOffset();
            int changeEnd = event.getOffset() + event.getOldLength();
            Iterator<RangeMarker> it = scopes.iterator();
            while (it.hasNext()) {
                RangeMarker scope = it.next();
                if (changeStart >= scope.getStartOffset() && changeEnd <= scope.getEndOffset() || caretOffset >= scope.getStartOffset() && caretOffset <= scope.getEndOffset() && (changeEnd < scope.getStartOffset() || changeStart > scope.getEndOffset())) continue;
                it.remove();
            }
        }

        @Override
        public void updateStarted(@NotNull Document doc) {
            if (doc == null) {
                Tracker.$$$reportNull$$$0(3);
            }
            for (Caret caret : this.myEditor.getCaretModel().getAllCarets()) {
                caret.putUserData(TRACKED_SCOPES, null);
            }
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2;
            Object[] objectArray3 = new Object[3];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "editor";
                    break;
                }
                case 2: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "event";
                    break;
                }
                case 3: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "doc";
                    break;
                }
            }
            objectArray2[1] = "com/intellij/codeInsight/editorActions/TabOutScopesTrackerImpl$Tracker";
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[2] = "forEditor";
                    break;
                }
                case 1: {
                    objectArray = objectArray2;
                    objectArray2[2] = "<init>";
                    break;
                }
                case 2: {
                    objectArray = objectArray2;
                    objectArray2[2] = "beforeDocumentChange";
                    break;
                }
                case 3: {
                    objectArray = objectArray2;
                    objectArray2[2] = "updateStarted";
                    break;
                }
            }
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
        }
    }
}

