/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.codeInsight.editorActions;

import com.intellij.application.options.editor.WebEditorOptions;
import com.intellij.codeInsight.editorActions.TypedHandlerDelegate;
import com.intellij.codeInsight.highlighting.BraceMatchingUtil;
import com.intellij.lang.ASTNode;
import com.intellij.lang.xml.XMLLanguage;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.editor.EditorModificationUtil;
import com.intellij.openapi.editor.ScrollType;
import com.intellij.openapi.editor.ex.EditorEx;
import com.intellij.openapi.editor.highlighter.HighlighterIterator;
import com.intellij.openapi.fileTypes.FileType;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.TextRange;
import com.intellij.psi.FileViewProvider;
import com.intellij.psi.PsiDocumentManager;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiErrorElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiWhiteSpace;
import com.intellij.psi.codeStyle.CodeStyleManager;
import com.intellij.psi.html.HtmlTag;
import com.intellij.psi.impl.source.xml.XmlTokenImpl;
import com.intellij.psi.templateLanguages.OuterLanguageElement;
import com.intellij.psi.templateLanguages.TemplateLanguageFileViewProvider;
import com.intellij.psi.tree.IElementType;
import com.intellij.psi.xml.XmlAttributeValue;
import com.intellij.psi.xml.XmlChildRole;
import com.intellij.psi.xml.XmlDocument;
import com.intellij.psi.xml.XmlTag;
import com.intellij.psi.xml.XmlText;
import com.intellij.psi.xml.XmlToken;
import com.intellij.psi.xml.XmlTokenType;
import com.intellij.util.IncorrectOperationException;
import com.intellij.util.containers.ContainerUtil;
import com.intellij.xml.XmlElementDescriptor;
import com.intellij.xml.XmlElementDescriptorWithCDataContent;
import com.intellij.xml.util.HtmlUtil;
import com.intellij.xml.util.XmlUtil;
import java.util.Collection;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class XmlGtTypedHandler
extends TypedHandlerDelegate {
    private static final Logger LOG = Logger.getInstance((String)"#com.intellij.codeInsight.editorActions.TypedHandler");

    @NotNull
    public TypedHandlerDelegate.Result beforeCharTyped(char c, @NotNull Project project, @NotNull Editor editor, @NotNull PsiFile editedFile, @NotNull FileType fileType) {
        if (project == null) {
            XmlGtTypedHandler.$$$reportNull$$$0(0);
        }
        if (editor == null) {
            XmlGtTypedHandler.$$$reportNull$$$0(1);
        }
        if (editedFile == null) {
            XmlGtTypedHandler.$$$reportNull$$$0(2);
        }
        if (fileType == null) {
            XmlGtTypedHandler.$$$reportNull$$$0(3);
        }
        WebEditorOptions webEditorOptions = WebEditorOptions.getInstance();
        if (c == '>' && webEditorOptions != null && webEditorOptions.isAutomaticallyInsertClosingTag() && XmlGtTypedHandler.fileContainsXmlLanguage(editedFile)) {
            PsiElement element;
            PsiDocumentManager.getInstance((Project)project).commitAllDocuments();
            PsiFile file2 = PsiDocumentManager.getInstance((Project)project).getPsiFile(editor.getDocument());
            FileViewProvider provider = editedFile.getViewProvider();
            int offset = editor.getCaretModel().getOffset();
            PsiElement elementAtCaret = null;
            if (offset < editor.getDocument().getTextLength()) {
                PsiElement parent;
                IElementType tokenType;
                elementAtCaret = element = provider.findElementAt(offset, XMLLanguage.class);
                if (element == null && offset > 0) {
                    elementAtCaret = element = provider.findElementAt(offset - 1, XMLLanguage.class);
                }
                if (!(element instanceof PsiWhiteSpace)) {
                    boolean nonAcceptableDelimiter = true;
                    if (element instanceof XmlToken) {
                        tokenType = ((XmlToken)element).getTokenType();
                        if (tokenType == XmlTokenType.XML_START_TAG_START || tokenType == XmlTokenType.XML_END_TAG_START) {
                            PsiElement previousElement;
                            if (offset > 0 && (previousElement = provider.findElementAt(offset - 1, XMLLanguage.class)) instanceof XmlToken) {
                                tokenType = ((XmlToken)previousElement).getTokenType();
                                element = previousElement;
                                nonAcceptableDelimiter = false;
                            }
                        } else if ((tokenType == XmlTokenType.XML_NAME || tokenType == XmlTokenType.XML_TAG_NAME) && element.getNextSibling() instanceof PsiErrorElement) {
                            nonAcceptableDelimiter = false;
                        }
                        if (tokenType == XmlTokenType.XML_TAG_END || tokenType == XmlTokenType.XML_EMPTY_ELEMENT_END && element.getTextOffset() == offset - 1) {
                            EditorModificationUtil.moveCaretRelatively((Editor)editor, (int)1);
                            editor.getScrollingModel().scrollToCaret(ScrollType.RELATIVE);
                            TypedHandlerDelegate.Result result2 = TypedHandlerDelegate.Result.STOP;
                            if (result2 == null) {
                                XmlGtTypedHandler.$$$reportNull$$$0(4);
                            }
                            return result2;
                        }
                    }
                    if (nonAcceptableDelimiter) {
                        TypedHandlerDelegate.Result result3 = TypedHandlerDelegate.Result.CONTINUE;
                        if (result3 == null) {
                            XmlGtTypedHandler.$$$reportNull$$$0(5);
                        }
                        return result3;
                    }
                } else {
                    PsiElement previousElement = provider.findElementAt(offset - 1, XMLLanguage.class);
                    if (previousElement instanceof XmlToken && (tokenType = ((XmlToken)previousElement).getTokenType()) == XmlTokenType.XML_EMPTY_ELEMENT_END) {
                        TypedHandlerDelegate.Result result4 = TypedHandlerDelegate.Result.STOP;
                        if (result4 == null) {
                            XmlGtTypedHandler.$$$reportNull$$$0(6);
                        }
                        return result4;
                    }
                }
                if ((parent = element.getParent()) instanceof XmlText) {
                    String text = parent.getText();
                    int index = offset - parent.getTextOffset() - 1;
                    if (index >= 0 && text.charAt(index) == '/') {
                        TypedHandlerDelegate.Result result5 = TypedHandlerDelegate.Result.CONTINUE;
                        if (result5 == null) {
                            XmlGtTypedHandler.$$$reportNull$$$0(7);
                        }
                        return result5;
                    }
                    element = parent.getPrevSibling();
                } else if (parent instanceof XmlTag && !(element.getPrevSibling() instanceof XmlTag) && !(element.getPrevSibling() instanceof OuterLanguageElement)) {
                    element = parent;
                } else if (parent instanceof XmlAttributeValue) {
                    element = parent;
                }
            } else {
                element = provider.findElementAt(editor.getDocument().getTextLength() - 1, XMLLanguage.class);
                if (element == null) {
                    TypedHandlerDelegate.Result result6 = TypedHandlerDelegate.Result.CONTINUE;
                    if (result6 == null) {
                        XmlGtTypedHandler.$$$reportNull$$$0(8);
                    }
                    return result6;
                }
                element = element.getParent();
            }
            if (offset > 0 && offset <= editor.getDocument().getTextLength() && editor.getDocument().getCharsSequence().charAt(offset - 1) == '/') {
                TypedHandlerDelegate.Result result7 = TypedHandlerDelegate.Result.CONTINUE;
                if (result7 == null) {
                    XmlGtTypedHandler.$$$reportNull$$$0(9);
                }
                return result7;
            }
            if (element instanceof XmlAttributeValue) {
                element = element.getParent().getParent();
            }
            while (element instanceof PsiWhiteSpace || element instanceof OuterLanguageElement) {
                element = element.getPrevSibling();
            }
            if (element instanceof XmlDocument) {
                element = element.getLastChild();
            }
            if (element == null) {
                TypedHandlerDelegate.Result result8 = TypedHandlerDelegate.Result.CONTINUE;
                if (result8 == null) {
                    XmlGtTypedHandler.$$$reportNull$$$0(10);
                }
                return result8;
            }
            if (!(element instanceof XmlTag)) {
                if (element instanceof XmlTokenImpl && element.getPrevSibling() != null && element.getPrevSibling().getText().equals("<")) {
                    EditorModificationUtil.insertStringAtCaret((Editor)editor, (String)("</" + element.getText() + ">"), (boolean)false, (int)0);
                }
                TypedHandlerDelegate.Result result9 = TypedHandlerDelegate.Result.CONTINUE;
                if (result9 == null) {
                    XmlGtTypedHandler.$$$reportNull$$$0(11);
                }
                return result9;
            }
            XmlTag tag = (XmlTag)element;
            if (XmlUtil.getTokenOfType((PsiElement)tag, XmlTokenType.XML_TAG_END) != null) {
                TypedHandlerDelegate.Result result10 = TypedHandlerDelegate.Result.CONTINUE;
                if (result10 == null) {
                    XmlGtTypedHandler.$$$reportNull$$$0(12);
                }
                return result10;
            }
            if (XmlUtil.getTokenOfType((PsiElement)tag, XmlTokenType.XML_EMPTY_ELEMENT_END) != null) {
                TypedHandlerDelegate.Result result11 = TypedHandlerDelegate.Result.CONTINUE;
                if (result11 == null) {
                    XmlGtTypedHandler.$$$reportNull$$$0(13);
                }
                return result11;
            }
            XmlToken startToken = XmlUtil.getTokenOfType((PsiElement)tag, XmlTokenType.XML_START_TAG_START);
            if (startToken == null || !startToken.getText().equals("<")) {
                TypedHandlerDelegate.Result result12 = TypedHandlerDelegate.Result.CONTINUE;
                if (result12 == null) {
                    XmlGtTypedHandler.$$$reportNull$$$0(14);
                }
                return result12;
            }
            String name = tag.getName();
            if (elementAtCaret instanceof XmlToken && (((XmlToken)elementAtCaret).getTokenType() == XmlTokenType.XML_NAME || ((XmlToken)elementAtCaret).getTokenType() == XmlTokenType.XML_TAG_NAME)) {
                name = name.substring(0, offset - elementAtCaret.getTextOffset());
            }
            if (tag instanceof HtmlTag && HtmlUtil.isSingleHtmlTag(tag, true)) {
                TypedHandlerDelegate.Result result13 = TypedHandlerDelegate.Result.CONTINUE;
                if (result13 == null) {
                    XmlGtTypedHandler.$$$reportNull$$$0(15);
                }
                return result13;
            }
            if (name.isEmpty()) {
                TypedHandlerDelegate.Result result14 = TypedHandlerDelegate.Result.CONTINUE;
                if (result14 == null) {
                    XmlGtTypedHandler.$$$reportNull$$$0(16);
                }
                return result14;
            }
            int tagOffset = tag.getTextRange().getStartOffset();
            XmlToken nameToken = XmlUtil.getTokenOfType((PsiElement)tag, XmlTokenType.XML_NAME);
            if (nameToken != null && nameToken.getTextRange().getStartOffset() > offset) {
                TypedHandlerDelegate.Result result15 = TypedHandlerDelegate.Result.CONTINUE;
                if (result15 == null) {
                    XmlGtTypedHandler.$$$reportNull$$$0(17);
                }
                return result15;
            }
            HighlighterIterator iterator = ((EditorEx)editor).getHighlighter().createIterator(tagOffset);
            if (BraceMatchingUtil.matchBrace(editor.getDocument().getCharsSequence(), editedFile.getFileType(), iterator, true, true)) {
                PsiElement parent = tag.getParent();
                boolean hasBalance = true;
                block3: while (parent instanceof XmlTag) {
                    if (name.equals(((XmlTag)parent).getName())) {
                        hasBalance = false;
                        ASTNode astNode = XmlChildRole.CLOSING_TAG_NAME_FINDER.findChild(parent.getNode());
                        if (astNode == null) {
                            hasBalance = true;
                            break;
                        }
                        for (PsiElement el = parent.getNextSibling(); el != null; el = el.getNextSibling()) {
                            if (!(el instanceof PsiErrorElement) || !el.getText().startsWith("</" + name)) continue;
                            hasBalance = true;
                            break block3;
                        }
                    }
                    parent = parent.getParent();
                }
                if (hasBalance) {
                    TypedHandlerDelegate.Result result16 = TypedHandlerDelegate.Result.CONTINUE;
                    if (result16 == null) {
                        XmlGtTypedHandler.$$$reportNull$$$0(18);
                    }
                    return result16;
                }
            }
            Collection cdataReformatRanges = null;
            XmlElementDescriptor descriptor = tag.getDescriptor();
            EditorModificationUtil.insertStringAtCaret((Editor)editor, (String)("</" + name + ">"), (boolean)false, (int)0);
            if (descriptor instanceof XmlElementDescriptorWithCDataContent) {
                XmlElementDescriptorWithCDataContent cDataContainer = (XmlElementDescriptorWithCDataContent)descriptor;
                cdataReformatRanges = ContainerUtil.newSmartList();
                if (cDataContainer.requiresCdataBracesInContext(tag)) {
                    String cDataStart = "><![CDATA[";
                    String inserted = "><![CDATA[\n]]>";
                    EditorModificationUtil.insertStringAtCaret((Editor)editor, (String)"><![CDATA[\n]]>", (boolean)false, (int)"><![CDATA[".length());
                    int caretOffset = editor.getCaretModel().getOffset();
                    if (caretOffset >= "><![CDATA[".length()) {
                        cdataReformatRanges.add(TextRange.from((int)(caretOffset - "><![CDATA[".length()), (int)("><![CDATA[\n]]>".length() + 1)));
                    }
                }
            }
            if (cdataReformatRanges != null && !cdataReformatRanges.isEmpty()) {
                PsiDocumentManager.getInstance((Project)project).commitDocument(editor.getDocument());
                try {
                    CodeStyleManager.getInstance((Project)project).reformatText(file2, cdataReformatRanges);
                }
                catch (IncorrectOperationException e) {
                    LOG.error((Throwable)e);
                }
            }
            TypedHandlerDelegate.Result result17 = cdataReformatRanges != null && !cdataReformatRanges.isEmpty() ? TypedHandlerDelegate.Result.STOP : TypedHandlerDelegate.Result.CONTINUE;
            if (result17 == null) {
                XmlGtTypedHandler.$$$reportNull$$$0(19);
            }
            return result17;
        }
        TypedHandlerDelegate.Result result18 = TypedHandlerDelegate.Result.CONTINUE;
        if (result18 == null) {
            XmlGtTypedHandler.$$$reportNull$$$0(20);
        }
        return result18;
    }

    public static boolean fileContainsXmlLanguage(@Nullable PsiFile editedFile) {
        if (editedFile == null) {
            return false;
        }
        if (editedFile.getLanguage() instanceof XMLLanguage) {
            return true;
        }
        if (HtmlUtil.supportsXmlTypedHandlers(editedFile)) {
            return true;
        }
        FileViewProvider provider = editedFile.getViewProvider();
        if (provider.getBaseLanguage() instanceof XMLLanguage) {
            return true;
        }
        return provider instanceof TemplateLanguageFileViewProvider && ((TemplateLanguageFileViewProvider)provider).getTemplateDataLanguage() instanceof XMLLanguage;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 4: 
            case 5: 
            case 6: 
            case 7: 
            case 8: 
            case 9: 
            case 10: 
            case 11: 
            case 12: 
            case 13: 
            case 14: 
            case 15: 
            case 16: 
            case 17: 
            case 18: 
            case 19: 
            case 20: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 4: 
            case 5: 
            case 6: 
            case 7: 
            case 8: 
            case 9: 
            case 10: 
            case 11: 
            case 12: 
            case 13: 
            case 14: 
            case 15: 
            case 16: 
            case 17: 
            case 18: 
            case 19: 
            case 20: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "project";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "editor";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "editedFile";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "fileType";
                break;
            }
            case 4: 
            case 5: 
            case 6: 
            case 7: 
            case 8: 
            case 9: 
            case 10: 
            case 11: 
            case 12: 
            case 13: 
            case 14: 
            case 15: 
            case 16: 
            case 17: 
            case 18: 
            case 19: 
            case 20: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/codeInsight/editorActions/XmlGtTypedHandler";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/codeInsight/editorActions/XmlGtTypedHandler";
                break;
            }
            case 4: 
            case 5: 
            case 6: 
            case 7: 
            case 8: 
            case 9: 
            case 10: 
            case 11: 
            case 12: 
            case 13: 
            case 14: 
            case 15: 
            case 16: 
            case 17: 
            case 18: 
            case 19: 
            case 20: {
                objectArray = objectArray2;
                objectArray2[1] = "beforeCharTyped";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "beforeCharTyped";
                break;
            }
            case 4: 
            case 5: 
            case 6: 
            case 7: 
            case 8: 
            case 9: 
            case 10: 
            case 11: 
            case 12: 
            case 13: 
            case 14: 
            case 15: 
            case 16: 
            case 17: 
            case 18: 
            case 19: 
            case 20: {
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 4: 
            case 5: 
            case 6: 
            case 7: 
            case 8: 
            case 9: 
            case 10: 
            case 11: 
            case 12: 
            case 13: 
            case 14: 
            case 15: 
            case 16: 
            case 17: 
            case 18: 
            case 19: 
            case 20: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

