/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.database.actions;

import com.intellij.database.DatabaseMessages;
import com.intellij.database.autoconfig.DataSourceDetector;
import com.intellij.database.autoconfig.DataSourceRegistry;
import com.intellij.openapi.actionSystem.AnAction;
import com.intellij.openapi.actionSystem.AnActionEvent;
import com.intellij.openapi.application.ReadAction;
import com.intellij.openapi.progress.ProgressIndicator;
import com.intellij.openapi.progress.ProgressManager;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.ui.Messages;
import com.intellij.openapi.util.text.StringUtil;
import java.util.List;
import javax.swing.Icon;
import org.jetbrains.annotations.NotNull;

public class ImportDataSourceAction
extends AnAction {
    public boolean isDumbAware() {
        return false;
    }

    public void update(@NotNull AnActionEvent e) {
        Project project;
        if (e == null) {
            ImportDataSourceAction.$$$reportNull$$$0(0);
        }
        boolean enabled = (project = e.getProject()) != null && DataSourceDetector.EP_NAME.hasAnyExtensions();
        e.getPresentation().setEnabledAndVisible(enabled);
    }

    public void actionPerformed(@NotNull AnActionEvent e) {
        Project project;
        if (e == null) {
            ImportDataSourceAction.$$$reportNull$$$0(1);
        }
        if ((project = e.getProject()) == null) {
            return;
        }
        ImportDataSourceAction.doImportAction(project, false);
    }

    public static boolean doImportAction(@NotNull Project project, boolean newOnly) {
        if (project == null) {
            ImportDataSourceAction.$$$reportNull$$$0(2);
        }
        DataSourceRegistry registry = new DataSourceRegistry(project);
        List detectors = DataSourceDetector.EP_NAME.getExtensionList();
        ProgressManager.getInstance().runProcessWithProgressSynchronously(() -> {
            if (project == null) {
                ImportDataSourceAction.$$$reportNull$$$0(3);
            }
            ProgressIndicator indicator = ProgressManager.getInstance().getProgressIndicator();
            indicator.setIndeterminate(false);
            indicator.setText(DatabaseMessages.message((String)"message.discovering.datasources.to.import", (Object[])new Object[0]));
            double totalProgress = detectors.size();
            double curProgress = 0.0;
            for (DataSourceDetector detector : detectors) {
                indicator.setFraction((curProgress += 1.0) / totalProgress);
                String simpleName = StringUtil.trimEnd((String)detector.getClass().getSimpleName(), (String)DataSourceDetector.class.getSimpleName());
                indicator.setText2("Looking for " + simpleName + " connections...");
                ReadAction.run(() -> {
                    if (project == null) {
                        ImportDataSourceAction.$$$reportNull$$$0(4);
                    }
                    detector.collectDataSources(project, registry.getBuilder());
                });
            }
        }, DatabaseMessages.message((String)"dialog.title.import.datasources", (Object[])new Object[0]), true, project);
        if (newOnly) {
            registry.retainNewOnly();
        }
        if (registry.isEmpty()) {
            Messages.showMessageDialog((Project)project, (String)DatabaseMessages.message((String)"message.no.datasources.to.import.found", (Object[])new Object[0]), (String)DatabaseMessages.message((String)"dialog.title.import.datasources", (Object[])new Object[0]), (Icon)Messages.getWarningIcon());
            return true;
        }
        return registry.showDialog();
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[3];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "e";
                break;
            }
            case 2: 
            case 3: 
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "project";
                break;
            }
        }
        objectArray2[1] = "com/intellij/database/actions/ImportDataSourceAction";
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[2] = "update";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[2] = "actionPerformed";
                break;
            }
            case 2: {
                objectArray = objectArray2;
                objectArray2[2] = "doImportAction";
                break;
            }
            case 3: {
                objectArray = objectArray2;
                objectArray2[2] = "lambda$doImportAction$1";
                break;
            }
            case 4: {
                objectArray = objectArray2;
                objectArray2[2] = "lambda$null$0";
                break;
            }
        }
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
    }
}

