/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.database.remote.jdbc.helpers;

import com.intellij.database.remote.jdbc.helpers.JdbcHelper;
import com.intellij.database.remote.jdbc.helpers.JdbcNativeUtil;
import com.intellij.database.remote.jdbc.helpers.PgBaseJdbcHelper;
import java.sql.Connection;
import java.util.regex.Pattern;
import javax.sql.DataSource;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.dekaf.Redshift;
import org.jetbrains.dekaf.intermediate.DBExceptionRecognizer;
import org.jetbrains.dekaf.jdbc.JdbcIntermediateFacade;
import org.jetbrains.dekaf.jdbc.RedshiftExceptionRecognizer;
import org.jetbrains.dekaf.jdbc.RedshiftIntermediateFacade;

public class RsJdbcHelper
extends PgBaseJdbcHelper {
    private static final Pattern RS_VERSION_PATTERN = Pattern.compile("redshift\\s+" + JdbcNativeUtil.DEFAULT_VERSION_PATTERN, 2);

    public RsJdbcHelper(@Nullable String version, @Nullable Connection connection) {
        super(Redshift.RDBMS, version, connection);
    }

    public RsJdbcHelper() {
        this(null, null);
    }

    @Override
    @Nullable
    public String parseVersion(@Nullable String version) {
        return RsJdbcHelper.extractVersion(version);
    }

    @Override
    @NotNull
    public JdbcIntermediateFacade createFacade(@NotNull DataSource ds) {
        if (ds == null) {
            RsJdbcHelper.$$$reportNull$$$0(0);
        }
        RedshiftIntermediateFacade redshiftIntermediateFacade = new RedshiftIntermediateFacade(ds, 1, false, (DBExceptionRecognizer)RedshiftExceptionRecognizer.INSTANCE);
        if (redshiftIntermediateFacade == null) {
            RsJdbcHelper.$$$reportNull$$$0(1);
        }
        return redshiftIntermediateFacade;
    }

    @Override
    public boolean supportsLike() {
        return false;
    }

    @Override
    public void adjustType(@NotNull JdbcHelper.Type e) {
        if (e == null) {
            RsJdbcHelper.$$$reportNull$$$0(2);
        }
        if ("bpchar".equals(e.typeName)) {
            e.typeName = "char";
            return;
        }
        super.adjustType(e);
    }

    @NotNull
    protected static RsJdbcHelper create(@NotNull Connection delegate, @Nullable String versionStr) throws Exception {
        if (delegate == null) {
            RsJdbcHelper.$$$reportNull$$$0(3);
        }
        String version = RsJdbcHelper.extractVersion(versionStr);
        RsJdbcHelper rsJdbcHelper = new RsJdbcHelper(version, delegate);
        if (rsJdbcHelper == null) {
            RsJdbcHelper.$$$reportNull$$$0(4);
        }
        return rsJdbcHelper;
    }

    @Nullable
    public static String extractVersion(@Nullable String str) {
        return JdbcNativeUtil.findVersion(str, RS_VERSION_PATTERN);
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 1: 
            case 4: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 1: 
            case 4: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "ds";
                break;
            }
            case 1: 
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/database/remote/jdbc/helpers/RsJdbcHelper";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "e";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "delegate";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/database/remote/jdbc/helpers/RsJdbcHelper";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[1] = "createFacade";
                break;
            }
            case 4: {
                objectArray = objectArray2;
                objectArray2[1] = "create";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "createFacade";
                break;
            }
            case 1: 
            case 4: {
                break;
            }
            case 2: {
                objectArray = objectArray;
                objectArray[2] = "adjustType";
                break;
            }
            case 3: {
                objectArray = objectArray;
                objectArray[2] = "create";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 1: 
            case 4: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

