/*
 * Decompiled with CFR 0.152.
 */
package net.sf.saxon.lib;

import java.io.PrintStream;
import java.io.Serializable;
import javax.xml.transform.ErrorListener;
import javax.xml.transform.SourceLocator;
import javax.xml.transform.TransformerException;
import javax.xml.transform.dom.DOMLocator;
import net.sf.saxon.expr.XPathContext;
import net.sf.saxon.expr.instruct.AttributeSet;
import net.sf.saxon.expr.instruct.Instruction;
import net.sf.saxon.expr.instruct.Procedure;
import net.sf.saxon.expr.instruct.Template;
import net.sf.saxon.expr.instruct.UserFunction;
import net.sf.saxon.om.NodeInfo;
import net.sf.saxon.om.Sequence;
import net.sf.saxon.om.StandardNames;
import net.sf.saxon.om.StructuredQName;
import net.sf.saxon.trace.ContextStackFrame;
import net.sf.saxon.trace.ContextStackIterator;
import net.sf.saxon.trace.InstructionInfo;
import net.sf.saxon.trans.KeyDefinition;
import net.sf.saxon.trans.XPathException;
import net.sf.saxon.tree.util.Navigator;
import net.sf.saxon.type.ValidationException;
import org.xml.sax.SAXException;

public class StandardErrorListener
implements ErrorListener,
Serializable {
    private int recoveryPolicy = 1;
    private int warningCount = 0;
    private int maximumNumberOfWarnings = 25;
    protected transient PrintStream errorOutput = System.err;

    public StandardErrorListener makeAnother(int hostLanguage) {
        StandardErrorListener sel;
        try {
            sel = (StandardErrorListener)this.getClass().newInstance();
        }
        catch (InstantiationException e) {
            sel = new StandardErrorListener();
        }
        catch (IllegalAccessException e) {
            sel = new StandardErrorListener();
        }
        sel.errorOutput = this.errorOutput;
        return sel;
    }

    public void setErrorOutput(PrintStream writer) {
        this.errorOutput = writer;
    }

    public PrintStream getErrorOutput() {
        return this.errorOutput;
    }

    public void setRecoveryPolicy(int policy) {
        this.recoveryPolicy = policy;
    }

    public int getRecoveryPolicy() {
        return this.recoveryPolicy;
    }

    public void setMaximumNumberOfWarnings(int max) {
        this.maximumNumberOfWarnings = max;
    }

    public int getMaximumNumberOfWarnings() {
        return this.maximumNumberOfWarnings;
    }

    public void warning(TransformerException exception) throws TransformerException {
        if (this.recoveryPolicy == 0) {
            return;
        }
        if (this.errorOutput == null) {
            this.errorOutput = System.err;
        }
        String message = "";
        if (exception.getLocator() != null) {
            message = this.getLocationMessage(exception) + "\n  ";
        }
        message = message + StandardErrorListener.wordWrap(this.getExpandedMessage(exception));
        if (exception instanceof ValidationException) {
            this.errorOutput.println("Validation error " + message);
        } else {
            this.errorOutput.println("Warning: " + message);
            ++this.warningCount;
            if (this.warningCount > this.getMaximumNumberOfWarnings()) {
                this.errorOutput.println("No more warnings will be displayed");
                this.recoveryPolicy = 0;
                this.warningCount = 0;
            }
        }
    }

    public void error(TransformerException exception) throws TransformerException {
        String message;
        if (this.recoveryPolicy == 0 && !(exception instanceof ValidationException)) {
            return;
        }
        if (this.errorOutput == null) {
            this.errorOutput = System.err;
        }
        if (exception instanceof ValidationException) {
            String explanation = this.getExpandedMessage(exception);
            String constraintReference = ((ValidationException)exception).getConstraintReferenceMessage();
            String validationLocation = ((ValidationException)exception).getValidationLocationText();
            String contextLocation = ((ValidationException)exception).getContextLocationText();
            message = "Validation error " + this.getLocationMessage(exception) + "\n  " + StandardErrorListener.wordWrap(explanation) + StandardErrorListener.wordWrap(constraintReference != null ? "" : "\n  " + constraintReference) + StandardErrorListener.wordWrap(validationLocation.length() == 0 ? "" : "\n  " + validationLocation) + StandardErrorListener.wordWrap(contextLocation.length() == 0 ? "" : "\n  " + contextLocation);
        } else {
            String prefix = this.recoveryPolicy == 1 ? "Recoverable error " : "Error ";
            message = prefix + this.getLocationMessage(exception) + "\n  " + StandardErrorListener.wordWrap(this.getExpandedMessage(exception));
        }
        if (exception instanceof ValidationException) {
            this.errorOutput.println(message);
        } else if (this.recoveryPolicy == 1) {
            this.errorOutput.println(message);
            ++this.warningCount;
            if (this.warningCount > this.getMaximumNumberOfWarnings()) {
                this.errorOutput.println("No more warnings will be displayed");
                this.recoveryPolicy = 0;
                this.warningCount = 0;
            }
        } else {
            this.errorOutput.println(message);
            this.errorOutput.println("Processing terminated because error recovery is disabled");
            throw XPathException.makeXPathException(exception);
        }
    }

    public void fatalError(TransformerException exception) throws TransformerException {
        XPathContext context;
        String message;
        if (exception instanceof XPathException && ((XPathException)exception).hasBeenReported()) {
            return;
        }
        if (this.errorOutput == null) {
            this.errorOutput = System.err;
        }
        if (exception instanceof ValidationException) {
            String explanation = this.getExpandedMessage(exception);
            String constraintReference = ((ValidationException)exception).getConstraintReferenceMessage();
            if (constraintReference != null) {
                explanation = explanation + " (" + constraintReference + ')';
            }
            message = "Validation error " + this.getLocationMessage(exception) + "\n  " + StandardErrorListener.wordWrap(explanation);
        } else {
            message = "Error " + this.getLocationMessage(exception) + "\n  " + StandardErrorListener.wordWrap(this.getExpandedMessage(exception));
        }
        this.errorOutput.println(message);
        if (exception instanceof XPathException) {
            ((XPathException)exception).setHasBeenReported(true);
        }
        if (exception instanceof XPathException && (context = ((XPathException)exception).getXPathContext()) != null && this.getRecoveryPolicy() != 0) {
            this.outputStackTrace(this.errorOutput, context);
        }
    }

    protected void outputStackTrace(PrintStream out, XPathContext context) {
        StandardErrorListener.printStackTrace(out, context);
    }

    public String getLocationMessage(TransformerException err) {
        SourceLocator loc = err.getLocator();
        while (loc == null) {
            if (err.getException() instanceof TransformerException) {
                err = (TransformerException)err.getException();
                loc = err.getLocator();
                continue;
            }
            if (err.getCause() instanceof TransformerException) {
                err = (TransformerException)err.getCause();
                loc = err.getLocator();
                continue;
            }
            return "";
        }
        return StandardErrorListener.getLocationMessageText(loc);
    }

    private static String getLocationMessageText(SourceLocator loc) {
        boolean containsLineNumber;
        String locMessage = "";
        String systemId = null;
        NodeInfo node = null;
        String path = null;
        String nodeMessage = null;
        int lineNumber = -1;
        if (loc instanceof DOMLocator) {
            nodeMessage = "at " + ((DOMLocator)loc).getOriginatingNode().getNodeName() + ' ';
        } else if (loc instanceof NodeInfo) {
            node = (NodeInfo)((Object)loc);
            nodeMessage = "at " + node.getDisplayName() + ' ';
        } else if (loc instanceof ValidationException && (node = ((ValidationException)loc).getNode()) != null) {
            nodeMessage = "at " + node.getDisplayName() + ' ';
        } else if (loc instanceof ValidationException && loc.getLineNumber() == -1 && (path = ((ValidationException)loc).getPath()) != null) {
            nodeMessage = "at " + path + ' ';
        } else if (loc instanceof Instruction) {
            String instructionName = StandardErrorListener.getInstructionName((Instruction)loc);
            if (!"".equals(instructionName)) {
                nodeMessage = "at " + instructionName + ' ';
            }
            systemId = loc.getSystemId();
            lineNumber = loc.getLineNumber();
        } else if (loc instanceof Procedure) {
            String kind = "procedure";
            if (loc instanceof UserFunction) {
                kind = "function";
            } else if (loc instanceof Template) {
                kind = "template";
            } else if (loc instanceof AttributeSet) {
                kind = "attribute-set";
            } else if (loc instanceof KeyDefinition) {
                kind = "key";
            }
            systemId = loc.getSystemId();
            lineNumber = loc.getLineNumber();
            nodeMessage = "at " + kind + " ";
            StructuredQName name = ((InstructionInfo)loc).getObjectName();
            if (name != null) {
                nodeMessage = nodeMessage + name.toString();
                nodeMessage = nodeMessage + " ";
            }
        }
        if (lineNumber == -1) {
            lineNumber = loc.getLineNumber();
        }
        boolean bl = containsLineNumber = lineNumber != -1;
        if (node != null && !containsLineNumber) {
            nodeMessage = "at " + Navigator.getPath(node) + ' ';
        }
        if (nodeMessage != null) {
            locMessage = locMessage + nodeMessage;
        }
        if (containsLineNumber) {
            locMessage = locMessage + "on line " + lineNumber + ' ';
            if (loc.getColumnNumber() != -1) {
                locMessage = locMessage + "column " + loc.getColumnNumber() + ' ';
            }
        }
        if (systemId != null && systemId.length() == 0) {
            systemId = null;
        }
        if (systemId == null) {
            systemId = loc.getSystemId();
        }
        if (systemId != null && systemId.length() != 0) {
            locMessage = locMessage + (containsLineNumber ? "of " : "in ") + StandardErrorListener.abbreviatePath(systemId) + ':';
        }
        return locMessage;
    }

    public static String abbreviatePath(String uri) {
        if (uri == null) {
            return null;
        }
        int slash = uri.lastIndexOf(47);
        if (slash >= 0 && slash < uri.length() - 1) {
            return uri.substring(slash + 1);
        }
        return uri;
    }

    public String getExpandedMessage(TransformerException err) {
        String errorObjectDesc;
        Sequence errorObject;
        StructuredQName qCode = null;
        String additionalLocationText = null;
        if (err instanceof XPathException) {
            qCode = ((XPathException)err).getErrorCodeQName();
            additionalLocationText = ((XPathException)err).getAdditionalLocationText();
        }
        if (qCode == null && err.getException() instanceof XPathException) {
            qCode = ((XPathException)err.getException()).getErrorCodeQName();
        }
        String message = "";
        if (qCode != null) {
            message = qCode.getURI().equals("http://www.w3.org/2005/xqt-errors") ? qCode.getLocalPart() : qCode.getDisplayName();
        }
        if (additionalLocationText != null) {
            message = message + " " + additionalLocationText;
        }
        if (err instanceof XPathException && (errorObject = ((XPathException)err).getErrorObject()) != null && (errorObjectDesc = this.getErrorObjectString(errorObject)) != null) {
            message = message + " " + errorObjectDesc;
        }
        Throwable e = err;
        while (e != null) {
            String next = e.getMessage();
            if (next == null) {
                next = "";
            }
            if (next.startsWith("net.sf.saxon.trans.XPathException: ")) {
                next = next.substring(next.indexOf(": ") + 2);
            }
            if (!"TRaX Transform Exception".equals(next) && !message.endsWith(next)) {
                if (!"".equals(message) && !message.trim().endsWith(":")) {
                    message = message + ": ";
                }
                message = message + next;
            }
            if (e instanceof TransformerException) {
                e = e.getException();
                continue;
            }
            if (!(e instanceof SAXException)) break;
            e = ((SAXException)e).getException();
        }
        return message;
    }

    public String getErrorObjectString(Sequence errorObject) {
        return null;
    }

    public static String getInstructionName(Instruction inst) {
        try {
            int construct = inst.getInstructionNameCode();
            if (construct < 0) {
                return "";
            }
            if (construct < 1024 && construct != 155 && construct != 200) {
                if (inst.getExecutable().getHostLanguage() == 50) {
                    return StandardNames.getDisplayName(construct);
                }
                String s = StandardNames.getDisplayName(construct);
                int colon = s.indexOf(58);
                if (colon > 0) {
                    String local = s.substring(colon + 1);
                    if (local.equals("document")) {
                        return "document node constructor";
                    }
                    if (local.equals("text") || s.equals("value-of")) {
                        return "text node constructor";
                    }
                    if (local.equals("element")) {
                        return "computed element constructor";
                    }
                    if (local.equals("attribute")) {
                        return "computed attribute constructor";
                    }
                    if (local.equals("variable")) {
                        return "variable declaration";
                    }
                    if (local.equals("param")) {
                        return "external variable declaration";
                    }
                    if (local.equals("comment")) {
                        return "comment constructor";
                    }
                    if (local.equals("processing-instruction")) {
                        return "processing-instruction constructor";
                    }
                    if (local.equals("namespace")) {
                        return "namespace node constructor";
                    }
                }
                return s;
            }
            switch (construct) {
                case 2006: {
                    StructuredQName qName = inst.getObjectName();
                    return "element constructor <" + qName.getDisplayName() + '>';
                }
                case 2007: {
                    StructuredQName qName = inst.getObjectName();
                    return "attribute constructor " + qName.getDisplayName() + "=\"{...}\"";
                }
            }
            return "";
        }
        catch (Exception err) {
            return "";
        }
    }

    private static String wordWrap(String message) {
        int nl;
        if (message.length() > 1000) {
            message = message.substring(0, 1000);
        }
        if ((nl = message.indexOf(10)) < 0) {
            nl = message.length();
        }
        if (nl > 100) {
            int i;
            for (i = 90; message.charAt(i) != ' ' && i > 0; --i) {
            }
            if (i > 10) {
                return message.substring(0, i) + "\n  " + StandardErrorListener.wordWrap(message.substring(i + 1));
            }
            return message;
        }
        if (nl < message.length()) {
            return message.substring(0, nl) + '\n' + StandardErrorListener.wordWrap(message.substring(nl + 1));
        }
        return message;
    }

    public static void printStackTrace(PrintStream out, XPathContext context) {
        ContextStackIterator iterator = new ContextStackIterator(context);
        while (iterator.hasNext()) {
            ContextStackFrame frame = (ContextStackFrame)iterator.next();
            frame.print(out);
        }
    }
}

